/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.grpc;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.internal.BackoffPolicy;
import io.streamnative.oxia.client.api.Authentication;
import io.streamnative.oxia.client.grpc.OxiaStub;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class OxiaStubManager
implements AutoCloseable {
    @VisibleForTesting
    final Map<Key, OxiaStub> stubs = new ConcurrentHashMap<Key, OxiaStub>();
    @Nullable
    private final Authentication authentication;
    private final boolean enableTls;
    @Nullable
    private final BackoffPolicy.Provider backoffProvider;
    private final int maxConnectionPerNode;

    public OxiaStubManager(@Nullable Authentication authentication, boolean enableTls, @Nullable BackoffPolicy.Provider backoffProvider, int maxConnectionPerNode) {
        this.authentication = authentication;
        this.enableTls = enableTls;
        this.backoffProvider = backoffProvider;
        this.maxConnectionPerNode = maxConnectionPerNode;
    }

    public OxiaStub getStub(String address) {
        int random = ThreadLocalRandom.current().nextInt();
        int modKey = random % this.maxConnectionPerNode;
        if (modKey < 0) {
            modKey += this.maxConnectionPerNode;
        }
        return this.stubs.computeIfAbsent(new Key(address, modKey), key -> new OxiaStub(key.address, this.authentication, this.enableTls, this.backoffProvider));
    }

    @Override
    public void close() throws Exception {
        for (OxiaStub stub : this.stubs.values()) {
            stub.close();
        }
    }

    record Key(String address, int random) {
    }
}

