/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.grpc;

import com.google.common.base.Throwables;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.TlsChannelCredentials;
import io.grpc.internal.BackoffPolicy;
import io.streamnative.oxia.client.api.Authentication;
import io.streamnative.oxia.client.grpc.OxiaBackoffProvider;
import io.streamnative.oxia.proto.OxiaClientGrpc;
import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxiaStub
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(OxiaStub.class);
    public static String TLS_SCHEMA = "tls://";
    private final ManagedChannel channel;
    @NonNull
    private final OxiaClientGrpc.OxiaClientStub asyncStub;

    static String getAddress(String address) {
        if (address.startsWith(TLS_SCHEMA)) {
            return address.substring(TLS_SCHEMA.length());
        }
        return address;
    }

    static ChannelCredentials getChannelCredential(String address, boolean tlsEnabled) {
        return tlsEnabled || address.startsWith(TLS_SCHEMA) ? TlsChannelCredentials.newBuilder().build() : InsecureChannelCredentials.create();
    }

    public OxiaStub(String address, @Nullable Authentication authentication, boolean enableTls, @Nullable BackoffPolicy.Provider backoffProvider) {
        this(Grpc.newChannelBuilder((String)OxiaStub.getAddress(address), (ChannelCredentials)OxiaStub.getChannelCredential(address, enableTls)).directExecutor().build(), authentication, backoffProvider);
    }

    public OxiaStub(ManagedChannel channel) {
        this(channel, null, OxiaBackoffProvider.DEFAULT);
    }

    public OxiaStub(ManagedChannel channel, final @Nullable Authentication authentication, @Nullable BackoffPolicy.Provider oxiaBackoffPolicyProvider) {
        if (oxiaBackoffPolicyProvider != null) {
            this.configureBackoffPolicyIfPossible(channel, oxiaBackoffPolicyProvider);
        }
        this.channel = channel;
        this.asyncStub = authentication != null ? (OxiaClientGrpc.OxiaClientStub)OxiaClientGrpc.newStub((Channel)channel).withCallCredentials(new CallCredentials(){

            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                applier.apply(authentication.generateCredentials());
            }

            public void thisUsesUnstableApi() {
            }
        }) : OxiaClientGrpc.newStub((Channel)channel);
    }

    private void configureBackoffPolicyIfPossible(ManagedChannel channel, BackoffPolicy.Provider oxiaBackoffPolicyProvider) {
        try {
            Class<?> mcl = Class.forName("io.grpc.internal.ForwardingManagedChannel");
            Field delegate = mcl.getDeclaredField("delegate");
            delegate.setAccessible(true);
            Object mclInstance = delegate.get(channel);
            Class<?> mclInstanceKlass = Class.forName("io.grpc.internal.ManagedChannelImpl");
            Field backOffField = mclInstanceKlass.getDeclaredField("backoffPolicyProvider");
            backOffField.setAccessible(true);
            backOffField.set(mclInstance, oxiaBackoffPolicyProvider);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ex) {
            log.warn("Auto replace GRPC default backoff policy failed. fallback to the GRPC default implementation.", Throwables.getRootCause((Throwable)ex));
        }
    }

    public OxiaClientGrpc.OxiaClientStub async() {
        return this.asyncStub;
    }

    @Override
    public void close() throws Exception {
        this.channel.shutdown();
        try {
            if (!this.channel.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.channel.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.channel.shutdownNow();
        }
    }
}

