/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.DeleteOption;
import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.Notification;
import io.streamnative.oxia.client.api.PutOption;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.api.SyncOxiaClient;
import io.streamnative.oxia.client.api.exceptions.UnexpectedVersionIdException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import lombok.NonNull;

class SyncOxiaClientImpl
implements SyncOxiaClient {
    private final AsyncOxiaClient asyncClient;

    public PutResult put(@NonNull String key, byte @NonNull [] value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.put(key, value, Collections.emptySet());
    }

    @NonNull
    public PutResult put(@NonNull String key, byte @NonNull [] value, @NonNull Set<PutOption> options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try {
            return (PutResult)this.asyncClient.put(key, value, options).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public boolean delete(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.delete(key, Collections.emptySet());
    }

    public boolean delete(@NonNull String key, @NonNull Set<DeleteOption> options) throws UnexpectedVersionIdException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try {
            return (Boolean)this.asyncClient.delete(key, options).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void deleteRange(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        try {
            this.asyncClient.deleteRange(startKeyInclusive, endKeyExclusive).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public GetResult get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            return (GetResult)this.asyncClient.get(key).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @NonNull
    public List<String> list(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        try {
            return (List)this.asyncClient.list(startKeyInclusive, endKeyExclusive).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void notifications(@NonNull Consumer<Notification> notificationCallback) {
        if (notificationCallback == null) {
            throw new NullPointerException("notificationCallback is marked non-null but is null");
        }
        this.asyncClient.notifications(notificationCallback);
    }

    public void close() throws Exception {
        this.asyncClient.close();
    }

    SyncOxiaClientImpl(AsyncOxiaClient asyncClient) {
        this.asyncClient = asyncClient;
    }
}

