/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import io.streamnative.oxia.client.api.OptionEphemeral;
import io.streamnative.oxia.client.api.OptionVersionId;
import io.streamnative.oxia.client.api.PutOption;
import java.util.OptionalLong;
import java.util.Set;

public final class PutOptionsUtil {
    public static OptionalLong getVersionId(Set<PutOption> options) {
        if (options == null || options.isEmpty()) {
            return OptionalLong.empty();
        }
        boolean alreadyHasVersionId = false;
        long versionId = -1L;
        for (PutOption o : options) {
            if (!(o instanceof OptionVersionId)) continue;
            OptionVersionId e = (OptionVersionId)o;
            if (alreadyHasVersionId) {
                throw new IllegalArgumentException("Incompatible " + PutOption.class.getSimpleName() + "s: " + options);
            }
            versionId = e.versionId();
            alreadyHasVersionId = true;
        }
        if (alreadyHasVersionId) {
            return OptionalLong.of(versionId);
        }
        return OptionalLong.empty();
    }

    public static boolean isEphemeral(Set<PutOption> options) {
        if (options.isEmpty()) {
            return false;
        }
        for (PutOption option : options) {
            if (!(option instanceof OptionEphemeral)) continue;
            return true;
        }
        return false;
    }

    private PutOptionsUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

