/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.CompareWithSlash;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.DeleteOption;
import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.Notification;
import io.streamnative.oxia.client.api.PutOption;
import io.streamnative.oxia.client.api.PutResult;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;

class CachingAsyncOxiaClient
implements AsyncOxiaClient {
    @NonNull
    private final AsyncOxiaClient delegate;
    @NonNull
    private final AsyncLoadingCache<String, GetResult> recordCache;

    CachingAsyncOxiaClient(ClientConfig config, AsyncOxiaClient delegate) {
        this(delegate, new CacheFactory(config, delegate));
    }

    CachingAsyncOxiaClient(@NonNull AsyncOxiaClient delegate, @NonNull Supplier<AsyncLoadingCache<String, GetResult>> cacheFactory) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (cacheFactory == null) {
            throw new NullPointerException("cacheFactory is marked non-null but is null");
        }
        this.delegate = delegate;
        this.recordCache = cacheFactory.get();
        delegate.notifications(n -> this.recordCache.synchronous().invalidate((Object)n.key()));
    }

    @NonNull
    public CompletableFuture<PutResult> put(@NonNull String key, byte @NonNull [] value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.put(key, value, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<PutResult> put(@NonNull String key, byte @NonNull [] value, @NonNull Set<PutOption> options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.recordCache.synchronous().invalidate((Object)key);
        return this.delegate.put(key, value, options);
    }

    @NonNull
    public CompletableFuture<Boolean> delete(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.delete(key, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<Boolean> delete(@NonNull String key, @NonNull Set<DeleteOption> options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.recordCache.synchronous().invalidate((Object)key);
        return this.delegate.delete(key, options);
    }

    @NonNull
    public CompletableFuture<Void> deleteRange(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        List<String> cachedKeysInRange = this.recordCache.asMap().keySet().stream().filter(CompareWithSlash.withinRange(startKeyInclusive, endKeyExclusive)).toList();
        this.recordCache.synchronous().invalidateAll(cachedKeysInRange);
        return this.delegate.deleteRange(startKeyInclusive, endKeyExclusive);
    }

    @NonNull
    public CompletableFuture<GetResult> get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.recordCache.get((Object)key);
    }

    @NonNull
    public CompletableFuture<List<String>> list(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        return this.delegate.list(startKeyInclusive, endKeyExclusive);
    }

    public void notifications(@NonNull Consumer<Notification> notificationCallback) {
        if (notificationCallback == null) {
            throw new NullPointerException("notificationCallback is marked non-null but is null");
        }
        this.delegate.notifications(notificationCallback);
    }

    public void close() throws Exception {
        this.delegate.close();
    }

    static class CacheFactory
    implements Supplier<AsyncLoadingCache<String, GetResult>> {
        @NonNull
        private final ClientConfig config;
        @NonNull
        private final AsyncOxiaClient delegate;

        @Override
        @NonNull
        public AsyncLoadingCache<String, GetResult> get() {
            Caffeine builder = Caffeine.newBuilder().maximumSize((long)this.config.recordCacheCapacity());
            return builder.buildAsync((key, executor) -> this.delegate.get(key));
        }

        CacheFactory(@NonNull ClientConfig config, @NonNull AsyncOxiaClient delegate) {
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.config = config;
            this.delegate = delegate;
        }
    }
}

