/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.CompareWithSlash;
import io.streamnative.oxia.client.DeleteOptionsUtil;
import io.streamnative.oxia.client.PutOptionsUtil;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.DeleteOption;
import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.Notification;
import io.streamnative.oxia.client.api.PutOption;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.batch.BatchManager;
import io.streamnative.oxia.client.batch.Operation;
import io.streamnative.oxia.client.grpc.OxiaStub;
import io.streamnative.oxia.client.grpc.OxiaStubManager;
import io.streamnative.oxia.client.grpc.OxiaStubProvider;
import io.streamnative.oxia.client.metrics.Counter;
import io.streamnative.oxia.client.metrics.InstrumentProvider;
import io.streamnative.oxia.client.metrics.LatencyHistogram;
import io.streamnative.oxia.client.metrics.Unit;
import io.streamnative.oxia.client.metrics.UpDownCounter;
import io.streamnative.oxia.client.notify.NotificationManager;
import io.streamnative.oxia.client.session.SessionManager;
import io.streamnative.oxia.client.shard.ShardManager;
import io.streamnative.oxia.proto.ListRequest;
import io.streamnative.oxia.proto.ListResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import lombok.NonNull;

class AsyncOxiaClientImpl
implements AsyncOxiaClient {
    @NonNull
    private final String clientIdentifier;
    @NonNull
    private final InstrumentProvider instrumentProvider;
    @NonNull
    private final OxiaStubManager stubManager;
    @NonNull
    private final ShardManager shardManager;
    @NonNull
    private final NotificationManager notificationManager;
    @NonNull
    private final BatchManager readBatchManager;
    @NonNull
    private final BatchManager writeBatchManager;
    @NonNull
    private final SessionManager sessionManager;
    private volatile boolean closed;
    private final Counter counterPutBytes;
    private final Counter counterGetBytes;
    private final Counter counterListBytes;
    private final UpDownCounter gaugePendingPutRequests;
    private final UpDownCounter gaugePendingGetRequests;
    private final UpDownCounter gaugePendingListRequests;
    private final UpDownCounter gaugePendingDeleteRequests;
    private final UpDownCounter gaugePendingDeleteRangeRequests;
    private final UpDownCounter gaugePendingPutBytes;
    private final LatencyHistogram histogramPutLatency;
    private final LatencyHistogram histogramGetLatency;
    private final LatencyHistogram histogramDeleteLatency;
    private final LatencyHistogram histogramDeleteRangeLatency;
    private final LatencyHistogram histogramListLatency;
    private final ScheduledExecutorService scheduledExecutor;

    @NonNull
    static CompletableFuture<AsyncOxiaClient> newInstance(@NonNull ClientConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("oxia-client"));
        OxiaStubManager stubManager = new OxiaStubManager();
        InstrumentProvider instrumentProvider = new InstrumentProvider(config.openTelemetry(), config.namespace());
        OxiaStub serviceAddrStub = stubManager.getStub(config.serviceAddress());
        ShardManager shardManager = new ShardManager(executor, serviceAddrStub, instrumentProvider, config.namespace());
        NotificationManager notificationManager = new NotificationManager(executor, stubManager, shardManager, instrumentProvider);
        OxiaStubProvider stubProvider = new OxiaStubProvider(stubManager, shardManager);
        shardManager.addCallback(notificationManager);
        BatchManager readBatchManager = BatchManager.newReadBatchManager(config, stubProvider, instrumentProvider);
        SessionManager sessionManager = new SessionManager(executor, config, stubProvider, instrumentProvider);
        shardManager.addCallback(sessionManager);
        BatchManager writeBatchManager = BatchManager.newWriteBatchManager(config, stubProvider, sessionManager, instrumentProvider);
        AsyncOxiaClientImpl client = new AsyncOxiaClientImpl(config.clientIdentifier(), executor, instrumentProvider, stubManager, shardManager, notificationManager, readBatchManager, writeBatchManager, sessionManager);
        return shardManager.start().thenApply(v -> client);
    }

    AsyncOxiaClientImpl(@NonNull String clientIdentifier, @NonNull ScheduledExecutorService scheduledExecutor, @NonNull InstrumentProvider instrumentProvider, @NonNull OxiaStubManager stubManager, @NonNull ShardManager shardManager, @NonNull NotificationManager notificationManager, @NonNull BatchManager readBatchManager, @NonNull BatchManager writeBatchManager, @NonNull SessionManager sessionManager) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier is marked non-null but is null");
        }
        if (scheduledExecutor == null) {
            throw new NullPointerException("scheduledExecutor is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        if (stubManager == null) {
            throw new NullPointerException("stubManager is marked non-null but is null");
        }
        if (shardManager == null) {
            throw new NullPointerException("shardManager is marked non-null but is null");
        }
        if (notificationManager == null) {
            throw new NullPointerException("notificationManager is marked non-null but is null");
        }
        if (readBatchManager == null) {
            throw new NullPointerException("readBatchManager is marked non-null but is null");
        }
        if (writeBatchManager == null) {
            throw new NullPointerException("writeBatchManager is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        this.clientIdentifier = clientIdentifier;
        this.instrumentProvider = instrumentProvider;
        this.stubManager = stubManager;
        this.shardManager = shardManager;
        this.notificationManager = notificationManager;
        this.readBatchManager = readBatchManager;
        this.writeBatchManager = writeBatchManager;
        this.sessionManager = sessionManager;
        this.scheduledExecutor = scheduledExecutor;
        this.counterPutBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.counterGetBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"get"));
        this.counterListBytes = instrumentProvider.newCounter("oxia.client.list.size", Unit.Bytes, "Total number of bytes read in list operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"list"));
        this.gaugePendingPutRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.gaugePendingGetRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"get"));
        this.gaugePendingListRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"list"));
        this.gaugePendingDeleteRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete"));
        this.gaugePendingDeleteRangeRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete-range"));
        this.gaugePendingPutBytes = instrumentProvider.newUpDownCounter("oxia.client.ops.outstanding", Unit.Bytes, "Current number of outstanding bytes in put operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.histogramPutLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.histogramGetLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"get"));
        this.histogramDeleteLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete"));
        this.histogramDeleteRangeLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete-range"));
        this.histogramListLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"list"));
    }

    @NonNull
    public CompletableFuture<PutResult> put(String key, byte[] value) {
        return this.put(key, value, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<PutResult> put(String key, byte[] value, Set<PutOption> options) {
        CompletableFuture<Object> callback;
        long startTime = System.nanoTime();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            callback = this.internalPut(key, value, options);
        }
        catch (RuntimeException e) {
            callback = CompletableFuture.failedFuture(e);
        }
        return callback.whenComplete((putResult, throwable) -> {
            this.gaugePendingPutRequests.decrement();
            this.gaugePendingPutBytes.add(-value.length);
            if (throwable == null) {
                this.counterPutBytes.add(value.length);
                this.histogramPutLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramPutLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    private CompletableFuture<PutResult> internalPut(String key, byte[] value, Set<PutOption> options) {
        this.gaugePendingPutRequests.increment();
        this.gaugePendingPutBytes.add(value.length);
        long shardId = this.shardManager.getShardForKey(key);
        OptionalLong versionId = PutOptionsUtil.getVersionId(options);
        CompletableFuture<PutResult> future = new CompletableFuture<PutResult>();
        if (!PutOptionsUtil.isEphemeral(options)) {
            Operation.WriteOperation.PutOperation op = new Operation.WriteOperation.PutOperation(future, key, value, versionId, OptionalLong.empty(), Optional.empty());
            this.writeBatchManager.getBatcher(shardId).add(op);
        } else {
            ((CompletableFuture)this.sessionManager.getSession(shardId).thenAccept(session -> {
                Operation.WriteOperation.PutOperation op = new Operation.WriteOperation.PutOperation(future, key, value, versionId, OptionalLong.of(session.getSessionId()), Optional.of(this.clientIdentifier));
                this.writeBatchManager.getBatcher(shardId).add(op);
            })).exceptionally(ex -> {
                future.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        return future;
    }

    @NonNull
    public CompletableFuture<Boolean> delete(String key) {
        return this.delete(key, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<Boolean> delete(String key, Set<DeleteOption> options) {
        long startTime = System.nanoTime();
        this.gaugePendingDeleteRequests.increment();
        CompletableFuture<Boolean> callback = new CompletableFuture<Boolean>();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(key);
            OptionalLong versionId = DeleteOptionsUtil.getVersionId(options);
            long shardId = this.shardManager.getShardForKey(key);
            this.writeBatchManager.getBatcher(shardId).add(new Operation.WriteOperation.DeleteOperation(callback, key, versionId));
        }
        catch (RuntimeException e) {
            callback.completeExceptionally(e);
        }
        return callback.whenComplete((putResult, throwable) -> {
            this.gaugePendingDeleteRequests.decrement();
            if (throwable == null) {
                this.histogramDeleteLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramDeleteLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    @NonNull
    public CompletableFuture<Void> deleteRange(String startKeyInclusive, String endKeyExclusive) {
        CompletableFuture<Object> callback;
        long startTime = System.nanoTime();
        this.gaugePendingDeleteRangeRequests.increment();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(startKeyInclusive);
            Objects.requireNonNull(endKeyExclusive);
            CompletableFuture[] shardDeletes = (CompletableFuture[])this.shardManager.allShardIds().stream().map(this.writeBatchManager::getBatcher).map(b -> {
                CompletableFuture<Void> shardCallback = new CompletableFuture<Void>();
                b.add(new Operation.WriteOperation.DeleteRangeOperation(shardCallback, startKeyInclusive, endKeyExclusive));
                return shardCallback;
            }).toArray(CompletableFuture[]::new);
            callback = CompletableFuture.allOf(shardDeletes);
        }
        catch (RuntimeException e) {
            callback = CompletableFuture.failedFuture(e);
        }
        return callback.whenComplete((putResult, throwable) -> {
            this.gaugePendingDeleteRequests.decrement();
            if (throwable == null) {
                this.histogramDeleteRangeLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramDeleteRangeLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    @NonNull
    public CompletableFuture<GetResult> get(String key) {
        long startTime = System.nanoTime();
        this.gaugePendingGetRequests.increment();
        CompletableFuture<GetResult> callback = new CompletableFuture<GetResult>();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(key);
            long shardId = this.shardManager.getShardForKey(key);
            this.readBatchManager.getBatcher(shardId).add(new Operation.ReadOperation.GetOperation(callback, key));
        }
        catch (RuntimeException e) {
            callback.completeExceptionally(e);
        }
        return callback.whenComplete((getResult, throwable) -> {
            this.gaugePendingGetRequests.decrement();
            if (throwable == null) {
                if (getResult != null) {
                    this.counterGetBytes.add(getResult.getValue().length);
                }
                this.histogramGetLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramGetLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    @NonNull
    public CompletableFuture<List<String>> list(String startKeyInclusive, String endKeyExclusive) {
        CompletableFuture<Object> callback;
        long startTime = System.nanoTime();
        this.gaugePendingListRequests.increment();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(startKeyInclusive);
            Objects.requireNonNull(endKeyExclusive);
            callback = this.internalList(startKeyInclusive, endKeyExclusive);
        }
        catch (Exception e) {
            callback = CompletableFuture.failedFuture(e);
        }
        return callback.whenComplete((listResult, throwable) -> {
            this.gaugePendingListRequests.decrement();
            if (throwable == null) {
                this.counterListBytes.add(listResult.stream().mapToInt(String::length).sum());
                this.histogramListLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramListLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    public void notifications(@NonNull Consumer<Notification> notificationCallback) {
        if (notificationCallback == null) {
            throw new NullPointerException("notificationCallback is marked non-null but is null");
        }
        this.checkIfClosed();
        this.notificationManager.registerCallback(notificationCallback);
    }

    private CompletableFuture<List<String>> internalList(String startKeyInclusive, String endKeyExclusive) {
        ArrayList<CompletableFuture<List<String>>> futures = new ArrayList<CompletableFuture<List<String>>>();
        for (long shardId : this.shardManager.allShardIds()) {
            futures.add(this.internalShardlist(shardId, startKeyInclusive, endKeyExclusive));
        }
        CompletableFuture<List<String>> result = new CompletableFuture<List<String>>();
        ArrayList list = new ArrayList();
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
            for (CompletableFuture future : futures) {
                list.addAll((Collection)future.join());
            }
            list.sort(CompareWithSlash.INSTANCE);
            result.complete(list);
        })).exceptionally(ex -> {
            result.completeExceptionally((Throwable)ex);
            return null;
        });
        return result;
    }

    private CompletableFuture<List<String>> internalShardlist(long shardId, String startKeyInclusive, String endKeyExclusive) {
        String leader = this.shardManager.leader(shardId);
        OxiaStub stub = this.stubManager.getStub(leader);
        ListRequest request = ListRequest.newBuilder().setShardId(shardId).setStartInclusive(startKeyInclusive).setEndExclusive(endKeyExclusive).build();
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        final ArrayList result = new ArrayList();
        stub.async().list(request, new StreamObserver<ListResponse>(){

            public void onNext(ListResponse response) {
                for (int i = 0; i < response.getKeysCount(); ++i) {
                    result.add(response.getKeys(i));
                }
            }

            public void onError(Throwable t) {
                future.completeExceptionally(t);
            }

            public void onCompleted() {
                future.complete(result);
            }
        });
        return future;
    }

    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.readBatchManager.close();
        this.writeBatchManager.close();
        this.sessionManager.close();
        this.notificationManager.close();
        this.shardManager.close();
        this.stubManager.close();
        this.scheduledExecutor.shutdownNow();
    }

    private void checkIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client has been closed");
        }
    }
}

