/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.api;

import java.util.Optional;
import lombok.NonNull;

public record Version(long versionId, long createdTimestamp, long modifiedTimestamp, long modificationsCount, @NonNull Optional<Long> sessionId, @NonNull Optional<String> clientIdentifier) {
    public static final long KeyNotExists = -1L;

    public Version(long versionId, long createdTimestamp, long modifiedTimestamp, long modificationsCount, @NonNull Optional<Long> sessionId, @NonNull Optional<String> clientIdentifier) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier is marked non-null but is null");
        }
        Version.requireValidVersionId(versionId);
        Version.requireValidTimestamp(createdTimestamp);
        Version.requireValidTimestamp(modifiedTimestamp);
        Version.requireValidModificationsCount(modificationsCount);
    }

    public static void requireValidVersionId(long versionId) {
        if (versionId < 0L) {
            throw new IllegalArgumentException("Invalid versionId: " + versionId);
        }
    }

    public static void requireValidTimestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Invalid timestamp: " + timestamp);
        }
    }

    public static void requireValidModificationsCount(long modificationsCount) {
        if (modificationsCount < 0L) {
            throw new IllegalArgumentException("Invalid modificationsCount: " + modificationsCount);
        }
    }
}

