/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import org.apache.pulsar.broker.service.SystemTopicTxnBufferSnapshotService;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.broker.systopic.TransactionBufferSnapshotBaseSystemTopicClient;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.common.events.EventType;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceEventsSystemTopicFactory {
    private final PulsarClient client;
    private static final Logger log = LoggerFactory.getLogger(NamespaceEventsSystemTopicFactory.class);

    public NamespaceEventsSystemTopicFactory(PulsarClient client) {
        this.client = client;
    }

    public TopicPoliciesSystemTopicClient createTopicPoliciesSystemTopicClient(NamespaceName namespaceName) {
        TopicName topicName = TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)namespaceName, (String)"__change_events");
        log.info("Create topic policies system topic client {}", (Object)topicName.toString());
        return new TopicPoliciesSystemTopicClient(this.client, topicName);
    }

    public <T> TransactionBufferSnapshotBaseSystemTopicClient<T> createTransactionBufferSystemTopicClient(TopicName systemTopicName, SystemTopicTxnBufferSnapshotService<T> systemTopicTxnBufferSnapshotService, Class<T> schemaType) {
        log.info("Create transaction buffer snapshot client, topicName : {}", (Object)systemTopicName.toString());
        return new TransactionBufferSnapshotBaseSystemTopicClient<T>(this.client, systemTopicName, systemTopicTxnBufferSnapshotService, schemaType);
    }

    public static TopicName getSystemTopicName(NamespaceName namespaceName, EventType eventType) {
        return switch (eventType) {
            default -> throw new IncompatibleClassChangeError();
            case EventType.TOPIC_POLICY -> TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)namespaceName, (String)"__change_events");
            case EventType.TRANSACTION_BUFFER_SNAPSHOT -> TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)namespaceName, (String)"__transaction_buffer_snapshot");
            case EventType.TRANSACTION_BUFFER_SNAPSHOT_SEGMENTS -> TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)namespaceName, (String)"__transaction_buffer_snapshot_segments");
            case EventType.TRANSACTION_BUFFER_SNAPSHOT_INDEXES -> TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)namespaceName, (String)"__transaction_buffer_snapshot_indexes");
        };
    }
}

