/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.prometheus.client.Gauge;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.pulsar.broker.service.ServerCnx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerCnxThrottleTracker {
    private static final Logger log = LoggerFactory.getLogger(ServerCnxThrottleTracker.class);
    private static final Gauge throttledConnections = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_broker_throttled_connections")).help("Counter of connections throttled because of per-connection limit")).register();
    private static final AtomicIntegerFieldUpdater<ServerCnxThrottleTracker> THROTTLE_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ServerCnxThrottleTracker.class, "throttleCount");
    private static final AtomicIntegerFieldUpdater<ServerCnxThrottleTracker> PENDING_SEND_REQUESTS_EXCEEDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ServerCnxThrottleTracker.class, "pendingSendRequestsExceeded");
    private static final AtomicIntegerFieldUpdater<ServerCnxThrottleTracker> PUBLISH_BUFFER_LIMITING_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ServerCnxThrottleTracker.class, "publishBufferLimiting");
    private final ServerCnx serverCnx;
    private volatile int throttleCount;
    private volatile int pendingSendRequestsExceeded;
    private volatile int publishBufferLimiting;

    public ServerCnxThrottleTracker(ServerCnx serverCnx) {
        this.serverCnx = serverCnx;
    }

    public void incrementThrottleCount() {
        int currentThrottleCount = THROTTLE_COUNT_UPDATER.incrementAndGet(this);
        if (currentThrottleCount == 1) {
            this.changeAutoRead(false);
        }
    }

    public void decrementThrottleCount() {
        int currentThrottleCount = THROTTLE_COUNT_UPDATER.decrementAndGet(this);
        if (currentThrottleCount == 0) {
            this.changeAutoRead(true);
        }
    }

    private void changeAutoRead(boolean autoRead) {
        if (this.isChannelActive()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Setting auto read to {}", (Object)this.serverCnx.toString(), (Object)autoRead);
            }
            this.serverCnx.ctx().channel().config().setAutoRead(autoRead);
        }
        if (autoRead) {
            this.serverCnx.getBrokerService().resumedConnections(1);
        } else if (this.isChannelActive()) {
            this.serverCnx.increasePublishLimitedTimesForTopics();
            this.serverCnx.getBrokerService().pausedConnections(1);
        }
    }

    private boolean isChannelActive() {
        return this.serverCnx.isActive() && this.serverCnx.ctx() != null && this.serverCnx.ctx().channel().isActive();
    }

    public void setPublishBufferLimiting(boolean throttlingEnabled) {
        this.changeThrottlingFlag(PUBLISH_BUFFER_LIMITING_UPDATER, throttlingEnabled);
    }

    public void setPendingSendRequestsExceeded(boolean throttlingEnabled) {
        boolean changed = this.changeThrottlingFlag(PENDING_SEND_REQUESTS_EXCEEDED_UPDATER, throttlingEnabled);
        if (changed) {
            if (throttlingEnabled) {
                throttledConnections.inc();
            } else {
                throttledConnections.dec();
            }
        }
    }

    private boolean changeThrottlingFlag(AtomicIntegerFieldUpdater<ServerCnxThrottleTracker> throttlingFlagFieldUpdater, boolean throttlingEnabled) {
        if (!this.isChannelActive()) {
            return false;
        }
        if (throttlingFlagFieldUpdater.compareAndSet(this, ServerCnxThrottleTracker.booleanToInt(!throttlingEnabled), ServerCnxThrottleTracker.booleanToInt(throttlingEnabled))) {
            if (throttlingEnabled) {
                this.incrementThrottleCount();
            } else {
                this.decrementThrottleCount();
            }
            return true;
        }
        return false;
    }

    private static int booleanToInt(boolean value) {
        return value ? 1 : 0;
    }
}

