/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;

public class BrokerLoadData {
    private static final double DEFAULT_RESOURCE_USAGE = 1.0;
    private ResourceUsage cpu = new ResourceUsage();
    private ResourceUsage memory = new ResourceUsage();
    private ResourceUsage directMemory = new ResourceUsage();
    private ResourceUsage bandwidthIn = new ResourceUsage();
    private ResourceUsage bandwidthOut = new ResourceUsage();
    private double msgThroughputIn;
    private double msgThroughputOut;
    private double msgRateIn;
    private double msgRateOut;
    private long bundleCount;
    private long topics;
    private double maxResourceUsage = 1.0;
    private double weightedMaxEMA = 1.0;
    private double msgThroughputEMA = 0.0;
    private long updatedAt;
    private long reportedAt;

    public void update(SystemResourceUsage usage, double msgThroughputIn, double msgThroughputOut, double msgRateIn, double msgRateOut, long bundleCount, long topics, ServiceConfiguration conf) {
        this.updateSystemResourceUsage(usage.cpu, usage.memory, usage.directMemory, usage.bandwidthIn, usage.bandwidthOut);
        this.msgThroughputIn = msgThroughputIn;
        this.msgThroughputOut = msgThroughputOut;
        this.msgRateIn = msgRateIn;
        this.msgRateOut = msgRateOut;
        this.bundleCount = bundleCount;
        this.topics = topics;
        this.updateFeatures(conf);
        this.updatedAt = System.currentTimeMillis();
    }

    public void update(BrokerLoadData other) {
        this.updateSystemResourceUsage(other.cpu, other.memory, other.directMemory, other.bandwidthIn, other.bandwidthOut);
        this.msgThroughputIn = other.msgThroughputIn;
        this.msgThroughputOut = other.msgThroughputOut;
        this.msgRateIn = other.msgRateIn;
        this.msgRateOut = other.msgRateOut;
        this.bundleCount = other.bundleCount;
        this.topics = other.topics;
        this.weightedMaxEMA = other.weightedMaxEMA;
        this.msgThroughputEMA = other.msgThroughputEMA;
        this.maxResourceUsage = other.maxResourceUsage;
        this.updatedAt = other.updatedAt;
        this.reportedAt = other.reportedAt;
    }

    private void updateSystemResourceUsage(ResourceUsage cpu, ResourceUsage memory, ResourceUsage directMemory, ResourceUsage bandwidthIn, ResourceUsage bandwidthOut) {
        this.cpu = cpu;
        this.memory = memory;
        this.directMemory = directMemory;
        this.bandwidthIn = bandwidthIn;
        this.bandwidthOut = bandwidthOut;
    }

    private void updateFeatures(ServiceConfiguration conf) {
        this.updateMaxResourceUsage();
        this.updateWeightedMaxEMA(conf);
        this.updateMsgThroughputEMA(conf);
    }

    private void updateMaxResourceUsage() {
        this.maxResourceUsage = LocalBrokerData.max((double[])new double[]{this.cpu.percentUsage(), this.directMemory.percentUsage(), this.bandwidthIn.percentUsage(), this.bandwidthOut.percentUsage()}) / 100.0;
    }

    private double getMaxResourceUsageWithWeight(double cpuWeight, double memoryWeight, double directMemoryWeight, double bandwidthInWeight, double bandwidthOutWeight) {
        return LocalBrokerData.max((double[])new double[]{(double)this.cpu.percentUsage() * cpuWeight, (double)this.memory.percentUsage() * memoryWeight, (double)this.directMemory.percentUsage() * directMemoryWeight, (double)this.bandwidthIn.percentUsage() * bandwidthInWeight, (double)this.bandwidthOut.percentUsage() * bandwidthOutWeight}) / 100.0;
    }

    private void updateWeightedMaxEMA(ServiceConfiguration conf) {
        double historyPercentage = conf.getLoadBalancerHistoryResourcePercentage();
        double weightedMax = this.getMaxResourceUsageWithWeight(conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerMemoryResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwithInResourceWeight(), conf.getLoadBalancerBandwithOutResourceWeight());
        this.weightedMaxEMA = this.updatedAt == 0L ? weightedMax : this.weightedMaxEMA * historyPercentage + (1.0 - historyPercentage) * weightedMax;
    }

    private void updateMsgThroughputEMA(ServiceConfiguration conf) {
        double historyPercentage = conf.getLoadBalancerHistoryResourcePercentage();
        double msgThroughput = this.msgThroughputIn + this.msgThroughputOut;
        this.msgThroughputEMA = this.updatedAt == 0L ? msgThroughput : this.msgThroughputEMA * historyPercentage + (1.0 - historyPercentage) * msgThroughput;
    }

    public void clear() {
        this.cpu = new ResourceUsage();
        this.memory = new ResourceUsage();
        this.directMemory = new ResourceUsage();
        this.bandwidthIn = new ResourceUsage();
        this.bandwidthOut = new ResourceUsage();
        this.maxResourceUsage = 1.0;
        this.weightedMaxEMA = 1.0;
        this.msgThroughputEMA = 0.0;
        this.msgThroughputIn = 0.0;
        this.msgThroughputOut = 0.0;
        this.msgRateIn = 0.0;
        this.msgRateOut = 0.0;
        this.bundleCount = 0L;
        this.topics = 0L;
        this.updatedAt = 0L;
        this.reportedAt = 0L;
    }

    public String toString(ServiceConfiguration conf) {
        return String.format("cpu= %.2f%%, memory= %.2f%%, directMemory= %.2f%%, bandwithIn= %.2f%%, bandwithOut= %.2f%%, cpuWeight= %f, memoryWeight= %f, directMemoryWeight= %f, bandwithInResourceWeight= %f, bandwithOutResourceWeight= %f, msgThroughputIn= %.2f, msgThroughputOut= %.2f, msgRateIn= %.2f, msgRateOut= %.2f, bundleCount= %d, maxResourceUsage= %.2f%%, weightedMaxEMA= %.2f%%, msgThroughputEMA= %.2f, updatedAt= %d, reportedAt= %d", Float.valueOf(this.cpu.percentUsage()), Float.valueOf(this.memory.percentUsage()), Float.valueOf(this.directMemory.percentUsage()), Float.valueOf(this.bandwidthIn.percentUsage()), Float.valueOf(this.bandwidthOut.percentUsage()), conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerMemoryResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwithInResourceWeight(), conf.getLoadBalancerBandwithOutResourceWeight(), this.msgThroughputIn, this.msgThroughputOut, this.msgRateIn, this.msgRateOut, this.bundleCount, this.maxResourceUsage * 100.0, this.weightedMaxEMA * 100.0, this.msgThroughputEMA, this.updatedAt, this.reportedAt);
    }

    public List<Metrics> toMetrics(String advertisedBrokerAddress) {
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("metric", "loadBalancing");
        dimensions.put("broker", advertisedBrokerAddress);
        Metrics metric = Metrics.create(dimensions);
        metric.put("brk_lb_cpu_usage", (Object)Float.valueOf(this.getCpu().percentUsage()));
        metric.put("brk_lb_memory_usage", (Object)Float.valueOf(this.getMemory().percentUsage()));
        metric.put("brk_lb_directMemory_usage", (Object)Float.valueOf(this.getDirectMemory().percentUsage()));
        metric.put("brk_lb_bandwidth_in_usage", (Object)Float.valueOf(this.getBandwidthIn().percentUsage()));
        metric.put("brk_lb_bandwidth_out_usage", (Object)Float.valueOf(this.getBandwidthOut().percentUsage()));
        metrics.add(metric);
        HashMap<String, String> dim = new HashMap<String, String>(dimensions);
        dim.put("feature", "max_ema");
        Metrics metric2 = Metrics.create(dim);
        metric2.put("brk_lb_resource_usage", (Object)this.weightedMaxEMA);
        metrics.add(metric2);
        dim = new HashMap(dimensions);
        dim.put("feature", "max");
        metric2 = Metrics.create(dim);
        metric2.put("brk_lb_resource_usage", (Object)this.maxResourceUsage);
        metrics.add(metric2);
        return metrics;
    }

    public ResourceUsage getCpu() {
        return this.cpu;
    }

    public ResourceUsage getMemory() {
        return this.memory;
    }

    public ResourceUsage getDirectMemory() {
        return this.directMemory;
    }

    public ResourceUsage getBandwidthIn() {
        return this.bandwidthIn;
    }

    public ResourceUsage getBandwidthOut() {
        return this.bandwidthOut;
    }

    public double getMsgThroughputIn() {
        return this.msgThroughputIn;
    }

    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    public long getBundleCount() {
        return this.bundleCount;
    }

    public long getTopics() {
        return this.topics;
    }

    public double getMaxResourceUsage() {
        return this.maxResourceUsage;
    }

    public double getWeightedMaxEMA() {
        return this.weightedMaxEMA;
    }

    public double getMsgThroughputEMA() {
        return this.msgThroughputEMA;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public long getReportedAt() {
        return this.reportedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerLoadData)) {
            return false;
        }
        BrokerLoadData other = (BrokerLoadData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputIn(), other.getMsgThroughputIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgRateIn(), other.getMsgRateIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (this.getBundleCount() != other.getBundleCount()) {
            return false;
        }
        if (this.getTopics() != other.getTopics()) {
            return false;
        }
        if (Double.compare(this.getMaxResourceUsage(), other.getMaxResourceUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getWeightedMaxEMA(), other.getWeightedMaxEMA()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputEMA(), other.getMsgThroughputEMA()) != 0) {
            return false;
        }
        if (this.getUpdatedAt() != other.getUpdatedAt()) {
            return false;
        }
        if (this.getReportedAt() != other.getReportedAt()) {
            return false;
        }
        ResourceUsage this$cpu = this.getCpu();
        ResourceUsage other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) {
            return false;
        }
        ResourceUsage this$memory = this.getMemory();
        ResourceUsage other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) {
            return false;
        }
        ResourceUsage this$directMemory = this.getDirectMemory();
        ResourceUsage other$directMemory = other.getDirectMemory();
        if (this$directMemory == null ? other$directMemory != null : !this$directMemory.equals(other$directMemory)) {
            return false;
        }
        ResourceUsage this$bandwidthIn = this.getBandwidthIn();
        ResourceUsage other$bandwidthIn = other.getBandwidthIn();
        if (this$bandwidthIn == null ? other$bandwidthIn != null : !this$bandwidthIn.equals(other$bandwidthIn)) {
            return false;
        }
        ResourceUsage this$bandwidthOut = this.getBandwidthOut();
        ResourceUsage other$bandwidthOut = other.getBandwidthOut();
        return !(this$bandwidthOut == null ? other$bandwidthOut != null : !this$bandwidthOut.equals(other$bandwidthOut));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrokerLoadData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgThroughputIn = Double.doubleToLongBits(this.getMsgThroughputIn());
        result = result * 59 + (int)($msgThroughputIn >>> 32 ^ $msgThroughputIn);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $msgRateIn = Double.doubleToLongBits(this.getMsgRateIn());
        result = result * 59 + (int)($msgRateIn >>> 32 ^ $msgRateIn);
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $bundleCount = this.getBundleCount();
        result = result * 59 + (int)($bundleCount >>> 32 ^ $bundleCount);
        long $topics = this.getTopics();
        result = result * 59 + (int)($topics >>> 32 ^ $topics);
        long $maxResourceUsage = Double.doubleToLongBits(this.getMaxResourceUsage());
        result = result * 59 + (int)($maxResourceUsage >>> 32 ^ $maxResourceUsage);
        long $weightedMaxEMA = Double.doubleToLongBits(this.getWeightedMaxEMA());
        result = result * 59 + (int)($weightedMaxEMA >>> 32 ^ $weightedMaxEMA);
        long $msgThroughputEMA = Double.doubleToLongBits(this.getMsgThroughputEMA());
        result = result * 59 + (int)($msgThroughputEMA >>> 32 ^ $msgThroughputEMA);
        long $updatedAt = this.getUpdatedAt();
        result = result * 59 + (int)($updatedAt >>> 32 ^ $updatedAt);
        long $reportedAt = this.getReportedAt();
        result = result * 59 + (int)($reportedAt >>> 32 ^ $reportedAt);
        ResourceUsage $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        ResourceUsage $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : $memory.hashCode());
        ResourceUsage $directMemory = this.getDirectMemory();
        result = result * 59 + ($directMemory == null ? 43 : $directMemory.hashCode());
        ResourceUsage $bandwidthIn = this.getBandwidthIn();
        result = result * 59 + ($bandwidthIn == null ? 43 : $bandwidthIn.hashCode());
        ResourceUsage $bandwidthOut = this.getBandwidthOut();
        result = result * 59 + ($bandwidthOut == null ? 43 : $bandwidthOut.hashCode());
        return result;
    }

    public String toString() {
        return "BrokerLoadData(cpu=" + this.getCpu() + ", memory=" + this.getMemory() + ", directMemory=" + this.getDirectMemory() + ", bandwidthIn=" + this.getBandwidthIn() + ", bandwidthOut=" + this.getBandwidthOut() + ", msgThroughputIn=" + this.getMsgThroughputIn() + ", msgThroughputOut=" + this.getMsgThroughputOut() + ", msgRateIn=" + this.getMsgRateIn() + ", msgRateOut=" + this.getMsgRateOut() + ", bundleCount=" + this.getBundleCount() + ", topics=" + this.getTopics() + ", maxResourceUsage=" + this.getMaxResourceUsage() + ", weightedMaxEMA=" + this.getWeightedMaxEMA() + ", msgThroughputEMA=" + this.getMsgThroughputEMA() + ", updatedAt=" + this.getUpdatedAt() + ", reportedAt=" + this.getReportedAt() + ")";
    }

    public void setReportedAt(long reportedAt) {
        this.reportedAt = reportedAt;
    }
}

