/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

public class LeaderBroker {
    private String brokerId;
    private String serviceUrl;

    public String getBrokerId() {
        if (this.brokerId != null) {
            return this.brokerId;
        }
        return LeaderBroker.parseHostAndPort(this.serviceUrl);
    }

    private static String parseHostAndPort(String serviceUrl) {
        int uriSeparatorPos = serviceUrl.indexOf("://");
        if (uriSeparatorPos == -1) {
            throw new IllegalArgumentException("'" + serviceUrl + "' isn't an URI.");
        }
        return serviceUrl.substring(uriSeparatorPos + 3);
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaderBroker)) {
            return false;
        }
        LeaderBroker other = (LeaderBroker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$brokerId = this.getBrokerId();
        String other$brokerId = other.getBrokerId();
        if (this$brokerId == null ? other$brokerId != null : !this$brokerId.equals(other$brokerId)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        return !(this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeaderBroker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $brokerId = this.getBrokerId();
        result = result * 59 + ($brokerId == null ? 43 : $brokerId.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        return result;
    }

    public String toString() {
        return "LeaderBroker(brokerId=" + this.getBrokerId() + ", serviceUrl=" + this.getServiceUrl() + ")";
    }

    public LeaderBroker(String brokerId, String serviceUrl) {
        this.brokerId = brokerId;
        this.serviceUrl = serviceUrl;
    }

    public LeaderBroker() {
    }
}

