/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.PulsarAdminImpl;
import picocli.CommandLine;

public abstract class CmdBase {
    private final CommandLine commander;
    private final Supplier<PulsarAdmin> adminSupplier;
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = 60000L;

    public CmdBase(String cmdName, Supplier<PulsarAdmin> adminSupplier) {
        this.adminSupplier = adminSupplier;
        this.commander = new CommandLine((Object)this);
        this.commander.setCommandName(cmdName);
    }

    public boolean run(String[] args) {
        return this.commander.execute(args) == 0;
    }

    protected PulsarAdmin getAdmin() {
        return this.adminSupplier.get();
    }

    protected long getReadTimeoutMs() {
        PulsarAdmin pulsarAdmin = this.getAdmin();
        if (pulsarAdmin instanceof PulsarAdminImpl) {
            return ((PulsarAdminImpl)pulsarAdmin).getClientConfigData().getReadTimeoutMs();
        }
        return 60000L;
    }

    protected <T> T sync(Supplier<CompletableFuture<T>> executor) throws PulsarAdminException {
        try {
            return executor.get().get(this.getReadTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw PulsarAdminException.wrap((PulsarAdminException)BaseResource.getApiException((Throwable)e.getCause()));
        }
        catch (Exception e) {
            throw PulsarAdminException.wrap((PulsarAdminException)BaseResource.getApiException((Throwable)e));
        }
    }

    Map<String, String> parseListKeyValueMap(List<String> metadata) {
        HashMap<String, String> map = null;
        if (metadata != null && !metadata.isEmpty()) {
            map = new HashMap<String, String>();
            for (String property : metadata) {
                int pos = property.indexOf(61);
                if (pos <= 0) {
                    throw new ParameterException(String.format("Invalid key value pair '%s', valid format like 'a=b'.", property));
                }
                map.put(property.substring(0, pos), property.substring(pos + 1));
            }
        }
        return map;
    }

    protected CommandLine getCommander() {
        return this.commander;
    }

    protected void addCommand(String name, Object cmd) {
        this.commander.addSubcommand(name, cmd);
    }

    protected void addCommand(String name, Object cmd, String ... aliases) {
        this.commander.addSubcommand(name, cmd, aliases);
    }

    protected class ParameterException
    extends CommandLine.ParameterException {
        public ParameterException(String msg) {
            super(CmdBase.this.commander, msg);
        }

        public ParameterException(String msg, Throwable e) {
            super(CmdBase.this.commander, msg, e);
        }
    }
}

