/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;

public final class Retries {
    public static final Predicate<Throwable> NonFatalPredicate = cause -> !(cause instanceof RuntimeException);

    private Retries() {
    }

    public static <ReturnT> CompletableFuture<ReturnT> run(Stream<Long> backoffs, Predicate<Throwable> retryPredicate, Supplier<CompletableFuture<ReturnT>> task, OrderedScheduler scheduler) {
        return Retries.run(backoffs, retryPredicate, task, scheduler, null);
    }

    public static <ReturnT> CompletableFuture<ReturnT> run(Stream<Long> backoffs, Predicate<Throwable> retryPredicate, Supplier<CompletableFuture<ReturnT>> task, OrderedScheduler scheduler, Object key) {
        CompletableFuture future = FutureUtils.createFuture();
        if (null == key) {
            Retries.execute(future, backoffs.iterator(), retryPredicate, task, scheduler, null);
        } else {
            scheduler.executeOrdered(key, () -> Retries.execute(future, backoffs.iterator(), retryPredicate, task, scheduler, key));
        }
        return future;
    }

    private static <ReturnT> void execute(CompletableFuture<ReturnT> finalResult, Iterator<Long> backoffIter, Predicate<Throwable> retryPredicate, Supplier<CompletableFuture<ReturnT>> task, OrderedScheduler scheduler, Object key) {
        FutureUtils.whenCompleteAsync(task.get(), (result, cause) -> {
            if (null == cause) {
                finalResult.complete(result);
                return;
            }
            if (retryPredicate.test((Throwable)cause)) {
                if (!backoffIter.hasNext()) {
                    finalResult.completeExceptionally((Throwable)cause);
                    return;
                }
                long nextRetryDelayMs = (Long)backoffIter.next();
                scheduler.scheduleOrdered(key, () -> Retries.lambda$execute$2(finalResult, backoffIter, retryPredicate, (Supplier)task, scheduler, key), nextRetryDelayMs, TimeUnit.MILLISECONDS);
            } else {
                finalResult.completeExceptionally((Throwable)cause);
            }
        }, scheduler, key);
    }

    private static /* synthetic */ void lambda$execute$2(CompletableFuture finalResult, Iterator backoffIter, Predicate retryPredicate, Supplier task, OrderedScheduler scheduler, Object key) {
        Retries.execute(finalResult, backoffIter, retryPredicate, task, scheduler, key);
    }
}

