/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookies;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.cli.helpers.CommandHelpers;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoCommand
extends BookieCommand<CliFlags> {
    private static final String NAME = "info";
    private static final String DESC = "Retrieve bookie info such as free and total disk space.";
    private static final Logger LOG = LoggerFactory.getLogger(InfoCommand.class);

    public InfoCommand() {
        super(CliSpec.newBuilder().withName(NAME).withFlags(new CliFlags()).withDescription(DESC).build());
    }

    String getReadable(long val) {
        double d;
        String[] unit = new String[]{"", "KB", "MB", "GB", "TB"};
        int cnt = 0;
        for (d = (double)val; d >= 1000.0 && cnt < unit.length - 1; d /= 1000.0, ++cnt) {
        }
        DecimalFormat df = new DecimalFormat("#.###");
        df.setRoundingMode(RoundingMode.DOWN);
        return cnt > 0 ? "(" + df.format(d) + unit[cnt] + ")" : unit[cnt];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        ClientConfiguration clientConf = new ClientConfiguration(conf);
        clientConf.setDiskWeightBasedPlacementEnabled(true);
        try (BookKeeper bk = new BookKeeper(clientConf);){
            Map<BookieId, BookieInfoReader.BookieInfo> map = bk.getBookieInfo();
            if (map.size() == 0) {
                LOG.info("Failed to retrieve bookie information from any of the bookies");
                bk.close();
                boolean bl = true;
                return bl;
            }
            LOG.info("Free disk space info:");
            long totalFree = 0L;
            long total = 0L;
            for (Map.Entry<BookieId, BookieInfoReader.BookieInfo> e : map.entrySet()) {
                BookieInfoReader.BookieInfo bInfo = e.getValue();
                BookieId bookieId = e.getKey();
                LOG.info("{}: \tFree: {}\tTotal: {}", new Object[]{CommandHelpers.getBookieSocketAddrStringRepresentation(bookieId, bk.getBookieAddressResolver()), bInfo.getFreeDiskSpace() + this.getReadable(bInfo.getFreeDiskSpace()), bInfo.getTotalDiskSpace() + this.getReadable(bInfo.getTotalDiskSpace())});
            }
            Map<String, BookieInfoReader.BookieInfo> dedupedMap = map.entrySet().stream().collect(Collectors.toMap(entry -> ((BookieId)entry.getKey()).toString(), entry -> (BookieInfoReader.BookieInfo)entry.getValue(), (key1, key2) -> key2));
            for (BookieInfoReader.BookieInfo bookieInfo : dedupedMap.values()) {
                totalFree += bookieInfo.getFreeDiskSpace();
                total += bookieInfo.getTotalDiskSpace();
            }
            LOG.info("Total free disk space in the cluster:\t{}", (Object)(totalFree + this.getReadable(totalFree)));
            LOG.info("Total disk capacity in the cluster:\t{}", (Object)(total + this.getReadable(total)));
            bk.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException | InterruptedException | BKException e) {
            e.printStackTrace();
            return true;
        }
    }
}

