/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.storage.bookkeeper;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DLOutputStream {
    private static final Logger log = LoggerFactory.getLogger(DLOutputStream.class);
    private final DistributedLogManager distributedLogManager;
    private final AsyncLogWriter writer;
    private long offset = 0L;

    private DLOutputStream(DistributedLogManager distributedLogManager, AsyncLogWriter writer) {
        this.distributedLogManager = distributedLogManager;
        this.writer = writer;
    }

    static CompletableFuture<DLOutputStream> openWriterAsync(DistributedLogManager distributedLogManager) {
        log.info("Open a dlog manager");
        return distributedLogManager.openAsyncLogWriter().thenApply(w -> new DLOutputStream(distributedLogManager, (AsyncLogWriter)w));
    }

    private CompletableFuture<List<LogRecord>> getRecords(InputStream inputStream) {
        CompletableFuture<List<LogRecord>> future = new CompletableFuture<List<LogRecord>>();
        CompletableFuture.runAsync(() -> {
            byte[] readBuffer = new byte[8192];
            ArrayList<LogRecord> records = new ArrayList<LogRecord>();
            try {
                int read = 0;
                while ((read = inputStream.read(readBuffer)) != -1) {
                    log.info("write something into the ledgers offset: {}, length: {}", (Object)this.offset, (Object)read);
                    ByteBuf writeBuf = Unpooled.copiedBuffer((byte[])readBuffer, (int)0, (int)read);
                    this.offset += (long)writeBuf.readableBytes();
                    LogRecord record = new LogRecord(this.offset, writeBuf);
                    records.add(record);
                }
                future.complete(records);
            }
            catch (IOException e) {
                log.error("Failed to get all records from the input stream", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    CompletableFuture<DLOutputStream> writeAsync(InputStream inputStream) {
        return this.getRecords(inputStream).thenCompose(this::writeAsync);
    }

    private CompletableFuture<DLOutputStream> writeAsync(List<LogRecord> records) {
        return this.writer.writeBulk(records).thenApply(ignore -> this);
    }

    CompletableFuture<Void> closeAsync() {
        return ((CompletableFuture)this.writer.markEndOfStream().thenCompose(ignore -> this.writer.asyncClose())).thenCompose(ignore -> this.distributedLogManager.asyncClose());
    }
}

