/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;

public class TxnBatchedPositionImpl
extends PositionImpl {
    private final int batchSize;
    private final int batchIndex;

    public TxnBatchedPositionImpl(long ledgerId, long entryId, int batchSize, int batchIndex) {
        super(ledgerId, entryId);
        this.batchIndex = batchIndex;
        this.batchSize = batchSize;
    }

    public TxnBatchedPositionImpl(Position position, int batchSize, int batchIndex) {
        this(position.getLedgerId(), position.getEntryId(), batchSize, batchIndex);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int compareTo(PositionImpl that) {
        return super.compareTo(that);
    }

    public void setAckSetByIndex() {
        if (this.batchSize == 1) {
            return;
        }
        BitSetRecyclable bitSetRecyclable = BitSetRecyclable.create();
        bitSetRecyclable.set(0, this.batchSize, true);
        bitSetRecyclable.clear(this.batchIndex);
        long[] ackSet = bitSetRecyclable.toLongArray();
        bitSetRecyclable.recycle();
        this.setAckSet(ackSet);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }
}

