/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

public final class WindowWrap<T> {
    private final long interval;
    private long start;
    private T value;

    public WindowWrap(long interval, long windowStart, T value) {
        this.interval = interval;
        this.start = windowStart;
        this.value = value;
    }

    public long interval() {
        return this.interval;
    }

    public long start() {
        return this.start;
    }

    public T value() {
        return this.value;
    }

    public void value(T value) {
        this.value = value;
    }

    public WindowWrap<T> resetWindowStart(long startTime) {
        this.start = startTime;
        return this;
    }

    public boolean isTimeInWindow(long timeMillis) {
        return this.start <= timeMillis && timeMillis < this.start + this.interval;
    }
}

