/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.common.policies.data.BookiesClusterInfo;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.common.policies.data.RawBookieInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/bookies")
@Api(value="/bookies", description="Configure bookies rack placement", tags={"bookies"})
@Produces(value={"application/json"})
public class Bookies
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(Bookies.class);
    private static final String PATH_SEPARATOR = "/";

    @GET
    @Path(value="/racks-info")
    @ApiOperation(value="Gets the rack placement information for all the bookies in the cluster", response=BookiesRackConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void getBookiesRackInfo(@Suspended AsyncResponse asyncResponse) {
        this.validateSuperUserAccess();
        ((CompletableFuture)this.getPulsarResources().getBookieResources().get().thenAccept(b -> asyncResponse.resume((Object)b.orElseGet(() -> new BookiesRackConfiguration())))).exceptionally(ex -> {
            asyncResponse.resume(ex);
            return null;
        });
    }

    @GET
    @Path(value="/all")
    @ApiOperation(value="Gets raw information for all the bookies in the cluster", response=BookiesClusterInfo.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public BookiesClusterInfo getAllBookies() throws Exception {
        this.validateSuperUserAccess();
        BookKeeper bookKeeper = this.bookKeeper();
        MetadataClientDriver metadataClientDriver = bookKeeper.getMetadataClientDriver();
        RegistrationClient registrationClient = metadataClientDriver.getRegistrationClient();
        Set allBookies = (Set)((Versioned)registrationClient.getAllBookies().get()).getValue();
        ArrayList<RawBookieInfo> result = new ArrayList<RawBookieInfo>(allBookies.size());
        for (BookieId bookieId : allBookies) {
            RawBookieInfo bookieInfo = new RawBookieInfo(bookieId.toString());
            result.add(bookieInfo);
        }
        return BookiesClusterInfo.builder().bookies(result).build();
    }

    @GET
    @Path(value="/racks-info/{bookie}")
    @ApiOperation(value="Gets the rack placement information for a specific bookie in the cluster", response=BookieInfo.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void getBookieRackInfo(@Suspended AsyncResponse asyncResponse, @PathParam(value="bookie") String bookieAddress) throws Exception {
        this.validateSuperUserAccess();
        ((CompletableFuture)this.getPulsarResources().getBookieResources().get().thenAccept(b -> {
            Optional bi = b.orElseGet(() -> new BookiesRackConfiguration()).getBookie(bookieAddress);
            if (bi.isPresent()) {
                asyncResponse.resume(bi.get());
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Bookie rack placement configuration not found: " + bookieAddress)));
            }
        })).exceptionally(ex -> {
            asyncResponse.resume(ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/racks-info/{bookie}")
    @ApiOperation(value="Removed the rack placement information for a specific bookie in the cluster")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void deleteBookieRackInfo(@Suspended AsyncResponse asyncResponse, @PathParam(value="bookie") String bookieAddress) throws Exception {
        this.validateSuperUserAccess();
        ((CompletableFuture)this.getPulsarResources().getBookieResources().update(optionalBookiesRackConfiguration -> {
            BookiesRackConfiguration brc = optionalBookiesRackConfiguration.orElseGet(() -> new BookiesRackConfiguration());
            if (!brc.removeBookie(bookieAddress)) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Bookie rack placement configuration not found: " + bookieAddress)));
            }
            return brc;
        }).thenAccept(__ -> {
            log.info("Removed {} from rack mapping info", (Object)bookieAddress);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            asyncResponse.resume(ex);
            return null;
        });
    }

    @POST
    @Path(value="/racks-info/{bookie}")
    @ApiOperation(value="Updates the rack placement information for a specific bookie in the cluster (note. bookie address format:`address:port`)")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void updateBookieRackInfo(@Suspended AsyncResponse asyncResponse, @PathParam(value="bookie") String bookieAddress, @QueryParam(value="group") String group, BookieInfo bookieInfo) throws Exception {
        this.validateSuperUserAccess();
        if (group == null) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Bookie 'group' parameters is missing");
        }
        int separatorCnt = StringUtils.countMatches((CharSequence)StringUtils.strip((String)bookieInfo.getRack(), (String)PATH_SEPARATOR), (CharSequence)PATH_SEPARATOR);
        boolean isRackEnabled = this.pulsar().getConfiguration().isBookkeeperClientRackawarePolicyEnabled();
        boolean isRegionEnabled = this.pulsar().getConfiguration().isBookkeeperClientRegionawarePolicyEnabled();
        if (isRackEnabled && (isRegionEnabled && separatorCnt != 1 || !isRegionEnabled && separatorCnt != 0)) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Bookie 'rack' parameter is invalid, When `RackawareEnsemblePlacementPolicy` is enabled, the rack name is not allowed to contain slash (`/`) except for the beginning and end of the rack name string. When `RegionawareEnsemblePlacementPolicy` is enabled, the rack name can only contain one slash (`/`) except for the beginning and end of the rack name string.")));
            return;
        }
        ((CompletableFuture)this.getPulsarResources().getBookieResources().update(optionalBookiesRackConfiguration -> {
            BookiesRackConfiguration brc = optionalBookiesRackConfiguration.orElseGet(() -> new BookiesRackConfiguration());
            brc.updateBookie(group, bookieAddress, bookieInfo);
            return brc;
        }).thenAccept(__ -> {
            log.info("Updated rack mapping info for {}", (Object)bookieAddress);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            asyncResponse.resume(ex);
            return null;
        });
    }
}

