/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ThreadRegistry {
    private static ConcurrentMap<Long, ThreadPoolThread> threadPoolMap = new ConcurrentHashMap<Long, ThreadPoolThread>();

    public static void register(String threadPool, int threadPoolThread) {
        ThreadRegistry.register(threadPool, threadPoolThread, Thread.currentThread().getId());
    }

    public static void register(String threadPool, int threadPoolThread, long threadId) {
        ThreadPoolThread tpt = new ThreadPoolThread(threadPool, threadPoolThread, threadId);
        threadPoolMap.put(threadId, tpt);
    }

    public static void clear() {
        threadPoolMap.clear();
    }

    public static ThreadPoolThread get() {
        return (ThreadPoolThread)threadPoolMap.get(Thread.currentThread().getId());
    }

    public static final class ThreadPoolThread {
        final String threadPool;
        final int ordinal;
        final long threadId;

        public ThreadPoolThread(String threadPool, int ordinal, long threadId) {
            this.threadPool = threadPool;
            this.ordinal = ordinal;
            this.threadId = threadId;
        }

        public String getThreadPool() {
            return this.threadPool;
        }

        public int getOrdinal() {
            return this.ordinal;
        }
    }
}

