/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.coordination.impl;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.common.util.GracefulExecutorServicesShutdown;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.coordination.CoordinationService;
import org.apache.pulsar.metadata.api.coordination.LeaderElection;
import org.apache.pulsar.metadata.api.coordination.LeaderElectionState;
import org.apache.pulsar.metadata.api.coordination.LockManager;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.coordination.impl.LeaderElectionImpl;
import org.apache.pulsar.metadata.coordination.impl.LockManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinationServiceImpl
implements CoordinationService {
    private static final Logger log = LoggerFactory.getLogger(CoordinationServiceImpl.class);
    private static final Duration CLOSE_TIMEOUT = Duration.ofSeconds(10L);
    private static final int GET_NEXT_COUNTER_VALUE_RETRY_COUNT = 5;
    private final MetadataStoreExtended store;
    private final Map<Object, LockManager<?>> lockManagers = new ConcurrentHashMap();
    private final Map<String, LeaderElection<?>> leaderElections = new ConcurrentHashMap();
    private final ScheduledExecutorService executor;

    public CoordinationServiceImpl(MetadataStoreExtended store) {
        this.store = store;
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("metadata-store-coordination-service"));
    }

    @Override
    public void close() throws Exception {
        try {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            futures.add(GracefulExecutorServicesShutdown.initiate().shutdown(new ExecutorService[]{this.executor}).handle());
            for (LeaderElection<?> leaderElection : this.leaderElections.values()) {
                futures.add(leaderElection.asyncClose());
            }
            for (LockManager lockManager : this.lockManagers.values()) {
                futures.add(lockManager.asyncClose());
            }
            FutureUtils.collect(futures).get(CLOSE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (CompletionException ce) {
            throw MetadataStoreException.unwrap(ce);
        }
        finally {
            this.executor.shutdownNow();
        }
    }

    @Override
    public <T> LockManager<T> getLockManager(Class<T> clazz) {
        return this.lockManagers.computeIfAbsent(clazz, k -> new LockManagerImpl(this.store, clazz, (ExecutorService)this.executor));
    }

    @Override
    public <T> LockManager<T> getLockManager(MetadataSerde<T> serde) {
        return this.lockManagers.computeIfAbsent(serde, k -> new LockManagerImpl(this.store, serde, (ExecutorService)this.executor));
    }

    @Override
    public CompletableFuture<Long> getNextCounterValue(String path) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.internalGetNextCounterValueWithRetry(path, future, 5);
        return future;
    }

    private CompletableFuture<Long> internalGetNextCounterValue(String path) {
        return this.store.exists(path).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.incrementCounter(path);
            }
            return this.store.put(path, new byte[0], Optional.empty()).thenCompose(__ -> this.incrementCounter(path));
        });
    }

    private void internalGetNextCounterValueWithRetry(String path, CompletableFuture<Long> future, int count) {
        if (count == 0) {
            log.error("The number of retries has exhausted when get next counter value from path {}", (Object)path);
            future.completeExceptionally(new MetadataStoreException("The number of retries has exhausted"));
            return;
        }
        ((CompletableFuture)this.internalGetNextCounterValue(path).thenAccept(future::complete)).exceptionally(ex -> {
            if (ex.getCause() instanceof MetadataStoreException.BadVersionException) {
                log.warn("Failed to get next counter value because of bad version. Retry to get next counter value from path {}", (Object)path);
                this.internalGetNextCounterValueWithRetry(path, future, count - 1);
            } else {
                log.error("Failed to get next counter value from path {}", (Object)path, ex);
                future.completeExceptionally((Throwable)ex);
            }
            return null;
        });
    }

    private CompletableFuture<Long> incrementCounter(String path) {
        String counterBasePath = path + "/-";
        return this.store.put(counterBasePath, new byte[0], Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral, CreateOption.Sequential)).thenApply(stat -> {
            String[] parts = stat.getPath().split("/");
            String seq = parts[parts.length - 1].replace('-', ' ').trim();
            return Long.parseLong(seq);
        });
    }

    @Override
    public <T> LeaderElection<T> getLeaderElection(Class<T> clazz, String path, Consumer<LeaderElectionState> stateChangesListener) {
        return this.leaderElections.computeIfAbsent(path, key -> new LeaderElectionImpl(this.store, clazz, path, stateChangesListener, this.executor));
    }
}

