/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.storage.filesystem;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.packages.management.core.PackagesStorage;
import org.apache.pulsar.packages.management.core.PackagesStorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemPackagesStorage
implements PackagesStorage {
    private static final Logger log = LoggerFactory.getLogger(FileSystemPackagesStorage.class);
    private static final String STORAGE_PATH = "STORAGE_PATH";
    private static final String DEFAULT_STORAGE_PATH = "packages-storage";
    private final File storagePath;

    FileSystemPackagesStorage(PackagesStorageConfiguration configuration) {
        String storagePath = configuration.getProperty(STORAGE_PATH);
        this.storagePath = storagePath != null ? new File(storagePath) : new File(DEFAULT_STORAGE_PATH);
    }

    private File getPath(String path) {
        File f = Paths.get(this.storagePath.toString(), path).toFile();
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new RuntimeException("Failed to create parent dirs for " + path);
        }
        return f;
    }

    public void initialize() {
        if (!this.storagePath.exists() && !this.storagePath.mkdirs()) {
            throw new RuntimeException("Failed to create base storage directory at " + this.storagePath);
        }
        log.info("Packages management filesystem storage initialized on {}", (Object)this.storagePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<Void> writeAsync(String path, InputStream inputStream) {
        try {
            File f = this.getPath(path);
            FileOutputStream os = new FileOutputStream(f);
            try {
                CompletableFuture<Object> completableFuture;
                block10: {
                    BufferedOutputStream bos = new BufferedOutputStream(os);
                    try {
                        ByteStreams.copy((InputStream)inputStream, (OutputStream)bos);
                        completableFuture = CompletableFuture.completedFuture(null);
                        if (Collections.singletonList(bos).get(0) == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(bos).get(0) != null) {
                            bos.close();
                        }
                        throw throwable;
                    }
                    bos.close();
                }
                return completableFuture;
            }
            finally {
                if (Collections.singletonList(os).get(0) != null) {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (IOException e) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(e);
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<Void> readAsync(String path, OutputStream outputStream) {
        try {
            FileInputStream is = new FileInputStream(this.getPath(path));
            try {
                CompletableFuture<Object> completableFuture;
                block10: {
                    BufferedInputStream bis = new BufferedInputStream(is);
                    try {
                        ByteStreams.copy((InputStream)bis, (OutputStream)outputStream);
                        completableFuture = CompletableFuture.completedFuture(null);
                        if (Collections.singletonList(bis).get(0) == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(bis).get(0) != null) {
                            bis.close();
                        }
                        throw throwable;
                    }
                    bis.close();
                }
                return completableFuture;
            }
            finally {
                if (Collections.singletonList(is).get(0) != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (IOException e) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(e);
            return f;
        }
    }

    public CompletableFuture<Void> deleteAsync(String path) {
        if (this.getPath(path).delete()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        f.completeExceptionally(new IOException("Failed to delete file at " + path));
        return f;
    }

    public CompletableFuture<List<String>> listAsync(String path) {
        String[] files = this.getPath(path).list();
        if (files == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.completedFuture(Arrays.asList(files));
    }

    public CompletableFuture<Boolean> existAsync(String path) {
        return CompletableFuture.completedFuture(this.getPath(path).exists());
    }

    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.completedFuture(null);
    }

    public String dataPath() {
        return "/data";
    }
}

