/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.bookkeeper.stats.Counter;

public class LongAdderCounter
implements Counter {
    private final LongAdder counter = new LongAdder();

    public void clear() {
        this.counter.reset();
    }

    public void inc() {
        this.counter.increment();
    }

    public void dec() {
        this.counter.decrement();
    }

    public void addCount(long delta) {
        this.counter.add(delta);
    }

    public void addLatency(long eventLatency, TimeUnit unit) {
        Preconditions.checkArgument((eventLatency >= 0L ? 1 : 0) != 0);
        long valueMillis = unit.toMillis(eventLatency);
        this.counter.add(valueMillis);
    }

    public Long get() {
        return this.counter.sum();
    }
}

