/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.util.SimpleTextOutputStream;

public class PrometheusMetricStreams {
    private final Map<String, SimpleTextOutputStream> metricStreamMap = new HashMap<String, SimpleTextOutputStream>();

    void writeSample(String metricName, Number value, String ... labelsAndValuesArray) {
        SimpleTextOutputStream stream = this.initGaugeType(metricName);
        stream.write(metricName).write('{');
        for (int i = 0; i < labelsAndValuesArray.length; i += 2) {
            String labelValue = labelsAndValuesArray[i + 1];
            if (labelValue != null) {
                labelValue = labelValue.replace("\"", "\\\"");
            }
            stream.write(labelsAndValuesArray[i]).write("=\"").write(labelValue).write('\"');
            if (i + 2 == labelsAndValuesArray.length) continue;
            stream.write(',');
        }
        stream.write("} ").write(value).write('\n');
    }

    void flushAllToStream(SimpleTextOutputStream stream) {
        this.metricStreamMap.values().forEach(s -> stream.write(s.getBuffer()));
    }

    void releaseAll() {
        this.metricStreamMap.values().forEach(s -> s.getBuffer().release());
        this.metricStreamMap.clear();
    }

    private SimpleTextOutputStream initGaugeType(String metricName) {
        return this.metricStreamMap.computeIfAbsent(metricName, s -> {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(PulsarByteBufAllocator.DEFAULT.directBuffer());
            stream.write("# TYPE ").write(metricName).write(" gauge\n");
            return stream;
        });
    }
}

