/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import org.apache.pulsar.broker.stats.prometheus.TopicStats;

public class AggregatedBrokerStats {
    public int topicsCount;
    public int subscriptionsCount;
    public int producersCount;
    public int consumersCount;
    public double rateIn;
    public double rateOut;
    public double throughputIn;
    public double throughputOut;
    public long storageSize;
    public long storageLogicalSize;
    public double storageWriteRate;
    public double storageReadRate;
    public double storageReadCacheMissesRate;
    public long msgBacklog;

    void updateStats(TopicStats stats) {
        ++this.topicsCount;
        this.subscriptionsCount += stats.subscriptionsCount;
        this.producersCount += stats.producersCount;
        this.consumersCount += stats.consumersCount;
        this.rateIn += stats.rateIn;
        this.rateOut += stats.rateOut;
        this.throughputIn += stats.throughputIn;
        this.throughputOut += stats.throughputOut;
        this.storageSize += stats.managedLedgerStats.storageSize;
        this.storageLogicalSize += stats.managedLedgerStats.storageLogicalSize;
        this.storageWriteRate += stats.managedLedgerStats.storageWriteRate;
        this.storageReadRate += stats.managedLedgerStats.storageReadRate;
        this.storageReadCacheMissesRate += stats.managedLedgerStats.storageReadCacheMissesRate;
        this.msgBacklog += stats.msgBacklog;
    }

    public void reset() {
        this.topicsCount = 0;
        this.subscriptionsCount = 0;
        this.producersCount = 0;
        this.consumersCount = 0;
        this.rateIn = 0.0;
        this.rateOut = 0.0;
        this.throughputIn = 0.0;
        this.throughputOut = 0.0;
        this.storageSize = 0L;
        this.storageLogicalSize = 0L;
        this.storageWriteRate = 0.0;
        this.storageReadRate = 0.0;
        this.storageReadCacheMissesRate = 0.0;
        this.msgBacklog = 0L;
    }
}

