/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.qos;

import org.apache.pulsar.broker.qos.AsyncTokenBucket;
import org.apache.pulsar.broker.qos.MonotonicSnapshotClock;

class FinalRateAsyncTokenBucket
extends AsyncTokenBucket {
    private final long capacity;
    private final long rate;
    private final long ratePeriodNanos;
    private final long targetAmountOfTokensAfterThrottling;

    protected FinalRateAsyncTokenBucket(long capacity, long rate, MonotonicSnapshotClock clockSource, long ratePeriodNanos, long resolutionNanos, long initialTokens) {
        super(clockSource, resolutionNanos);
        this.capacity = capacity;
        this.rate = rate;
        this.ratePeriodNanos = ratePeriodNanos != -1L ? ratePeriodNanos : ONE_SECOND_NANOS;
        this.targetAmountOfTokensAfterThrottling = Math.max(this.resolutionNanos * rate / ratePeriodNanos, 1L);
        this.tokens = initialTokens;
        this.tokens(false);
    }

    @Override
    protected final long getRatePeriodNanos() {
        return this.ratePeriodNanos;
    }

    @Override
    protected final long getTargetAmountOfTokensAfterThrottling() {
        return this.targetAmountOfTokensAfterThrottling;
    }

    @Override
    public final long getCapacity() {
        return this.capacity;
    }

    @Override
    public final long getRate() {
        return this.rate;
    }
}

