/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.google.common.base.Preconditions;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.BrokerHostUsage;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitState;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceAllocationPolicies;
import org.apache.pulsar.broker.resources.ClusterResources;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.policies.data.FailureDomainImpl;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.stats.JvmMetrics;
import org.apache.pulsar.common.util.DirectMemoryUtils;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.policies.data.loadbalancer.BrokerData;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadManagerShared {
    public static final Logger LOG = LoggerFactory.getLogger(LoadManagerShared.class);
    public static final int MIBI = 0x100000;
    private static final FastThreadLocal<Set<String>> localPrimariesCache = new FastThreadLocal<Set<String>>(){

        protected Set<String> initialValue() throws Exception {
            return new HashSet<String>();
        }
    };
    private static final FastThreadLocal<Set<String>> localSecondaryCache = new FastThreadLocal<Set<String>>(){

        protected Set<String> initialValue() throws Exception {
            return new HashSet<String>();
        }
    };
    private static final String DEFAULT_DOMAIN = "default";

    private LoadManagerShared() {
    }

    public static void applyNamespacePolicies(ServiceUnitId serviceUnit, SimpleResourceAllocationPolicies policies, Set<String> brokerCandidateCache, Set<String> availableBrokers, BrokerTopicLoadingPredicate brokerTopicLoadingPredicate) {
        boolean isNonPersistentTopic;
        Set primariesCache = (Set)localPrimariesCache.get();
        primariesCache.clear();
        Set secondaryCache = (Set)localSecondaryCache.get();
        secondaryCache.clear();
        NamespaceName namespace = serviceUnit.getNamespaceObject();
        boolean isIsolationPoliciesPresent = policies.areIsolationPoliciesPresent(namespace);
        boolean bl = isNonPersistentTopic = serviceUnit instanceof NamespaceBundle ? ((NamespaceBundle)serviceUnit).hasNonPersistentTopic() : false;
        if (isIsolationPoliciesPresent) {
            LOG.debug("Isolation Policies Present for namespace - [{}]", (Object)namespace.toString());
        }
        for (String brokerId : availableBrokers) {
            String brokerHost;
            try {
                brokerHost = LoadManagerShared.parseBrokerHost(brokerId);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unable to parse host from {}", (Object)brokerId, (Object)e);
                continue;
            }
            if (isIsolationPoliciesPresent) {
                if (policies.isPrimaryBroker(namespace, brokerHost)) {
                    primariesCache.add(brokerId);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Added Primary Broker - [{}] as possible Candidates for namespace - [{}] with policies", (Object)brokerHost, (Object)namespace.toString());
                    continue;
                }
                if (policies.isSecondaryBroker(namespace, brokerHost)) {
                    secondaryCache.add(brokerId);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Added Shared Broker - [{}] as possible Candidates for namespace - [{}] with policies", (Object)brokerHost, (Object)namespace.toString());
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping Broker - [{}] not primary broker and not shared for namespace - [{}] ", (Object)brokerHost, (Object)namespace.toString());
                continue;
            }
            if (isNonPersistentTopic && !brokerTopicLoadingPredicate.isEnableNonPersistentTopics(brokerId)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Filter broker- [{}] because it doesn't support non-persistent namespace - [{}]", (Object)brokerHost, (Object)namespace.toString());
                continue;
            }
            if (!isNonPersistentTopic && !brokerTopicLoadingPredicate.isEnablePersistentTopics(brokerId)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Filter broker- [{}] because broker only supports non-persistent namespace - [{}]", (Object)brokerHost, (Object)namespace.toString());
                continue;
            }
            if (!policies.isSharedBroker(brokerHost)) continue;
            secondaryCache.add(brokerId);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Added Shared Broker - [{}] as possible Candidates for namespace - [{}]", (Object)brokerHost, (Object)namespace.toString());
        }
        if (isIsolationPoliciesPresent) {
            brokerCandidateCache.addAll(primariesCache);
            if (policies.shouldFailoverToSecondaries(namespace, primariesCache.size())) {
                LOG.debug("Not enough of primaries [{}] available for namespace - [{}], adding shared [{}] as possible candidate owners", new Object[]{primariesCache.size(), namespace.toString(), secondaryCache.size()});
                brokerCandidateCache.addAll(secondaryCache);
            }
        } else {
            LOG.debug("Policies not present for namespace - [{}] so only considering shared [{}] brokers for possible owner", (Object)namespace.toString(), (Object)secondaryCache.size());
            brokerCandidateCache.addAll(secondaryCache);
        }
    }

    private static String parseBrokerHost(String brokerId) {
        int lastIdx = brokerId.lastIndexOf(58);
        if (lastIdx > -1) {
            return brokerId.substring(0, lastIdx);
        }
        throw new IllegalArgumentException("Invalid brokerId: " + brokerId);
    }

    public static CompletableFuture<Set<String>> applyNamespacePoliciesAsync(ServiceUnitId serviceUnit, SimpleResourceAllocationPolicies policies, Set<String> availableBrokers, BrokerTopicLoadingPredicate brokerTopicLoadingPredicate) {
        NamespaceName namespace = serviceUnit.getNamespaceObject();
        return policies.areIsolationPoliciesPresentAsync(namespace).thenApply(isIsolationPoliciesPresent -> {
            boolean isNonPersistentTopic;
            HashSet brokerCandidateCache = new HashSet();
            Set primariesCache = (Set)localPrimariesCache.get();
            primariesCache.clear();
            Set secondaryCache = (Set)localSecondaryCache.get();
            secondaryCache.clear();
            boolean bl = isNonPersistentTopic = serviceUnit instanceof NamespaceBundle ? ((NamespaceBundle)serviceUnit).hasNonPersistentTopic() : false;
            if (isIsolationPoliciesPresent.booleanValue() && LOG.isDebugEnabled()) {
                LOG.debug("Isolation Policies Present for namespace - [{}]", (Object)namespace.toString());
            }
            for (String brokerId : availableBrokers) {
                String brokerHost;
                try {
                    brokerHost = LoadManagerShared.parseBrokerHost(brokerId);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Unable to parse host from {}", (Object)brokerId, (Object)e);
                    continue;
                }
                if (isIsolationPoliciesPresent.booleanValue()) {
                    if (policies.isPrimaryBroker(namespace, brokerHost)) {
                        primariesCache.add(brokerId);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Added Primary Broker - [{}] as possible Candidates for namespace - [{}] with policies", (Object)brokerHost, (Object)namespace.toString());
                        continue;
                    }
                    if (policies.isSecondaryBroker(namespace, brokerHost)) {
                        secondaryCache.add(brokerId);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Added Shared Broker - [{}] as possible Candidates for namespace - [{}] with policies", (Object)brokerHost, (Object)namespace.toString());
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Skipping Broker - [{}] not primary broker and not shared for namespace - [{}] ", (Object)brokerHost, (Object)namespace.toString());
                    continue;
                }
                if (isNonPersistentTopic && !brokerTopicLoadingPredicate.isEnableNonPersistentTopics(brokerId)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Filter broker- [{}] because it doesn't support non-persistent namespace - [{}]", (Object)brokerId, (Object)namespace.toString());
                    continue;
                }
                if (!isNonPersistentTopic && !brokerTopicLoadingPredicate.isEnablePersistentTopics(brokerId)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Filter broker- [{}] because broker only supports non-persistent namespace - [{}]", (Object)brokerId, (Object)namespace.toString());
                    continue;
                }
                if (!policies.isSharedBroker(brokerHost)) continue;
                secondaryCache.add(brokerId);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Added Shared Broker - [{}] as possible Candidates for namespace - [{}]", (Object)brokerHost, (Object)namespace.toString());
            }
            if (isIsolationPoliciesPresent.booleanValue()) {
                brokerCandidateCache.addAll(primariesCache);
                if (policies.shouldFailoverToSecondaries(namespace, primariesCache.size())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Not enough of primaries [{}] available for namespace - [{}], adding shared [{}] as possible candidate owners", new Object[]{primariesCache.size(), namespace.toString(), secondaryCache.size()});
                    }
                    brokerCandidateCache.addAll(secondaryCache);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Policies not present for namespace - [{}] so only considering shared [{}] brokers for possible owner", (Object)namespace.toString(), (Object)secondaryCache.size());
                }
                brokerCandidateCache.addAll(secondaryCache);
            }
            return brokerCandidateCache;
        });
    }

    public static void fillNamespaceToBundlesMap(Set<String> bundles, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>> target) {
        bundles.forEach(bundleName -> {
            String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(bundleName);
            String bundleRange = LoadManagerShared.getBundleRangeFromBundleName(bundleName);
            ((ConcurrentOpenHashSet)target.computeIfAbsent((Object)namespaceName, k -> ConcurrentOpenHashSet.newBuilder().build())).add((Object)bundleRange);
        });
    }

    public static String getBundleRangeFromBundleName(String bundleName) {
        int pos = bundleName.lastIndexOf("/");
        Preconditions.checkArgument((pos != -1 ? 1 : 0) != 0);
        return bundleName.substring(pos + 1);
    }

    public static String getNamespaceNameFromBundleName(String bundleName) {
        int pos = bundleName.lastIndexOf(47);
        Preconditions.checkArgument((pos != -1 ? 1 : 0) != 0);
        return bundleName.substring(0, pos);
    }

    public static SystemResourceUsage getSystemResourceUsage(BrokerHostUsage brokerHostUsage) {
        SystemResourceUsage systemResourceUsage = brokerHostUsage.getBrokerHostUsage();
        double maxHeapMemoryInBytes = Runtime.getRuntime().maxMemory();
        double memoryUsageInBytes = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        double memoryUsage = memoryUsageInBytes / 1048576.0;
        double memoryLimit = maxHeapMemoryInBytes / 1048576.0;
        systemResourceUsage.setMemory(new ResourceUsage(memoryUsage, memoryLimit));
        systemResourceUsage.setDirectMemory(new ResourceUsage((double)(JvmMetrics.getJvmDirectMemoryUsed() / 0x100000L), (double)(DirectMemoryUtils.jvmMaxDirectMemory() / 0x100000L)));
        return systemResourceUsage;
    }

    public static boolean isLoadSheddingEnabled(PulsarService pulsar) {
        return pulsar.getConfiguration().isLoadBalancerEnabled() && pulsar.getConfiguration().isLoadBalancerSheddingEnabled();
    }

    public static void removeMostServicingBrokersForNamespace(String assignedBundleName, Set<String> candidates, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>> brokerToNamespaceToBundleRange) {
        String broker2;
        int bundles;
        if (candidates.isEmpty()) {
            return;
        }
        String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(assignedBundleName);
        int leastBundles = Integer.MAX_VALUE;
        Iterator<String> iterator = candidates.iterator();
        while (iterator.hasNext() && (leastBundles = Math.min(leastBundles, bundles = (int)((ConcurrentOpenHashSet)((ConcurrentOpenHashMap)brokerToNamespaceToBundleRange.computeIfAbsent((Object)(broker2 = iterator.next()), k -> ConcurrentOpenHashMap.newBuilder().build())).computeIfAbsent((Object)namespaceName, k -> ConcurrentOpenHashSet.newBuilder().build())).size())) != 0) {
        }
        int finalLeastBundles = leastBundles;
        candidates.removeIf(broker -> ((ConcurrentOpenHashSet)((ConcurrentOpenHashMap)brokerToNamespaceToBundleRange.computeIfAbsent(broker, k -> ConcurrentOpenHashMap.newBuilder().build())).computeIfAbsent((Object)namespaceName, k -> ConcurrentOpenHashSet.newBuilder().build())).size() > (long)finalLeastBundles);
    }

    public static void filterAntiAffinityGroupOwnedBrokers(PulsarService pulsar, String assignedBundleName, Set<String> candidates, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>> brokerToNamespaceToBundleRange, Map<String, String> brokerToDomainMap) {
        if (candidates.isEmpty()) {
            return;
        }
        String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(assignedBundleName);
        try {
            Map<String, Integer> brokerToAntiAffinityNamespaceCount = LoadManagerShared.getAntiAffinityNamespaceOwnedBrokers(pulsar, namespaceName, brokerToNamespaceToBundleRange).get(30L, TimeUnit.SECONDS);
            LoadManagerShared.filterAntiAffinityGroupOwnedBrokers(pulsar, candidates, brokerToDomainMap, brokerToAntiAffinityNamespaceCount);
        }
        catch (Exception e) {
            LOG.error("Failed to filter anti-affinity group namespace {}", (Object)e.getMessage());
        }
    }

    private static void filterAntiAffinityGroupOwnedBrokers(PulsarService pulsar, Set<String> candidates, Map<String, String> brokerToDomainMap, Map<String, Integer> brokerToAntiAffinityNamespaceCount) {
        if (brokerToAntiAffinityNamespaceCount == null) {
            return;
        }
        if (pulsar.getConfiguration().isFailureDomainsEnabled()) {
            LoadManagerShared.filterDomainsNotHavingLeastNumberAntiAffinityNamespaces(brokerToAntiAffinityNamespaceCount, candidates, brokerToDomainMap);
        }
        int leastNamespaceCount = Integer.MAX_VALUE;
        for (String broker2 : candidates) {
            if (brokerToAntiAffinityNamespaceCount.containsKey(broker2)) {
                Integer namespaceCount = brokerToAntiAffinityNamespaceCount.get(broker2);
                if (namespaceCount == null) {
                    leastNamespaceCount = 0;
                    break;
                }
                leastNamespaceCount = Math.min(leastNamespaceCount, namespaceCount);
                continue;
            }
            leastNamespaceCount = 0;
            break;
        }
        if (leastNamespaceCount == 0) {
            candidates.removeIf(broker -> brokerToAntiAffinityNamespaceCount.containsKey(broker) && (Integer)brokerToAntiAffinityNamespaceCount.get(broker) > 0);
        } else {
            int finalLeastNamespaceCount = leastNamespaceCount;
            candidates.removeIf(broker -> (Integer)brokerToAntiAffinityNamespaceCount.get(broker) != finalLeastNamespaceCount);
        }
    }

    public static void filterAntiAffinityGroupOwnedBrokers(PulsarService pulsar, String assignedBundleName, Set<String> candidates, Set<Map.Entry<String, ServiceUnitStateData>> bundleOwnershipData, Map<String, String> brokerToDomainMap) {
        if (candidates.isEmpty()) {
            return;
        }
        String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(assignedBundleName);
        try {
            Map<String, Integer> brokerToAntiAffinityNamespaceCount = LoadManagerShared.getAntiAffinityNamespaceOwnedBrokers(pulsar, namespaceName, bundleOwnershipData).get(30L, TimeUnit.SECONDS);
            LoadManagerShared.filterAntiAffinityGroupOwnedBrokers(pulsar, candidates, brokerToDomainMap, brokerToAntiAffinityNamespaceCount);
        }
        catch (Exception e) {
            LOG.error("Failed to filter anti-affinity group namespace {}", (Object)e.getMessage());
        }
    }

    public static CompletableFuture<Void> filterAntiAffinityGroupOwnedBrokersAsync(PulsarService pulsar, String assignedBundleName, Set<String> candidates, Set<Map.Entry<String, ServiceUnitStateData>> bundleOwnershipData, Map<String, String> brokerToDomainMap) {
        if (candidates.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(assignedBundleName);
        return LoadManagerShared.getAntiAffinityNamespaceOwnedBrokers(pulsar, namespaceName, bundleOwnershipData).thenAccept(brokerToAntiAffinityNamespaceCount -> LoadManagerShared.filterAntiAffinityGroupOwnedBrokers(pulsar, candidates, brokerToDomainMap, brokerToAntiAffinityNamespaceCount));
    }

    private static void filterDomainsNotHavingLeastNumberAntiAffinityNamespaces(Map<String, Integer> brokerToAntiAffinityNamespaceCount, Set<String> candidates, Map<String, String> brokerToDomainMap) {
        if (brokerToDomainMap == null || brokerToDomainMap.isEmpty()) {
            return;
        }
        HashMap domainNamespaceCount = new HashMap();
        int leastNamespaceCount = Integer.MAX_VALUE;
        candidates.forEach(broker -> {
            String domain = brokerToDomainMap.getOrDefault(broker, DEFAULT_DOMAIN);
            int count = brokerToAntiAffinityNamespaceCount.getOrDefault(broker, 0);
            domainNamespaceCount.compute(domain, (domainName, nsCount) -> nsCount == null ? count : nsCount + count);
        });
        for (Map.Entry domainNsCountEntry : domainNamespaceCount.entrySet()) {
            if ((Integer)domainNsCountEntry.getValue() >= leastNamespaceCount) continue;
            leastNamespaceCount = (Integer)domainNsCountEntry.getValue();
        }
        int finalLeastNamespaceCount = leastNamespaceCount;
        candidates.removeIf(broker -> {
            Integer nsCount = (Integer)domainNamespaceCount.get(brokerToDomainMap.getOrDefault(broker, DEFAULT_DOMAIN));
            return nsCount != null && nsCount != finalLeastNamespaceCount;
        });
    }

    public static CompletableFuture<Map<String, Integer>> getAntiAffinityNamespaceOwnedBrokers(PulsarService pulsar, String namespaceName, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>> brokerToNamespaceToBundleRange) {
        CompletableFuture<Map<String, Integer>> antiAffinityNsBrokersResult = new CompletableFuture<Map<String, Integer>>();
        ((CompletableFuture)LoadManagerShared.getNamespaceAntiAffinityGroupAsync(pulsar, namespaceName).thenAccept(antiAffinityGroupOptional -> {
            if (antiAffinityGroupOptional.isEmpty()) {
                antiAffinityNsBrokersResult.complete(null);
                return;
            }
            String antiAffinityGroup = (String)antiAffinityGroupOptional.get();
            ConcurrentHashMap brokerToAntiAffinityNamespaceCount = new ConcurrentHashMap();
            ArrayList futures = new ArrayList();
            brokerToNamespaceToBundleRange.forEach((broker, nsToBundleRange) -> nsToBundleRange.forEach((ns, bundleRange) -> {
                if (bundleRange.isEmpty()) {
                    return;
                }
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                futures.add(future);
                LoadManagerShared.countAntiAffinityNamespaceOwnedBrokers(broker, ns, future, pulsar, antiAffinityGroup, brokerToAntiAffinityNamespaceCount);
            }));
            FutureUtil.waitForAll(futures).thenAccept(r -> antiAffinityNsBrokersResult.complete(brokerToAntiAffinityNamespaceCount));
        })).exceptionally(ex -> {
            antiAffinityNsBrokersResult.complete(null);
            return null;
        });
        return antiAffinityNsBrokersResult;
    }

    private static void countAntiAffinityNamespaceOwnedBrokers(String broker, String ns, CompletableFuture<Void> future, PulsarService pulsar, String targetAntiAffinityGroup, Map<String, Integer> brokerToAntiAffinityNamespaceCount) {
        ((CompletableFuture)LoadManagerShared.getNamespaceAntiAffinityGroupAsync(pulsar, ns).thenAccept(antiAffinityGroupOptional -> {
            if (antiAffinityGroupOptional.isPresent() && targetAntiAffinityGroup.equalsIgnoreCase((String)antiAffinityGroupOptional.get())) {
                brokerToAntiAffinityNamespaceCount.compute(broker, (brokerName, count) -> count == null ? 1 : count + 1);
            }
            future.complete(null);
        })).exceptionally(ex -> {
            future.complete(null);
            return null;
        });
    }

    public static CompletableFuture<Map<String, Integer>> getAntiAffinityNamespaceOwnedBrokers(PulsarService pulsar, String namespaceName, Set<Map.Entry<String, ServiceUnitStateData>> bundleOwnershipData) {
        CompletableFuture<Map<String, Integer>> antiAffinityNsBrokersResult = new CompletableFuture<Map<String, Integer>>();
        ((CompletableFuture)LoadManagerShared.getNamespaceAntiAffinityGroupAsync(pulsar, namespaceName).thenAccept(antiAffinityGroupOptional -> {
            if (antiAffinityGroupOptional.isEmpty()) {
                antiAffinityNsBrokersResult.complete(null);
                return;
            }
            String antiAffinityGroup = (String)antiAffinityGroupOptional.get();
            ConcurrentHashMap brokerToAntiAffinityNamespaceCount = new ConcurrentHashMap();
            ArrayList futures = new ArrayList();
            bundleOwnershipData.forEach(etr -> {
                ServiceUnitStateData stateData = (ServiceUnitStateData)etr.getValue();
                String bundle = (String)etr.getKey();
                if (stateData.state() == ServiceUnitState.Owned && StringUtils.isNotBlank((CharSequence)stateData.dstBroker())) {
                    CompletableFuture<Void> future = new CompletableFuture<Void>();
                    futures.add(future);
                    LoadManagerShared.countAntiAffinityNamespaceOwnedBrokers(stateData.dstBroker(), LoadManagerShared.getNamespaceNameFromBundleName(bundle), future, pulsar, antiAffinityGroup, brokerToAntiAffinityNamespaceCount);
                }
            });
            FutureUtil.waitForAll(futures).thenAccept(r -> antiAffinityNsBrokersResult.complete(brokerToAntiAffinityNamespaceCount));
        })).exceptionally(ex -> {
            antiAffinityNsBrokersResult.complete(null);
            return null;
        });
        return antiAffinityNsBrokersResult;
    }

    public static CompletableFuture<Optional<String>> getNamespaceAntiAffinityGroupAsync(PulsarService pulsar, String namespaceName) {
        return pulsar.getPulsarResources().getLocalPolicies().getLocalPoliciesAsync(NamespaceName.get((String)namespaceName)).thenApply(localPoliciesOptional -> {
            if (localPoliciesOptional.isPresent() && StringUtils.isNotBlank((CharSequence)((LocalPolicies)localPoliciesOptional.get()).namespaceAntiAffinityGroup)) {
                return Optional.of(((LocalPolicies)localPoliciesOptional.get()).namespaceAntiAffinityGroup);
            }
            return Optional.empty();
        });
    }

    public static Optional<String> getNamespaceAntiAffinityGroup(PulsarService pulsar, String namespaceName) throws MetadataStoreException {
        Optional localPoliciesOptional = pulsar.getPulsarResources().getLocalPolicies().getLocalPolicies(NamespaceName.get((String)namespaceName));
        if (localPoliciesOptional.isPresent() && StringUtils.isNotBlank((CharSequence)((LocalPolicies)localPoliciesOptional.get()).namespaceAntiAffinityGroup)) {
            return Optional.of(((LocalPolicies)localPoliciesOptional.get()).namespaceAntiAffinityGroup);
        }
        return Optional.empty();
    }

    public static boolean shouldAntiAffinityNamespaceUnload(String namespace, String bundle, String currentBroker, PulsarService pulsar, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>> brokerToNamespaceToBundleRange, Set<String> candidateBrokers) throws Exception {
        Map<String, Integer> brokerNamespaceCount = LoadManagerShared.getAntiAffinityNamespaceOwnedBrokers(pulsar, namespace, brokerToNamespaceToBundleRange).get(10L, TimeUnit.SECONDS);
        return LoadManagerShared.shouldAntiAffinityNamespaceUnload(currentBroker, candidateBrokers, brokerNamespaceCount);
    }

    private static boolean shouldAntiAffinityNamespaceUnload(String currentBroker, Set<String> candidateBrokers, Map<String, Integer> brokerNamespaceCount) {
        if (brokerNamespaceCount != null && !brokerNamespaceCount.isEmpty()) {
            int leastNsCount = Integer.MAX_VALUE;
            int currentBrokerNsCount = 0;
            for (String broker : candidateBrokers) {
                int nsCount = brokerNamespaceCount.getOrDefault(broker, 0);
                if (currentBroker.equals(broker)) {
                    currentBrokerNsCount = nsCount;
                }
                if (leastNsCount <= nsCount) continue;
                leastNsCount = nsCount;
            }
            if (leastNsCount == 0 || currentBrokerNsCount > leastNsCount) {
                return true;
            }
            int leastNsOwnerBrokers = 0;
            for (String broker : candidateBrokers) {
                if (leastNsCount != brokerNamespaceCount.getOrDefault(broker, 0)) continue;
                ++leastNsOwnerBrokers;
            }
            return candidateBrokers.size() != leastNsOwnerBrokers;
        }
        return true;
    }

    public static boolean shouldAntiAffinityNamespaceUnload(String namespace, String bundle, String currentBroker, PulsarService pulsar, Set<Map.Entry<String, ServiceUnitStateData>> bundleOwnershipData, Set<String> candidateBrokers) throws Exception {
        Map<String, Integer> brokerNamespaceCount = LoadManagerShared.getAntiAffinityNamespaceOwnedBrokers(pulsar, namespace, bundleOwnershipData).get(10L, TimeUnit.SECONDS);
        return LoadManagerShared.shouldAntiAffinityNamespaceUnload(currentBroker, candidateBrokers, brokerNamespaceCount);
    }

    public static void filterBrokersWithLargeTopicCount(Set<String> brokerCandidateCache, LoadData loadData, int loadBalancerBrokerMaxTopics) {
        Set filteredBrokerCandidates = brokerCandidateCache.stream().filter(broker -> {
            BrokerData brokerData = loadData.getBrokerData().get(broker);
            long totalTopics = brokerData != null && brokerData.getPreallocatedBundleData() != null ? brokerData.getPreallocatedBundleData().values().stream().mapToLong(preAllocatedBundle -> preAllocatedBundle.getTopics()).sum() + (long)brokerData.getLocalData().getNumTopics() : 0L;
            return totalTopics <= (long)loadBalancerBrokerMaxTopics;
        }).collect(Collectors.toSet());
        if (!filteredBrokerCandidates.isEmpty()) {
            brokerCandidateCache.clear();
            brokerCandidateCache.addAll(filteredBrokerCandidates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshBrokerToFailureDomainMap(PulsarService pulsar, Map<String, String> brokerToFailureDomainMap) {
        if (!pulsar.getConfiguration().isFailureDomainsEnabled()) {
            return;
        }
        ClusterResources.FailureDomainResources fdr = pulsar.getPulsarResources().getClusterResources().getFailureDomainResources();
        String clusterName = pulsar.getConfiguration().getClusterName();
        try {
            Map<String, String> map = brokerToFailureDomainMap;
            synchronized (map) {
                HashMap<String, String> tempBrokerToFailureDomainMap = new HashMap<String, String>();
                for (String domainName : fdr.listFailureDomains(clusterName)) {
                    try {
                        Optional domain = fdr.getFailureDomain(clusterName, domainName);
                        if (!domain.isPresent()) continue;
                        for (String broker : ((FailureDomainImpl)domain.get()).brokers) {
                            tempBrokerToFailureDomainMap.put(broker, domainName);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to get domain {}", (Object)domainName, (Object)e);
                    }
                }
                brokerToFailureDomainMap.clear();
                brokerToFailureDomainMap.putAll(tempBrokerToFailureDomainMap);
            }
            LOG.info("Cluster domain refreshed {}", brokerToFailureDomainMap);
        }
        catch (Exception e) {
            LOG.warn("Failed to get domain-list for cluster {}", (Object)e.getMessage());
        }
    }

    public static NamespaceBundle getNamespaceBundle(PulsarService pulsar, String bundle) {
        String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(bundle);
        String bundleRange = LoadManagerShared.getBundleRangeFromBundleName(bundle);
        return pulsar.getNamespaceService().getNamespaceBundleFactory().getBundle(namespaceName, bundleRange);
    }

    public static interface BrokerTopicLoadingPredicate {
        public boolean isEnablePersistentTopics(String var1);

        public boolean isEnableNonPersistentTopics(String var1);
    }
}

