/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.policies;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateChannel;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntiAffinityGroupPolicyHelper {
    private static final Logger log = LoggerFactory.getLogger(AntiAffinityGroupPolicyHelper.class);
    PulsarService pulsar;
    Map<String, String> brokerToFailureDomainMap;
    ServiceUnitStateChannel channel;

    public AntiAffinityGroupPolicyHelper(PulsarService pulsar, ServiceUnitStateChannel channel) {
        this.pulsar = pulsar;
        this.brokerToFailureDomainMap = new HashMap<String, String>();
        this.channel = channel;
    }

    public CompletableFuture<Map<String, BrokerLookupData>> filterAsync(Map<String, BrokerLookupData> brokers, String bundle) {
        return LoadManagerShared.filterAntiAffinityGroupOwnedBrokersAsync(this.pulsar, bundle, brokers.keySet(), this.channel.getOwnershipEntrySet(), this.brokerToFailureDomainMap).thenApply(__ -> brokers);
    }

    public boolean hasAntiAffinityGroupPolicy(String bundle) {
        try {
            return LoadManagerShared.getNamespaceAntiAffinityGroup(this.pulsar, LoadManagerShared.getNamespaceNameFromBundleName(bundle)).isPresent();
        }
        catch (MetadataStoreException e) {
            log.error("Failed to check unload candidates. Assumes that bundle:{} cannot unload ", (Object)bundle, (Object)e);
            return false;
        }
    }

    public void listenFailureDomainUpdate() {
        LoadManagerShared.refreshBrokerToFailureDomainMap(this.pulsar, this.brokerToFailureDomainMap);
        this.pulsar.getPulsarResources().getClusterResources().getFailureDomainResources().registerListener(__ -> this.pulsar.getLoadManagerExecutor().execute(() -> LoadManagerShared.refreshBrokerToFailureDomainMap(this.pulsar, this.brokerToFailureDomainMap)));
    }
}

