/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.impl.SchemasResourceBase;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetAllVersionsSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.IsCompatibilityResponse;
import org.apache.pulsar.common.protocol.schema.LongSchemaVersionResponse;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.protocol.schema.PostSchemaResponse;
import org.apache.pulsar.common.schema.LongSchemaVersion;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/schemas")
@Api(value="/schemas", description="Schemas related admin APIs", tags={"schemas"})
public class SchemasResource
extends SchemasResourceBase {
    private static final Logger log = LoggerFactory.getLogger(SchemasResource.class);

    @GET
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the schema of a topic", response=GetSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist; or Schema is not found for this topic"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void getSchema(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, cluster, namespace, topic);
        ((CompletableFuture)((CompletableFuture)this.getSchemaAsync(authoritative).thenApply(x$0 -> this.convertToSchemaResponse((SchemaRegistry.SchemaAndMetadata)x$0))).thenApply(arg_0 -> ((AsyncResponse)response).resume(arg_0))).exceptionally(ex -> {
            if (this.shouldPrintErrorLog((Throwable)ex)) {
                log.error("[{}] Failed to get schema for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            SchemasResource.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/schema/{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the schema of a topic at a given version", response=GetSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist; or Schema is not found for this topic"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void getSchema(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @PathParam(value="version") @Encoded String version, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, cluster, namespace, topic);
        ((CompletableFuture)((CompletableFuture)this.getSchemaAsync(authoritative, version).thenApply(x$0 -> this.convertToSchemaResponse((SchemaRegistry.SchemaAndMetadata)x$0))).thenAccept(arg_0 -> ((AsyncResponse)response).resume(arg_0))).exceptionally(ex -> {
            if (this.shouldPrintErrorLog((Throwable)ex)) {
                log.error("[{}] Failed to get schema for topic {} with version {}", new Object[]{this.clientAppId(), this.topicName, version, ex});
            }
            SchemasResource.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/schemas")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the all schemas of a topic", response=GetAllVersionsSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist; or Schema is not found for this topic"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void getAllSchemas(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, cluster, namespace, topic);
        ((CompletableFuture)((CompletableFuture)this.getAllSchemasAsync(authoritative).thenApply(x$0 -> this.convertToAllVersionsSchemaResponse((List<SchemaRegistry.SchemaAndMetadata>)x$0))).thenAccept(arg_0 -> ((AsyncResponse)response).resume(arg_0))).exceptionally(ex -> {
            if (this.shouldPrintErrorLog((Throwable)ex)) {
                log.error("[{}] Failed to get all schemas for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            SchemasResource.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the schema of a topic", response=DeleteSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void deleteSchema(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, cluster, namespace, topic);
        ((CompletableFuture)this.deleteSchemaAsync(authoritative, force).thenAccept(version -> response.resume((Object)DeleteSchemaResponse.builder().version(SchemasResource.getLongSchemaVersion(version)).build()))).exceptionally(ex -> {
            if (this.shouldPrintErrorLog((Throwable)ex)) {
                log.error("[{}] Failed to delete schemas for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            SchemasResource.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update the schema of a topic", response=PostSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=409, message="Incompatible schema"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=422, message="Invalid schema data"), @ApiResponse(code=500, message="Internal Server Error")})
    public void postSchema(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @ApiParam(value="A JSON value presenting a schema playload. An example of the expected schema can be found down here.", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\"type\": \"STRING\", \"schema\": \"\", \"properties\": { \"key1\" : \"value1\" + } }")})) PostSchemaPayload payload, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, cluster, namespace, topic);
        ((CompletableFuture)this.postSchemaAsync(payload, authoritative).thenAccept(version -> response.resume((Object)PostSchemaResponse.builder().version(version).build()))).exceptionally(ex -> {
            Throwable root = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (root instanceof IncompatibleSchemaException) {
                response.resume((Object)Response.status((int)Response.Status.CONFLICT.getStatusCode(), (String)root.getMessage()).build());
            } else if (root instanceof InvalidSchemaDataException) {
                response.resume((Object)Response.status((int)422, (String)root.getMessage()).build());
            } else {
                if (this.shouldPrintErrorLog((Throwable)ex)) {
                    log.error("[{}] Failed to post schemas for topic {}", new Object[]{this.clientAppId(), this.topicName, root});
                }
                SchemasResource.resumeAsyncResponseExceptionally(response, ex);
            }
            return null;
        });
    }

    @POST
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/compatibility")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="test the schema compatibility", response=IsCompatibilityResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void testCompatibility(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @ApiParam(value="A JSON value presenting a schema playload. An example of the expected schema can be found down here.", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\"type\": \"STRING\", \"schema\": \"\", \"properties\": { \"key1\" : \"value1\" + } }")})) PostSchemaPayload payload, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, cluster, namespace, topic);
        ((CompletableFuture)this.testCompatibilityAsync(payload, authoritative).thenAccept(pair -> response.resume((Object)Response.accepted().entity((Object)IsCompatibilityResponse.builder().isCompatibility(((Boolean)pair.getLeft()).booleanValue()).schemaCompatibilityStrategy(((SchemaCompatibilityStrategy)pair.getRight()).name()).build()).build()))).exceptionally(ex -> {
            if (this.shouldPrintErrorLog((Throwable)ex)) {
                log.error("[{}] Failed to test compatibility for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            SchemasResource.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/version")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="get the version of the schema", response=LongSchemaVersion.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=422, message="Invalid schema data"), @ApiResponse(code=500, message="Internal Server Error")})
    public void getVersionBySchema(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @ApiParam(value="A JSON value presenting a schema playload. An example of the expected schema can be found down here.", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\"type\": \"STRING\", \"schema\": \"\", \"properties\": { \"key1\" : \"value1\" + } }")})) PostSchemaPayload payload, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, cluster, namespace, topic);
        ((CompletableFuture)this.getVersionBySchemaAsync(payload, authoritative).thenAccept(version -> response.resume((Object)LongSchemaVersionResponse.builder().version(version).build()))).exceptionally(ex -> {
            if (this.shouldPrintErrorLog((Throwable)ex)) {
                log.error("[{}] Failed to get version by schema for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            SchemasResource.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }
}

