/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.commons.configuration.Configuration;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.stats.prometheus.metrics.PrometheusMetricsProvider;
import org.apache.pulsar.broker.storage.ManagedLedgerStorage;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerClientFactory
implements ManagedLedgerStorage {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerClientFactory.class);
    private ManagedLedgerFactory managedLedgerFactory;
    private BookKeeper defaultBkClient;
    private final Map<EnsemblePlacementPolicyConfig, BookKeeper> bkEnsemblePolicyToBkClientMap = new ConcurrentHashMap<EnsemblePlacementPolicyConfig, BookKeeper>();
    private StatsProvider statsProvider = new NullStatsProvider();

    @Override
    public void initialize(ServiceConfiguration conf, MetadataStoreExtended metadataStore, BookKeeperClientFactory bookkeeperProvider, EventLoopGroup eventLoopGroup) throws Exception {
        ManagedLedgerFactoryConfig managedLedgerFactoryConfig = new ManagedLedgerFactoryConfig();
        managedLedgerFactoryConfig.setMaxCacheSize((long)conf.getManagedLedgerCacheSizeMB() * 1024L * 1024L);
        managedLedgerFactoryConfig.setCacheEvictionWatermark(conf.getManagedLedgerCacheEvictionWatermark());
        managedLedgerFactoryConfig.setNumManagedLedgerSchedulerThreads(conf.getManagedLedgerNumSchedulerThreads());
        managedLedgerFactoryConfig.setCacheEvictionIntervalMs(conf.getManagedLedgerCacheEvictionIntervalMs());
        managedLedgerFactoryConfig.setCacheEvictionTimeThresholdMillis(conf.getManagedLedgerCacheEvictionTimeThresholdMillis());
        managedLedgerFactoryConfig.setCopyEntriesInCache(conf.isManagedLedgerCacheCopyEntries());
        managedLedgerFactoryConfig.setManagedLedgerMaxReadsInFlightSize(conf.getManagedLedgerMaxReadsInFlightSizeInMB() * 1024L * 1024L);
        managedLedgerFactoryConfig.setPrometheusStatsLatencyRolloverSeconds(conf.getManagedLedgerPrometheusStatsLatencyRolloverSeconds());
        managedLedgerFactoryConfig.setTraceTaskExecution(conf.isManagedLedgerTraceTaskExecution());
        managedLedgerFactoryConfig.setCursorPositionFlushSeconds(conf.getManagedLedgerCursorPositionFlushSeconds());
        managedLedgerFactoryConfig.setManagedLedgerInfoCompressionType(conf.getManagedLedgerInfoCompressionType());
        managedLedgerFactoryConfig.setManagedLedgerInfoCompressionThresholdInBytes(conf.getManagedLedgerInfoCompressionThresholdInBytes());
        managedLedgerFactoryConfig.setStatsPeriodSeconds(conf.getManagedLedgerStatsPeriodSeconds());
        managedLedgerFactoryConfig.setManagedCursorInfoCompressionType(conf.getManagedCursorInfoCompressionType());
        managedLedgerFactoryConfig.setManagedCursorInfoCompressionThresholdInBytes(conf.getManagedCursorInfoCompressionThresholdInBytes());
        ClientConfiguration configuration = new ClientConfiguration();
        if (conf.isBookkeeperClientExposeStatsToPrometheus()) {
            configuration.addProperty("prometheusStatsLatencyRolloverSeconds", (Object)conf.getManagedLedgerPrometheusStatsLatencyRolloverSeconds());
            configuration.addProperty("cluster", (Object)conf.getClusterName());
            this.statsProvider = new PrometheusMetricsProvider();
        }
        this.statsProvider.start((Configuration)configuration);
        StatsLogger statsLogger = this.statsProvider.getStatsLogger("pulsar_managedLedger_client");
        this.defaultBkClient = bookkeeperProvider.create(conf, metadataStore, eventLoopGroup, Optional.empty(), null, statsLogger);
        ManagedLedgerFactoryImpl.BookkeeperFactoryForCustomEnsemblePlacementPolicy bkFactory = ensemblePlacementPolicyConfig -> {
            BookKeeper bkClient = null;
            if (ensemblePlacementPolicyConfig != null && ensemblePlacementPolicyConfig.getPolicyClass() != null) {
                bkClient = this.bkEnsemblePolicyToBkClientMap.computeIfAbsent(ensemblePlacementPolicyConfig, key -> {
                    try {
                        return bookkeeperProvider.create(conf, metadataStore, eventLoopGroup, Optional.ofNullable(ensemblePlacementPolicyConfig.getPolicyClass()), ensemblePlacementPolicyConfig.getProperties(), statsLogger);
                    }
                    catch (Exception e) {
                        log.error("Failed to initialize bk-client for policy {}, properties {}", new Object[]{ensemblePlacementPolicyConfig.getPolicyClass(), ensemblePlacementPolicyConfig.getProperties(), e});
                        return this.defaultBkClient;
                    }
                });
            }
            return bkClient != null ? bkClient : this.defaultBkClient;
        };
        try {
            this.managedLedgerFactory = new ManagedLedgerFactoryImpl(metadataStore, bkFactory, managedLedgerFactoryConfig, statsLogger);
        }
        catch (Exception e) {
            this.statsProvider.stop();
            this.defaultBkClient.close();
            throw e;
        }
    }

    @Override
    public ManagedLedgerFactory getManagedLedgerFactory() {
        return this.managedLedgerFactory;
    }

    @Override
    public BookKeeper getBookKeeperClient() {
        return this.defaultBkClient;
    }

    @Override
    public StatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    @VisibleForTesting
    public Map<EnsemblePlacementPolicyConfig, BookKeeper> getBkEnsemblePolicyToBookKeeperMap() {
        return this.bkEnsemblePolicyToBkClientMap;
    }

    @Override
    public void close() throws IOException {
        try {
            if (null != this.managedLedgerFactory) {
                this.managedLedgerFactory.shutdown();
                log.info("Closed managed ledger factory");
            }
            if (null != this.statsProvider) {
                this.statsProvider.stop();
            }
            try {
                if (null != this.defaultBkClient) {
                    this.defaultBkClient.close();
                }
            }
            catch (RejectedExecutionException ree) {
                log.warn("Encountered exceptions on closing bookkeeper client", (Throwable)ree);
            }
            this.bkEnsemblePolicyToBkClientMap.forEach((policy, bk) -> {
                try {
                    if (bk != null) {
                        bk.close();
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to close bookkeeper-client for policy {}", policy, (Object)e);
                }
            });
            log.info("Closed BookKeeper client");
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }
}

