/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.windowing.triggers;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.functions.windowing.DefaultEvictionContext;
import org.apache.pulsar.functions.windowing.Event;
import org.apache.pulsar.functions.windowing.EvictionPolicy;
import org.apache.pulsar.functions.windowing.TriggerHandler;
import org.apache.pulsar.functions.windowing.TriggerPolicy;

public class CountTriggerPolicy<T>
implements TriggerPolicy<T, Integer> {
    private final int count;
    private final AtomicInteger currentCount;
    private final TriggerHandler handler;
    private final EvictionPolicy<T, ?> evictionPolicy;
    private boolean started;

    public CountTriggerPolicy(int count, TriggerHandler handler, EvictionPolicy<T, ?> evictionPolicy) {
        this.count = count;
        this.currentCount = new AtomicInteger();
        this.handler = handler;
        this.evictionPolicy = evictionPolicy;
        this.started = false;
    }

    @Override
    public void track(Event<T> event) {
        if (this.started && !event.isWatermark() && this.currentCount.incrementAndGet() >= this.count) {
            this.evictionPolicy.setContext(new DefaultEvictionContext(System.currentTimeMillis()));
            this.handler.onTrigger();
        }
    }

    @Override
    public void reset() {
        this.currentCount.set(0);
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Integer getState() {
        return this.currentCount.get();
    }

    @Override
    public void restoreState(Integer state) {
        this.currentCount.set(state);
    }

    public String toString() {
        return "CountTriggerPolicy{count=" + this.count + ", currentCount=" + this.currentCount + ", started=" + this.started + "}";
    }
}

