/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;

public class TxnLogBufferedWriterMetricsStats
implements Closeable {
    static final double[] RECORD_COUNT_PER_ENTRY_BUCKETS = new double[]{10.0, 50.0, 100.0, 200.0, 500.0, 1000.0};
    static final double[] BYTES_SIZE_PER_ENTRY_BUCKETS = new double[]{128.0, 512.0, 1024.0, 2048.0, 4096.0, 16384.0, 102400.0, 1232896.0};
    static final double[] MAX_DELAY_TIME_BUCKETS = new double[]{1.0, 5.0, 10.0};
    private final CollectorRegistry collectorRegistry;
    private final String metricsPrefix;
    private final String[] labelNames;
    private final String[] labelValues;
    private final Histogram recordsPerBatchMetric;
    private final Histogram.Child recordsPerBatchHistogram;
    private final Histogram batchSizeBytesMetric;
    private final Histogram.Child batchSizeBytesHistogram;
    private final Histogram oldestRecordInBatchDelayTimeSecondsMetric;
    private final Histogram.Child oldestRecordInBatchDelayTimeSecondsHistogram;
    private final Counter batchFlushTriggeredByMaxRecordsMetric;
    private final Counter.Child batchFlushTriggeredByMaxRecordsCounter;
    private final Counter batchFlushTriggeredByMaxSizeMetric;
    private final Counter.Child batchFlushTriggeredByMaxSizeCounter;
    private final Counter batchFlushTriggeredByMaxDelayMetric;
    private final Counter.Child batchFlushTriggeredByMaxDelayCounter;
    private final Counter batchFlushTriggeredByLargeSingleDataMetric;
    private final Counter.Child batchFlushTriggeredByLargeSingleDataCounter;
    private final AtomicBoolean closed;

    public TxnLogBufferedWriterMetricsStats(String metricsPrefix, String[] labelNames, String[] labelValues, CollectorRegistry registry) {
        this.collectorRegistry = registry;
        this.metricsPrefix = metricsPrefix;
        this.labelNames = (String[])labelNames.clone();
        this.labelValues = (String[])labelValues.clone();
        String recordsPerBatchMetricName = String.format("%s_bufferedwriter_batch_records", metricsPrefix);
        this.recordsPerBatchMetric = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)new Histogram.Builder().name(recordsPerBatchMetricName)).labelNames(this.labelNames)).help("Records per batch histogram")).buckets(RECORD_COUNT_PER_ENTRY_BUCKETS).register(this.collectorRegistry);
        this.recordsPerBatchHistogram = (Histogram.Child)this.recordsPerBatchMetric.labels(this.labelValues);
        String batchSizeBytesMetricName = String.format("%s_bufferedwriter_batch_size_bytes", metricsPrefix);
        this.batchSizeBytesMetric = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)new Histogram.Builder().name(batchSizeBytesMetricName)).labelNames(this.labelNames)).help("Batch size in bytes histogram")).buckets(BYTES_SIZE_PER_ENTRY_BUCKETS).register(this.collectorRegistry);
        this.batchSizeBytesHistogram = (Histogram.Child)this.batchSizeBytesMetric.labels(this.labelValues);
        String oldestRecordInBatchDelayTimeSecondsMetricName = String.format("%s_bufferedwriter_batch_oldest_record_delay_seconds", metricsPrefix);
        this.oldestRecordInBatchDelayTimeSecondsMetric = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)new Histogram.Builder().name(oldestRecordInBatchDelayTimeSecondsMetricName)).labelNames(this.labelNames)).help("Max record latency in batch histogram")).buckets(MAX_DELAY_TIME_BUCKETS).register(this.collectorRegistry);
        this.oldestRecordInBatchDelayTimeSecondsHistogram = (Histogram.Child)this.oldestRecordInBatchDelayTimeSecondsMetric.labels(this.labelValues);
        String batchFlushTriggeringByMaxRecordsMetricName = String.format("%s_bufferedwriter_flush_trigger_max_records", metricsPrefix);
        this.batchFlushTriggeredByMaxRecordsMetric = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)new Counter.Builder().name(batchFlushTriggeringByMaxRecordsMetricName)).labelNames(this.labelNames)).help("Event count of batch flush triggered by max records count")).register(this.collectorRegistry);
        this.batchFlushTriggeredByMaxRecordsCounter = (Counter.Child)this.batchFlushTriggeredByMaxRecordsMetric.labels(this.labelValues);
        String batchFlushTriggeringByMaxSizeMetricName = String.format("%s_bufferedwriter_flush_trigger_max_size", metricsPrefix);
        this.batchFlushTriggeredByMaxSizeMetric = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)new Counter.Builder().name(batchFlushTriggeringByMaxSizeMetricName)).labelNames(this.labelNames)).help("Event count of batch flush triggered by max bytes size")).register(this.collectorRegistry);
        this.batchFlushTriggeredByMaxSizeCounter = (Counter.Child)this.batchFlushTriggeredByMaxSizeMetric.labels(this.labelValues);
        String batchFlushTriggeringByMaxDelayMetricName = String.format("%s_bufferedwriter_flush_trigger_max_delay", metricsPrefix);
        this.batchFlushTriggeredByMaxDelayMetric = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)new Counter.Builder().name(batchFlushTriggeringByMaxDelayMetricName)).labelNames(this.labelNames)).help("Event count of batch flush triggered by max delay time")).register(this.collectorRegistry);
        this.batchFlushTriggeredByMaxDelayCounter = (Counter.Child)this.batchFlushTriggeredByMaxDelayMetric.labels(this.labelValues);
        String batchFlushTriggeringByLargeSingleDataMetricName = String.format("%s_bufferedwriter_flush_trigger_large_data", metricsPrefix);
        this.batchFlushTriggeredByLargeSingleDataMetric = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)new Counter.Builder().name(batchFlushTriggeringByLargeSingleDataMetricName)).labelNames(this.labelNames)).help("Event count of batch flush triggered by the single large data write")).register(this.collectorRegistry);
        this.batchFlushTriggeredByLargeSingleDataCounter = (Counter.Child)this.batchFlushTriggeredByLargeSingleDataMetric.labels(this.labelValues);
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.collectorRegistry.unregister((Collector)this.recordsPerBatchMetric);
        this.collectorRegistry.unregister((Collector)this.batchSizeBytesMetric);
        this.collectorRegistry.unregister((Collector)this.oldestRecordInBatchDelayTimeSecondsMetric);
        this.collectorRegistry.unregister((Collector)this.batchFlushTriggeredByMaxRecordsMetric);
        this.collectorRegistry.unregister((Collector)this.batchFlushTriggeredByMaxSizeMetric);
        this.collectorRegistry.unregister((Collector)this.batchFlushTriggeredByMaxDelayMetric);
        this.collectorRegistry.unregister((Collector)this.batchFlushTriggeredByLargeSingleDataMetric);
    }

    public void triggerFlushByRecordsCount(int recordCount, long bytesSize, long delayMillis) {
        this.batchFlushTriggeredByMaxRecordsCounter.inc();
        this.observeHistogram(recordCount, bytesSize, delayMillis);
    }

    public void triggerFlushByBytesSize(int recordCount, long bytesSize, long delayMillis) {
        this.batchFlushTriggeredByMaxSizeCounter.inc();
        this.observeHistogram(recordCount, bytesSize, delayMillis);
    }

    public void triggerFlushByByMaxDelay(int recordCount, long bytesSize, long delayMillis) {
        this.batchFlushTriggeredByMaxDelayCounter.inc();
        this.observeHistogram(recordCount, bytesSize, delayMillis);
    }

    public void triggerFlushByLargeSingleData(int recordCount, long bytesSize, long delayMillis) {
        this.batchFlushTriggeredByLargeSingleDataCounter.inc();
        this.observeHistogram(recordCount, bytesSize, delayMillis);
    }

    private void observeHistogram(int recordCount, long bytesSize, long delayMillis) {
        this.recordsPerBatchHistogram.observe((double)recordCount);
        this.batchSizeBytesHistogram.observe((double)bytesSize);
        this.oldestRecordInBatchDelayTimeSecondsHistogram.observe((double)delayMillis / 1000.0);
    }

    public String getMetricsPrefix() {
        return this.metricsPrefix;
    }
}

