/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.util;

import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.apache.pulsar.client.impl.conf.ReaderConfigurationData;
import org.apache.pulsar.docs.tools.BaseGenerateDocumentation;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdGenerateDocumentation
extends BaseGenerateDocumentation {
    private static final Logger log = LoggerFactory.getLogger(CmdGenerateDocumentation.class);

    public String generateDocumentByClassName(String className) throws Exception {
        if (ProxyConfiguration.class.getName().equals(className)) {
            return this.generateDocByFieldContext(className, "Pulsar proxy");
        }
        if (ServiceConfiguration.class.getName().equals(className)) {
            return this.generateDocByFieldContext(className, "Broker");
        }
        if (ClientConfigurationData.class.getName().equals(className)) {
            return this.generateDocByApiModelProperty(className, "Client");
        }
        if (WebSocketProxyConfiguration.class.getName().equals(className)) {
            return this.generateDocByFieldContext(className, "WebSocket");
        }
        if (ProducerConfigurationData.class.getName().equals(className)) {
            return this.generateDocByApiModelProperty(className, "Producer");
        }
        if (ConsumerConfigurationData.class.getName().equals(className)) {
            return this.generateDocByApiModelProperty(className, "Consumer");
        }
        if (ReaderConfigurationData.class.getName().equals(className)) {
            return this.generateDocByApiModelProperty(className, "Reader");
        }
        return "Class [" + className + "] not found";
    }

    public static void main(String[] args) throws Exception {
        CmdGenerateDocumentation generateDocumentation = new CmdGenerateDocumentation();
        generateDocumentation.run(args);
    }
}

