/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.LocalPolicies;

public class NamespaceBundles {
    private final NamespaceName nsname;
    private final ArrayList<NamespaceBundle> bundles;
    private final NamespaceBundleFactory factory;
    protected final long[] partitions;
    public static final Long FULL_LOWER_BOUND = 0L;
    public static final Long FULL_UPPER_BOUND = 0xFFFFFFFFL;
    private final NamespaceBundle fullBundle;
    private final Optional<Pair<LocalPolicies, Long>> localPolicies;

    public NamespaceBundles(NamespaceName nsname, NamespaceBundleFactory factory, Optional<Pair<LocalPolicies, Long>> localPolicies) {
        this(nsname, factory, localPolicies, NamespaceBundles.getPartitions(localPolicies.map(Pair::getLeft)));
    }

    NamespaceBundles(NamespaceName nsname, NamespaceBundleFactory factory, Optional<Pair<LocalPolicies, Long>> localPolicies, Collection<Long> partitions) {
        this(nsname, factory, localPolicies, NamespaceBundles.getPartitions(partitions));
    }

    NamespaceBundles(NamespaceName nsname, NamespaceBundleFactory factory, Optional<Pair<LocalPolicies, Long>> localPolicies, long[] partitions) {
        this.nsname = Objects.requireNonNull(nsname);
        this.factory = Objects.requireNonNull(factory);
        this.localPolicies = localPolicies;
        Preconditions.checkArgument((partitions.length > 0 ? 1 : 0) != 0, (Object)"Can't create bundles w/o partition boundaries");
        this.bundles = new ArrayList();
        this.fullBundle = new NamespaceBundle(nsname, (Range<Long>)Range.range((Comparable)FULL_LOWER_BOUND, (BoundType)BoundType.CLOSED, (Comparable)FULL_UPPER_BOUND, (BoundType)BoundType.CLOSED), factory);
        if (partitions.length == 1) {
            throw new IllegalArgumentException("Need to specify at least 2 boundaries");
        }
        this.partitions = partitions;
        long lowerBound = partitions[0];
        for (int i = 1; i < partitions.length; ++i) {
            long upperBound = partitions[i];
            Preconditions.checkArgument((upperBound >= lowerBound ? 1 : 0) != 0);
            Range newRange = null;
            newRange = i != partitions.length - 1 ? Range.range((Comparable)Long.valueOf(lowerBound), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(upperBound), (BoundType)BoundType.OPEN) : Range.range((Comparable)Long.valueOf(lowerBound), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(upperBound), (BoundType)BoundType.CLOSED);
            this.bundles.add(new NamespaceBundle(nsname, (Range<Long>)newRange, factory));
            lowerBound = upperBound;
        }
    }

    public NamespaceBundle findBundle(TopicName topicName) {
        Preconditions.checkArgument((boolean)this.nsname.equals((Object)topicName.getNamespaceObject()));
        return this.factory.getTopicBundleAssignmentStrategy().findBundle(topicName, this);
    }

    public List<NamespaceBundle> getBundles() {
        return this.bundles;
    }

    public int size() {
        return this.bundles.size();
    }

    public void validateBundle(NamespaceBundle nsBundle) throws Exception {
        int idx = Arrays.binarySearch(this.partitions, nsBundle.getLowerEndpoint());
        Preconditions.checkArgument((idx >= 0 ? 1 : 0) != 0, (Object)"Cannot find bundle in the bundles list");
        Preconditions.checkArgument((boolean)nsBundle.getUpperEndpoint().equals(this.bundles.get(idx).getUpperEndpoint()), (Object)"Invalid upper boundary for bundle");
    }

    public NamespaceBundle getFullBundle() {
        return this.fullBundle;
    }

    protected NamespaceBundle getBundle(long hash) {
        int idx = Arrays.binarySearch(this.partitions, hash);
        int lowerIdx = idx < 0 ? -(idx + 2) : idx;
        return this.bundles.get(lowerIdx);
    }

    private static long[] convertPartitions(SortedSet<Long> partitionsSet) {
        Objects.requireNonNull(partitionsSet);
        long[] partitions = new long[partitionsSet.size()];
        int idx = 0;
        Iterator iterator = partitionsSet.iterator();
        while (iterator.hasNext()) {
            long p = (Long)iterator.next();
            partitions[idx++] = p;
        }
        return partitions;
    }

    public int hashCode() {
        return Objects.hash(this.nsname, this.bundles);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof NamespaceBundles) {
            NamespaceBundles other = (NamespaceBundles)obj;
            return Objects.equals(this.nsname, other.nsname) && Objects.equals(this.bundles, other.bundles);
        }
        return false;
    }

    public Optional<Pair<LocalPolicies, Long>> getLocalPolicies() {
        return this.localPolicies;
    }

    public Optional<Long> getVersion() {
        return this.localPolicies.map(Pair::getRight);
    }

    static long[] getPartitions(BundlesData bundlesData) {
        if (bundlesData == null) {
            return new long[]{Long.decode("0x00000000"), Long.decode("0xffffffff")};
        }
        List boundaries = bundlesData.getBoundaries();
        long[] partitions = new long[boundaries.size()];
        for (int i = 0; i < boundaries.size(); ++i) {
            partitions[i] = Long.decode((String)boundaries.get(i));
        }
        return partitions;
    }

    private static long[] getPartitions(Optional<LocalPolicies> lp) {
        return NamespaceBundles.getPartitions(lp.map(x -> x.bundles).orElse(null));
    }

    private static long[] getPartitions(Collection<Long> partitions) {
        long[] res = new long[partitions.size()];
        int i = 0;
        for (long p : partitions) {
            res[i++] = p;
        }
        return res;
    }

    public BundlesData getBundlesData() {
        List boundaries = Arrays.stream(this.partitions).boxed().map(p -> String.format("0x%08x", p)).collect(Collectors.toList());
        return BundlesData.builder().boundaries(boundaries).numBundles(boundaries.size() - 1).build();
    }

    public LocalPolicies toLocalPolicies() {
        return new LocalPolicies(this.getBundlesData(), (BookieAffinityGroupData)this.localPolicies.map(lp -> ((LocalPolicies)lp.getLeft()).bookieAffinityGroup).orElse(null), (String)this.localPolicies.map(lp -> ((LocalPolicies)lp.getLeft()).namespaceAntiAffinityGroup).orElse(null));
    }
}

