/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.MessageIdAdv;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.BatchMessageContainerImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.client.impl.crypto.MessageCryptoBc;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.compression.CompressionCodecNone;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.protocol.Commands;

public class RawBatchMessageContainerImpl
extends BatchMessageContainerImpl {
    private MessageCrypto<MessageMetadata, MessageMetadata> msgCrypto;
    private Set<String> encryptionKeys;
    private CryptoKeyReader cryptoKeyReader;
    private MessageIdAdv lastAddedMessageId;

    public RawBatchMessageContainerImpl() {
        this.compressionType = CompressionType.NONE;
        this.compressor = new CompressionCodecNone();
    }

    private ByteBuf encrypt(ByteBuf compressedPayload) {
        if (this.msgCrypto == null) {
            return compressedPayload;
        }
        int maxSize = this.msgCrypto.getMaxOutputSize(compressedPayload.readableBytes());
        ByteBuf encryptedPayload = this.allocator.buffer(maxSize);
        ByteBuffer targetBuffer = encryptedPayload.nioBuffer(0, maxSize);
        try {
            this.msgCrypto.encrypt(this.encryptionKeys, this.cryptoKeyReader, () -> this.messageMetadata, compressedPayload.nioBuffer(), targetBuffer);
        }
        catch (PulsarClientException e) {
            encryptedPayload.release();
            compressedPayload.release();
            this.discard((Exception)((Object)e));
            throw new RuntimeException("Failed to encrypt payload", e);
        }
        encryptedPayload.writerIndex(targetBuffer.remaining());
        compressedPayload.release();
        return encryptedPayload;
    }

    public ProducerImpl.OpSendMsg createOpSendMsg() {
        throw new UnsupportedOperationException();
    }

    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    public boolean add(MessageImpl<?> msg, SendCallback callback) {
        this.lastAddedMessageId = (MessageIdAdv)msg.getMessageId();
        return super.add(msg, callback);
    }

    protected boolean isBatchFull() {
        return false;
    }

    public boolean haveEnoughSpace(MessageImpl<?> msg) {
        if (this.lastAddedMessageId == null) {
            return true;
        }
        MessageIdAdv msgId = (MessageIdAdv)msg.getMessageId();
        return msgId.getLedgerId() == this.lastAddedMessageId.getLedgerId() && msgId.getEntryId() == this.lastAddedMessageId.getEntryId();
    }

    public ByteBuf toByteBuf() {
        if (this.numMessagesInBatch > 1) {
            this.messageMetadata.setNumMessagesInBatch(this.numMessagesInBatch);
            this.messageMetadata.setSequenceId(this.lowestSequenceId);
            this.messageMetadata.setHighestSequenceId(this.highestSequenceId);
        }
        MessageImpl lastMessage = (MessageImpl)this.messages.get(this.messages.size() - 1);
        MessageIdImpl lastMessageId = (MessageIdImpl)lastMessage.getMessageId();
        MessageMetadata lastMessageMetadata = lastMessage.getMessageBuilder();
        this.compressionType = lastMessageMetadata.getCompression();
        this.compressor = CompressionCodecProvider.getCompressionCodec((CompressionType)lastMessageMetadata.getCompression());
        if (!lastMessage.getEncryptionCtx().isEmpty()) {
            EncryptionContext encryptionContext = (EncryptionContext)lastMessage.getEncryptionCtx().get();
            if (this.cryptoKeyReader == null) {
                IllegalStateException ex = new IllegalStateException("Messages are encrypted but no cryptoKeyReader is provided.");
                this.discard(ex);
                throw ex;
            }
            this.encryptionKeys = encryptionContext.getKeys().keySet();
            if (this.msgCrypto == null) {
                this.msgCrypto = new MessageCryptoBc(String.format("[%s] [%s]", this.topicName, "RawBatchMessageContainer"), true);
                try {
                    this.msgCrypto.addPublicKeyCipher(this.encryptionKeys, this.cryptoKeyReader);
                }
                catch (PulsarClientException.CryptoException e) {
                    this.discard((Exception)((Object)e));
                    throw new IllegalArgumentException("Failed to set encryption keys", e);
                }
            }
        }
        ByteBuf encryptedPayload = this.encrypt(this.getCompressedBatchMetadataAndPayload());
        this.updateAndReserveBatchAllocatedSize(encryptedPayload.capacity());
        ByteBuf metadataAndPayload = Commands.serializeMetadataAndPayload((Commands.ChecksumType)Commands.ChecksumType.Crc32c, (MessageMetadata)this.messageMetadata, (ByteBuf)encryptedPayload);
        MessageIdData idData = new MessageIdData();
        idData.setLedgerId(lastMessageId.getLedgerId());
        idData.setEntryId(lastMessageId.getEntryId());
        idData.setPartition(lastMessageId.getPartitionIndex());
        int idSize = idData.getSerializedSize();
        int headerSize = 4 + idSize + 4;
        int totalSize = headerSize + metadataAndPayload.readableBytes();
        ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(totalSize);
        buf.writeInt(idSize);
        idData.writeTo(buf);
        buf.writeInt(metadataAndPayload.readableBytes());
        buf.writeBytes(metadataAndPayload);
        encryptedPayload.release();
        this.clear();
        return buf;
    }

    public void clear() {
        this.lastAddedMessageId = null;
        super.clear();
    }
}

