/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

public class GetStatsOptions {
    private final boolean getPreciseBacklog;
    private final boolean subscriptionBacklogSize;
    private final boolean getEarliestTimeInBacklog;
    private final boolean excludePublishers;
    private final boolean excludeConsumers;

    public static GetStatsOptionsBuilder builder() {
        return new GetStatsOptionsBuilder();
    }

    public boolean isGetPreciseBacklog() {
        return this.getPreciseBacklog;
    }

    public boolean isSubscriptionBacklogSize() {
        return this.subscriptionBacklogSize;
    }

    public boolean isGetEarliestTimeInBacklog() {
        return this.getEarliestTimeInBacklog;
    }

    public boolean isExcludePublishers() {
        return this.excludePublishers;
    }

    public boolean isExcludeConsumers() {
        return this.excludeConsumers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetStatsOptions)) {
            return false;
        }
        GetStatsOptions other = (GetStatsOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGetPreciseBacklog() != other.isGetPreciseBacklog()) {
            return false;
        }
        if (this.isSubscriptionBacklogSize() != other.isSubscriptionBacklogSize()) {
            return false;
        }
        if (this.isGetEarliestTimeInBacklog() != other.isGetEarliestTimeInBacklog()) {
            return false;
        }
        if (this.isExcludePublishers() != other.isExcludePublishers()) {
            return false;
        }
        return this.isExcludeConsumers() == other.isExcludeConsumers();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetStatsOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGetPreciseBacklog() ? 79 : 97);
        result = result * 59 + (this.isSubscriptionBacklogSize() ? 79 : 97);
        result = result * 59 + (this.isGetEarliestTimeInBacklog() ? 79 : 97);
        result = result * 59 + (this.isExcludePublishers() ? 79 : 97);
        result = result * 59 + (this.isExcludeConsumers() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "GetStatsOptions(getPreciseBacklog=" + this.isGetPreciseBacklog() + ", subscriptionBacklogSize=" + this.isSubscriptionBacklogSize() + ", getEarliestTimeInBacklog=" + this.isGetEarliestTimeInBacklog() + ", excludePublishers=" + this.isExcludePublishers() + ", excludeConsumers=" + this.isExcludeConsumers() + ")";
    }

    public GetStatsOptions(boolean getPreciseBacklog, boolean subscriptionBacklogSize, boolean getEarliestTimeInBacklog, boolean excludePublishers, boolean excludeConsumers) {
        this.getPreciseBacklog = getPreciseBacklog;
        this.subscriptionBacklogSize = subscriptionBacklogSize;
        this.getEarliestTimeInBacklog = getEarliestTimeInBacklog;
        this.excludePublishers = excludePublishers;
        this.excludeConsumers = excludeConsumers;
    }

    public static class GetStatsOptionsBuilder {
        private boolean getPreciseBacklog;
        private boolean subscriptionBacklogSize;
        private boolean getEarliestTimeInBacklog;
        private boolean excludePublishers;
        private boolean excludeConsumers;

        GetStatsOptionsBuilder() {
        }

        public GetStatsOptionsBuilder getPreciseBacklog(boolean getPreciseBacklog) {
            this.getPreciseBacklog = getPreciseBacklog;
            return this;
        }

        public GetStatsOptionsBuilder subscriptionBacklogSize(boolean subscriptionBacklogSize) {
            this.subscriptionBacklogSize = subscriptionBacklogSize;
            return this;
        }

        public GetStatsOptionsBuilder getEarliestTimeInBacklog(boolean getEarliestTimeInBacklog) {
            this.getEarliestTimeInBacklog = getEarliestTimeInBacklog;
            return this;
        }

        public GetStatsOptionsBuilder excludePublishers(boolean excludePublishers) {
            this.excludePublishers = excludePublishers;
            return this;
        }

        public GetStatsOptionsBuilder excludeConsumers(boolean excludeConsumers) {
            this.excludeConsumers = excludeConsumers;
            return this;
        }

        public GetStatsOptions build() {
            return new GetStatsOptions(this.getPreciseBacklog, this.subscriptionBacklogSize, this.getEarliestTimeInBacklog, this.excludePublishers, this.excludeConsumers);
        }

        public String toString() {
            return "GetStatsOptions.GetStatsOptionsBuilder(getPreciseBacklog=" + this.getPreciseBacklog + ", subscriptionBacklogSize=" + this.subscriptionBacklogSize + ", getEarliestTimeInBacklog=" + this.getEarliestTimeInBacklog + ", excludePublishers=" + this.excludePublishers + ", excludeConsumers=" + this.excludeConsumers + ")";
        }
    }
}

