/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.qos;

import java.util.function.LongSupplier;
import org.apache.pulsar.broker.qos.AsyncTokenBucket;
import org.apache.pulsar.broker.qos.MonotonicSnapshotClock;

public class DynamicRateAsyncTokenBucket
extends AsyncTokenBucket {
    private final LongSupplier rateFunction;
    private final LongSupplier ratePeriodNanosFunction;
    private final double capacityFactor;
    private final double targetFillFactorAfterThrottling;

    protected DynamicRateAsyncTokenBucket(double capacityFactor, LongSupplier rateFunction, MonotonicSnapshotClock clockSource, LongSupplier ratePeriodNanosFunction, long resolutionNanos, double initialTokensFactor, double targetFillFactorAfterThrottling) {
        super(clockSource, resolutionNanos);
        this.capacityFactor = capacityFactor;
        this.rateFunction = rateFunction;
        this.ratePeriodNanosFunction = ratePeriodNanosFunction;
        this.targetFillFactorAfterThrottling = targetFillFactorAfterThrottling;
        this.tokens = (long)((double)rateFunction.getAsLong() * initialTokensFactor);
        this.tokens(false);
    }

    @Override
    protected long getRatePeriodNanos() {
        return this.ratePeriodNanosFunction.getAsLong();
    }

    @Override
    protected long getTargetAmountOfTokensAfterThrottling() {
        return (long)((double)this.getRate() * this.targetFillFactorAfterThrottling);
    }

    @Override
    public long getCapacity() {
        return this.capacityFactor == 1.0 ? this.getRate() : (long)((double)this.getRate() * this.capacityFactor);
    }

    @Override
    public long getRate() {
        return this.rateFunction.getAsLong();
    }
}

