/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerInfo;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ScanOutcome;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerOfflineBacklog;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.GetStatsOptions;
import org.apache.pulsar.broker.service.MessageExpirer;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.EncryptionKeys;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.PartitionedManagedLedgerInfo;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.EntryFilters;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PartitionedTopicInternalStats;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionPolicies;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.policies.data.impl.AutoSubscriptionCreationOverrideImpl;
import org.apache.pulsar.common.policies.data.impl.BacklogQuotaImpl;
import org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.common.policies.data.stats.PartitionedTopicStatsImpl;
import org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.stats.AnalyzeSubscriptionBacklogResult;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentTopicsBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(PersistentTopicsBase.class);
    private static final int OFFLINE_TOPIC_STAT_TTL_MINS = 10;
    private static final String DEPRECATED_CLIENT_VERSION_PREFIX = "Pulsar-CPP-v";
    private static final Version LEAST_SUPPORTED_CLIENT_VERSION_PREFIX = Version.forIntegers((int)1, (int)21);

    protected CompletableFuture<List<String>> internalGetListAsync(Optional<String> bundle) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespaceOperationAsync(this.namespaceName, NamespaceOperation.GET_TOPICS).thenCompose(__ -> this.namespaceResources().namespaceExistsAsync(this.namespaceName))).thenAccept(exists -> {
            if (!exists.booleanValue()) {
                throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
            }
        })).thenCompose(__ -> this.topicResources().listPersistentTopicsAsync(this.namespaceName))).thenApply(topics -> topics.stream().filter(topic -> {
            if (SystemTopicNames.isTransactionInternalName((TopicName)TopicName.get((String)topic))) {
                return false;
            }
            if (bundle.isPresent()) {
                NamespaceBundle b = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundle(TopicName.get((String)topic));
                return b != null && ((String)bundle.get()).equals(b.getBundleRange());
            }
            return true;
        }).collect(Collectors.toList()));
    }

    protected CompletableFuture<List<String>> internalGetPartitionedTopicListAsync() {
        return ((CompletableFuture)this.validateNamespaceOperationAsync(this.namespaceName, NamespaceOperation.GET_TOPICS).thenCompose(__ -> this.namespaceResources().namespaceExistsAsync(this.namespaceName))).thenCompose(namespaceExists -> {
            if (!namespaceExists.booleanValue()) {
                log.warn("[{}] Failed to get partitioned topic list {}: Namespace does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
            }
            return this.getPartitionedTopicListAsync(TopicDomain.getEnum((String)this.domain()));
        });
    }

    protected CompletableFuture<Map<String, Set<AuthAction>>> internalGetPermissionsOnTopic() {
        return this.validateAdminAccessForTenantAsync(this.namespaceName.getTenant()).thenCompose(__ -> this.getAuthorizationService().getPermissionsAsync(this.topicName));
    }

    protected void validateCreateTopic(TopicName topicName) {
        if (SystemTopicNames.isTransactionInternalName((TopicName)topicName)) {
            log.warn("Forbidden to create transaction internal topic: {}", (Object)topicName);
            throw new RestException(Response.Status.BAD_REQUEST, "Cannot create topic in system topic format!");
        }
    }

    public void validateAdminOperationOnTopic(boolean authoritative) {
        this.validateAdminAccessForTenant(this.topicName.getTenant());
        this.validateTopicOwnership(this.topicName, authoritative);
    }

    private CompletableFuture<Void> grantPermissionsAsync(TopicName topicUri, String role, Set<AuthAction> actions) {
        AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
        if (null != authService) {
            return ((CompletableFuture)authService.grantPermissionAsync(topicUri, actions, role, null).thenAccept(__ -> log.info("[{}] Successfully granted access for role {}: {} - topic {}", new Object[]{this.clientAppId(), role, actions, topicUri}))).exceptionally(ex -> {
                Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
                if (realCause instanceof MetadataStoreException.NotFoundException || realCause instanceof IllegalArgumentException) {
                    log.warn("[{}] Failed to set permissions for topic {}: Namespace does not exist", new Object[]{this.clientAppId(), topicUri, realCause});
                    throw new RestException(Response.Status.NOT_FOUND, "Topic's namespace does not exist");
                }
                if (realCause instanceof MetadataStoreException.BadVersionException || realCause instanceof IllegalStateException) {
                    log.warn("[{}] Failed to set permissions for topic {}: {}", new Object[]{this.clientAppId(), topicUri, realCause.getMessage(), realCause});
                    throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
                }
                log.error("[{}] Failed to get permissions for topic {}", new Object[]{this.clientAppId(), topicUri, realCause});
                throw new RestException(realCause);
            });
        }
        String msg = "Authorization is not enabled";
        return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.NOT_IMPLEMENTED, msg)));
    }

    protected void internalGrantPermissionsOnTopic(AsyncResponse asyncResponse, String role, Set<AuthAction> actions) {
        ((CompletableFuture)this.validateAdminAccessForTenantAsync(this.namespaceName.getTenant()).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync().thenCompose(unused1 -> this.grantPermissionsAsync(this.topicName, role, actions).thenAccept(unused -> asyncResponse.resume((Object)Response.noContent().build()))))).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            log.error("[{}] Failed to get permissions for topic {}", new Object[]{this.clientAppId(), this.topicName, realCause});
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, realCause);
            return null;
        });
    }

    protected void internalRevokePermissionsOnTopic(AsyncResponse asyncResponse, String role) {
        ((CompletableFuture)this.validateAdminAccessForTenantAsync(this.namespaceName.getTenant()).thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, true, false).thenCompose(metadata -> {
            int numPartitions = metadata.partitions;
            CompletionStage<Object> future = CompletableFuture.completedFuture(null);
            if (numPartitions > 0) {
                for (int i = 0; i < numPartitions; ++i) {
                    TopicName topicNamePartition = this.topicName.getPartition(i);
                    future = future.thenComposeAsync(unused -> this.getAuthorizationService().revokePermissionAsync(topicNamePartition, role));
                }
            }
            return ((CompletableFuture)future.thenComposeAsync(unused -> this.getAuthorizationService().revokePermissionAsync(this.topicName, role))).thenAccept(unused -> asyncResponse.resume((Object)Response.noContent().build()));
        }))).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            log.error("[{}] Failed to revoke permissions for topic {}", new Object[]{this.clientAppId(), this.topicName, realCause});
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, realCause);
            return null;
        });
    }

    protected CompletableFuture<Void> internalCreateNonPartitionedTopicAsync(boolean authoritative, Map<String, String> properties) {
        CompletionStage<Void> ret = this.validateNonPartitionTopicNameAsync(this.topicName.getLocalName());
        if (this.topicName.isGlobal()) {
            ret = ret.thenCompose(__ -> this.validateGlobalNamespaceOwnershipAsync(this.namespaceName));
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)ret.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateNamespaceOperationAsync(this.topicName.getNamespaceObject(), NamespaceOperation.CREATE_TOPIC))).thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, false, false))).thenAccept(partitionMetadata -> {
            if (partitionMetadata.partitions > 0) {
                log.warn("[{}] Partitioned topic with the same name already exists {}", (Object)this.clientAppId(), (Object)this.topicName);
                throw new RestException(Response.Status.CONFLICT, "This topic already exists");
            }
        })).thenCompose(__ -> this.pulsar().getBrokerService().getTopicIfExists(this.topicName.toString()))).thenCompose(existedTopic -> {
            if (existedTopic.isPresent()) {
                log.error("[{}] Topic {} already exists", (Object)this.clientAppId(), (Object)this.topicName);
                throw new RestException(Response.Status.CONFLICT, "This topic already exists");
            }
            return this.pulsar().getBrokerService().getTopic(this.topicName.toString(), true, properties);
        })).thenAccept(__ -> log.info("[{}] Successfully created non-partitioned topic {}", (Object)this.clientAppId(), (Object)this.topicName));
    }

    @Nonnull
    protected CompletableFuture<Void> internalUpdatePartitionedTopicAsync(int expectPartitions, boolean updateLocal, boolean force) {
        PulsarService pulsarService = this.pulsar();
        return pulsarService.getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName).thenCompose(partitionedTopicMetadata -> {
            PulsarAdmin admin;
            int currentMetadataPartitions = partitionedTopicMetadata.partitions;
            if (currentMetadataPartitions <= 0) {
                throw new RestException(Response.Status.CONFLICT, String.format("Topic %s is not the partitioned topic.", this.topicName));
            }
            if (expectPartitions < currentMetadataPartitions) {
                throw new RestException(422, String.format("Desired partitions %s can't be less than the current partitions %s.", expectPartitions, currentMetadataPartitions));
            }
            int brokerMaximumPartitionsPerTopic = pulsarService.getConfiguration().getMaxNumPartitionsPerPartitionedTopic();
            if (brokerMaximumPartitionsPerTopic != 0 && expectPartitions > brokerMaximumPartitionsPerTopic) {
                throw new RestException(422, String.format("Desired partitions %s can't be greater than the maximum partitions per topic %s.", expectPartitions, brokerMaximumPartitionsPerTopic));
            }
            try {
                admin = pulsarService.getAdminClient();
            }
            catch (PulsarServerException ex) {
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, Throwables.getRootCause((Throwable)ex));
            }
            CompletionStage<Object> checkFuture = !force ? admin.topics().getListAsync(this.topicName.getNamespace(), this.topicName.getDomain()).thenAccept(topics -> {
                List existingPartitions = topics.stream().map(TopicName::get).filter(candidateTopicName -> candidateTopicName.getPartitionedTopicName().equals(this.topicName.getPartitionedTopicName())).collect(Collectors.toList());
                Optional<Integer> maximumPartitionIndex = existingPartitions.stream().map(TopicName::getPartitionIndex).max(Integer::compareTo);
                if (maximumPartitionIndex.isPresent() && maximumPartitionIndex.get() >= currentMetadataPartitions) {
                    List unexpectedPartitions = existingPartitions.stream().filter(candidateTopicName -> candidateTopicName.getPartitionIndex() > currentMetadataPartitions).map(TopicName::toString).collect(Collectors.toList());
                    throw new RestException(Response.Status.CONFLICT, String.format("Exist unexpected topic partition(partition index grater than current metadata maximum index %s) %s ", currentMetadataPartitions, StringUtils.join(unexpectedPartitions, (String)",")));
                }
            }) : CompletableFuture.completedFuture(null);
            return ((CompletableFuture)checkFuture.thenCompose(topics -> {
                CompletableFuture updateMetadataFuture = expectPartitions == currentMetadataPartitions ? CompletableFuture.completedFuture(null) : this.namespaceResources().getPartitionedTopicResources().updatePartitionedTopicAsync(this.topicName, m -> new PartitionedTopicMetadata(expectPartitions, m.properties));
                return ((CompletableFuture)updateMetadataFuture.thenCompose(__ -> this.tryCreatePartitionsAsync(expectPartitions))).thenCompose(__ -> admin.topics().getStatsAsync(this.topicName.getPartition(0).toString()).thenCompose(stats -> {
                    List futures = stats.getSubscriptions().entrySet().stream().filter(entry -> ((SubscriptionStats)entry.getValue()).isDurable()).map(entry -> {
                        ArrayList<CompletionStage> innerFutures = new ArrayList<CompletionStage>(expectPartitions);
                        for (int i = 0; i < expectPartitions; ++i) {
                            innerFutures.add(admin.topics().createSubscriptionAsync(this.topicName.getPartition(i).toString(), (String)entry.getKey(), MessageId.earliest, ((SubscriptionStats)entry.getValue()).isReplicated(), ((SubscriptionStats)entry.getValue()).getSubscriptionProperties()).exceptionally(ex -> {
                                Throwable rc = FutureUtil.unwrapCompletionException((Throwable)ex);
                                if (!(rc instanceof PulsarAdminException.ConflictException)) {
                                    log.warn("[{}] got an error while copying the subscription to the partition {}.", (Object)this.topicName, (Object)Throwables.getRootCause((Throwable)rc));
                                    throw FutureUtil.wrapToCompletionException((Throwable)rc);
                                }
                                return null;
                            }));
                        }
                        return FutureUtil.waitForAll(innerFutures);
                    }).collect(Collectors.toList());
                    return FutureUtil.waitForAll(futures);
                }));
            })).thenCompose(__ -> {
                if (updateLocal || !this.topicName.isGlobal()) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.namespaceResources().getPoliciesAsync(this.namespaceName).thenCompose(policies -> {
                    if (!policies.isPresent()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    Set replicationClusters = ((Policies)policies.get()).replication_clusters;
                    if (replicationClusters.size() == 0) {
                        return CompletableFuture.completedFuture(null);
                    }
                    boolean containsCurrentCluster = replicationClusters.contains(this.pulsar().getConfig().getClusterName());
                    if (!containsCurrentCluster) {
                        log.error("[{}] local cluster is not part of replicated cluster for namespace {}", (Object)this.clientAppId(), (Object)this.topicName);
                        throw new RestException(422, "Local cluster is not part of replicate cluster list");
                    }
                    if (replicationClusters.size() == 1) {
                        return CompletableFuture.completedFuture(null);
                    }
                    List futures = replicationClusters.stream().map(replicationCluster -> admin.clusters().getClusterAsync(replicationCluster).thenCompose(clusterData -> pulsarService.getBrokerService().getClusterPulsarAdmin((String)replicationCluster, Optional.of(clusterData)).topics().updatePartitionedTopicAsync(this.topicName.toString(), expectPartitions, true, force).exceptionally(ex -> {
                        log.warn("[{}][{}] Update remote cluster partition fail.", new Object[]{this.topicName, replicationCluster, ex});
                        throw FutureUtil.wrapToCompletionException((Throwable)ex);
                    }))).collect(Collectors.toList());
                    return FutureUtil.waitForAll(futures);
                });
            });
        });
    }

    protected void internalCreateMissedPartitions(AsyncResponse asyncResponse) {
        ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, false, false).thenAccept(metadata -> {
            if (metadata != null) {
                ((CompletableFuture)this.tryCreatePartitionsAsync(metadata.partitions).thenAccept(v -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(e -> {
                    log.error("[{}] Failed to create partitions for topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, e);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to create partitions for topic {}", (Object)this.clientAppId(), (Object)this.topicName);
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected CompletableFuture<Void> internalSetDelayedDeliveryPolicies(DelayedDeliveryPolicies deliveryPolicies, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            topicPolicies.setDelayedDeliveryEnabled(deliveryPolicies == null ? null : Boolean.valueOf(deliveryPolicies.isActive()));
            topicPolicies.setDelayedDeliveryTickTimeMillis(deliveryPolicies == null ? null : Long.valueOf(deliveryPolicies.getTickTime()));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected PartitionedTopicMetadata internalGetPartitionedMetadata(boolean authoritative, boolean checkAllowAutoCreation) {
        return (PartitionedTopicMetadata)this.sync(() -> this.internalGetPartitionedMetadataAsync(authoritative, checkAllowAutoCreation));
    }

    protected CompletableFuture<PartitionedTopicMetadata> internalGetPartitionedMetadataAsync(boolean authoritative, boolean checkAllowAutoCreation) {
        return this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, checkAllowAutoCreation).thenCompose(metadata -> {
            CompletableFuture<Void> ret = metadata.partitions == 0 && !checkAllowAutoCreation ? this.internalCheckTopicExists(this.topicName) : (metadata.partitions > 1 ? this.internalValidateClientVersionAsync() : CompletableFuture.completedFuture(null));
            return ret.thenApply(__ -> metadata);
        });
    }

    protected CompletableFuture<Map<String, String>> internalGetPropertiesAsync(boolean authoritative) {
        return ((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.GET_METADATA))).thenCompose(__ -> {
            if (this.topicName.isPartitioned()) {
                return this.getPropertiesAsync();
            }
            return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName).thenCompose(metadata -> {
                if (metadata.partitions == 0) {
                    return this.getPropertiesAsync();
                }
                return CompletableFuture.completedFuture(metadata.properties);
            });
        });
    }

    private CompletableFuture<Map<String, String>> getPropertiesAsync() {
        return this.pulsar().getBrokerService().getTopicIfExists(this.topicName.toString()).thenApply(opt -> {
            if (!opt.isPresent()) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()));
            }
            return ((PersistentTopic)opt.get()).getManagedLedger().getProperties();
        });
    }

    protected CompletableFuture<Void> internalUpdatePropertiesAsync(boolean authoritative, Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("[{}] [{}] properties is empty, ignore update", (Object)this.clientAppId(), (Object)this.topicName);
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.UPDATE_METADATA))).thenCompose(__ -> {
            if (this.topicName.isPartitioned()) {
                return this.internalUpdateNonPartitionedTopicProperties(properties);
            }
            return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName).thenCompose(metadata -> {
                if (metadata.partitions == 0) {
                    return this.internalUpdateNonPartitionedTopicProperties(properties);
                }
                return this.namespaceResources().getPartitionedTopicResources().updatePartitionedTopicAsync(this.topicName, p -> new PartitionedTopicMetadata(p.partitions, p.properties == null ? properties : MapUtils.putAll((Map)p.properties, (Object[])properties.entrySet().toArray())));
            });
        })).thenAccept(__ -> log.info("[{}] [{}] update properties success with properties {}", new Object[]{this.clientAppId(), this.topicName, properties}));
    }

    private CompletableFuture<Void> internalUpdateNonPartitionedTopicProperties(Map<String, String> properties) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.pulsar().getBrokerService().getTopicIfExists(this.topicName.toString()).thenAccept(opt -> {
            if (!opt.isPresent()) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()));
            }
            final ManagedLedger managedLedger = ((PersistentTopic)opt.get()).getManagedLedger();
            managedLedger.asyncSetProperties(properties, new AsyncCallbacks.UpdatePropertiesCallback(){

                public void updatePropertiesComplete(Map<String, String> properties, Object ctx) {
                    if (managedLedger.getConfig().getProperties() == null) {
                        managedLedger.getConfig().setProperties(new HashMap());
                    }
                    managedLedger.getConfig().getProperties().putAll(properties);
                    future.complete(null);
                }

                public void updatePropertiesFailed(ManagedLedgerException exception, Object ctx) {
                    future.completeExceptionally(exception);
                }
            }, null);
        });
        return future;
    }

    protected CompletableFuture<Void> internalRemovePropertiesAsync(boolean authoritative, String key) {
        return ((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.DELETE_METADATA))).thenCompose(__ -> {
            if (this.topicName.isPartitioned()) {
                return this.internalRemoveNonPartitionedTopicProperties(key);
            }
            return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName).thenCompose(metadata -> {
                if (metadata.partitions == 0) {
                    return this.internalRemoveNonPartitionedTopicProperties(key);
                }
                return this.namespaceResources().getPartitionedTopicResources().updatePartitionedTopicAsync(this.topicName, p -> {
                    if (p.properties != null) {
                        p.properties.remove(key);
                    }
                    return new PartitionedTopicMetadata(p.partitions, p.properties);
                });
            });
        })).thenAccept(__ -> log.info("[{}] remove [{}] properties success with key {}", new Object[]{this.clientAppId(), this.topicName, key}));
    }

    private CompletableFuture<Void> internalRemoveNonPartitionedTopicProperties(String key) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.pulsar().getBrokerService().getTopicIfExists(this.topicName.toString()).thenAccept(opt -> {
            if (!opt.isPresent()) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()));
            }
            ManagedLedger managedLedger = ((PersistentTopic)opt.get()).getManagedLedger();
            managedLedger.asyncDeleteProperty(key, new AsyncCallbacks.UpdatePropertiesCallback(){

                public void updatePropertiesComplete(Map<String, String> properties, Object ctx) {
                    future.complete(null);
                }

                public void updatePropertiesFailed(ManagedLedgerException exception, Object ctx) {
                    future.completeExceptionally(exception);
                }
            }, null);
        });
        return future;
    }

    protected CompletableFuture<Void> internalCheckTopicExists(TopicName topicName) {
        return this.pulsar().getNamespaceService().checkTopicExists(topicName).thenAccept(exist -> {
            if (!exist.booleanValue()) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(topicName.toString()));
            }
        });
    }

    protected void internalDeletePartitionedTopic(AsyncResponse asyncResponse, boolean authoritative, boolean force) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateNamespaceOperationAsync(this.topicName.getNamespaceObject(), NamespaceOperation.DELETE_TOPIC))).thenCompose(__ -> this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName).thenCompose(partitionedMeta -> {
            int numPartitions = partitionedMeta.partitions;
            if (numPartitions < 1) {
                return CompletableFuture.completedFuture(null);
            }
            return this.internalRemovePartitionsAuthenticationPoliciesAsync().thenCompose(unused -> this.internalRemovePartitionsTopicAsync(numPartitions, force));
        }))).thenCompose(ignore -> this.pulsar().getBrokerService().deleteSchema(this.topicName).exceptionally(ex -> null))).thenCompose(__ -> this.getPulsarResources().getNamespaceResources().getPartitionedTopicResources().runWithMarkDeleteAsync(this.topicName, () -> this.namespaceResources().getPartitionedTopicResources().deletePartitionedTopicAsync(this.topicName)))).thenAccept(__ -> {
            log.info("[{}] Deleted partitioned topic {}", (Object)this.clientAppId(), (Object)this.topicName);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof PulsarAdminException.PreconditionFailedException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Topic has active producers/subscriptions")));
            } else if (realCause instanceof WebApplicationException) {
                asyncResponse.resume(realCause);
            } else if (realCause instanceof MetadataStoreException.NotFoundException) {
                log.warn("Namespace policies of {} not found", (Object)this.topicName.getNamespaceObject());
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getPartitionedTopicNotFoundErrorMessage(this.topicName.toString()))))));
            } else if (realCause instanceof PulsarAdminException) {
                asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)realCause)));
            } else if (realCause instanceof MetadataStoreException.BadVersionException) {
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Concurrent modification")))));
            } else {
                if (!PersistentTopicsBase.isRedirectException(ex)) {
                    log.error("[{}] Fail to Delete partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, realCause});
                }
                asyncResponse.resume((Throwable)((Object)new RestException(realCause)));
            }
            return null;
        });
    }

    private CompletableFuture<Void> internalRemovePartitionsTopicAsync(int numPartitions, boolean force) {
        return this.pulsar().getPulsarResources().getNamespaceResources().getPartitionedTopicResources().runWithMarkDeleteAsync(this.topicName, () -> this.internalRemovePartitionsTopicNoAutoCreationDisableAsync(numPartitions, force));
    }

    private CompletableFuture<Void> internalRemovePartitionsTopicNoAutoCreationDisableAsync(int numPartitions, boolean force) {
        return FutureUtil.waitForAll((Collection)IntStream.range(0, numPartitions).mapToObj(i -> {
            TopicName topicNamePartition = this.topicName.getPartition(i);
            try {
                CompletableFuture future = new CompletableFuture();
                this.pulsar().getAdminClient().topics().deleteAsync(topicNamePartition.toString(), force).whenComplete((r, ex) -> {
                    if (ex != null) {
                        Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
                        if (realCause instanceof PulsarAdminException.NotFoundException) {
                            if (log.isDebugEnabled()) {
                                log.debug("[{}] Partition not found: {}", (Object)this.clientAppId(), (Object)topicNamePartition);
                            }
                            future.complete(null);
                        } else {
                            log.error("[{}] Failed to delete partition {}", new Object[]{this.clientAppId(), topicNamePartition, realCause});
                            future.completeExceptionally(realCause);
                        }
                    } else {
                        future.complete(null);
                    }
                });
                return future;
            }
            catch (PulsarServerException ex2) {
                log.error("[{}] Failed to get admin client while delete partition {}", new Object[]{this.clientAppId(), topicNamePartition, ex2});
                return FutureUtil.failedFuture((Throwable)ex2);
            }
        }).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> internalRemovePartitionsAuthenticationPoliciesAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getAuthorizationService().removePermissionsAsync(this.topicName).whenComplete((r, ex) -> {
            if (ex != null) {
                Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
                if (realCause instanceof MetadataStoreException.NotFoundException) {
                    log.warn("Namespace policies of {} not found", (Object)this.topicName.getNamespaceObject());
                    future.complete(null);
                } else {
                    log.error("Failed to delete authentication policies for partitioned topic {}", (Object)this.topicName, ex);
                    future.completeExceptionally(realCause);
                }
            } else {
                log.info("Successfully delete authentication policies for partitioned topic {}", (Object)this.topicName);
                future.complete(null);
            }
        });
        return future;
    }

    protected void internalUnloadTopic(AsyncResponse asyncResponse, boolean authoritative) {
        log.info("[{}] Unloading topic {}", (Object)this.clientAppId(), (Object)this.topicName);
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)future.thenAccept(__ -> {
            if (this.topicName.isPartitioned()) {
                if (SystemTopicNames.isTransactionCoordinatorAssign((TopicName)this.topicName)) {
                    this.internalUnloadTransactionCoordinatorAsync(asyncResponse, authoritative);
                } else {
                    this.internalUnloadNonPartitionedTopicAsync(asyncResponse, authoritative);
                }
            } else {
                ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(meta -> {
                    if (meta.partitions > 0) {
                        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(meta.partitions);
                        for (int i = 0; i < meta.partitions; ++i) {
                            TopicName topicNamePartition = this.topicName.getPartition(i);
                            try {
                                futures.add(this.pulsar().getAdminClient().topics().unloadAsync(topicNamePartition.toString()));
                                continue;
                            }
                            catch (Exception e) {
                                log.error("[{}] Failed to unload topic {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                                asyncResponse.resume((Throwable)((Object)new RestException(e)));
                                return;
                            }
                        }
                        FutureUtil.waitForAll(futures).handle((result, exception) -> {
                            if (exception != null) {
                                Throwable th = exception.getCause();
                                if (th instanceof PulsarAdminException.NotFoundException) {
                                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, th.getMessage())));
                                } else if (th instanceof WebApplicationException) {
                                    asyncResponse.resume(th);
                                } else {
                                    log.error("[{}] Failed to unload topic {}", new Object[]{this.clientAppId(), this.topicName, exception});
                                    asyncResponse.resume((Throwable)((Object)new RestException((Throwable)exception)));
                                }
                            } else {
                                asyncResponse.resume((Object)Response.noContent().build());
                            }
                            return null;
                        });
                    } else {
                        this.internalUnloadNonPartitionedTopicAsync(asyncResponse, authoritative);
                    }
                })).exceptionally(ex -> {
                    if (!PersistentTopicsBase.isRedirectException(ex)) {
                        log.error("[{}] Failed to get partitioned metadata while unloading topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                    }
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to validate the global namespace ownership while unloading topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected CompletableFuture<DelayedDeliveryPolicies> internalGetDelayedDeliveryPolicies(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> {
            TopicPolicies policies = op.orElseGet(TopicPolicies::new);
            DelayedDeliveryPolicies delayedDeliveryPolicies = null;
            if (policies.isDelayedDeliveryEnabledSet() && policies.isDelayedDeliveryTickTimeMillisSet()) {
                delayedDeliveryPolicies = DelayedDeliveryPolicies.builder().tickTime(policies.getDelayedDeliveryTickTimeMillis().longValue()).active(policies.getDelayedDeliveryEnabled().booleanValue()).build();
            }
            if (delayedDeliveryPolicies == null && applied && (delayedDeliveryPolicies = this.getNamespacePolicies((NamespaceName)this.namespaceName).delayed_delivery_policies) == null) {
                delayedDeliveryPolicies = DelayedDeliveryPolicies.builder().tickTime(this.pulsar().getConfiguration().getDelayedDeliveryTickTimeMillis()).active(this.pulsar().getConfiguration().isDelayedDeliveryEnabled()).build();
            }
            return delayedDeliveryPolicies;
        });
    }

    protected CompletableFuture<OffloadPoliciesImpl> internalGetOffloadPolicies(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> {
            OffloadPoliciesImpl offloadPolicies = op.map(TopicPolicies::getOffloadPolicies).orElse(null);
            if (applied) {
                OffloadPoliciesImpl namespacePolicy = (OffloadPoliciesImpl)this.getNamespacePolicies((NamespaceName)this.namespaceName).offload_policies;
                offloadPolicies = OffloadPoliciesImpl.mergeConfiguration((OffloadPoliciesImpl)offloadPolicies, (OffloadPoliciesImpl)namespacePolicy, (Properties)this.pulsar().getConfiguration().getProperties());
            }
            return offloadPolicies;
        });
    }

    protected CompletableFuture<Void> internalSetOffloadPolicies(OffloadPoliciesImpl offloadPolicies, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setOffloadPolicies(offloadPolicies);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<InactiveTopicPolicies> internalGetInactiveTopicPolicies(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getInactiveTopicPolicies).orElseGet(() -> {
            if (applied) {
                InactiveTopicPolicies policies = this.getNamespacePolicies((NamespaceName)this.namespaceName).inactive_topic_policies;
                return policies == null ? new InactiveTopicPolicies(this.config().getBrokerDeleteInactiveTopicsMode(), this.config().getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds(), this.config().isBrokerDeleteInactiveTopicsEnabled()) : policies;
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetInactiveTopicPolicies(InactiveTopicPolicies inactiveTopicPolicies, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            topicPolicies.setInactiveTopicPolicies(inactiveTopicPolicies);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Integer> internalGetMaxUnackedMessagesOnSubscription(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getMaxUnackedMessagesOnSubscription).orElseGet(() -> {
            if (applied) {
                Integer maxUnackedNum = this.getNamespacePolicies((NamespaceName)this.namespaceName).max_unacked_messages_per_subscription;
                return maxUnackedNum == null ? this.config().getMaxUnackedMessagesPerSubscription() : maxUnackedNum.intValue();
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetMaxUnackedMessagesOnSubscription(Integer maxUnackedNum, boolean isGlobal) {
        if (maxUnackedNum != null && maxUnackedNum < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedNum must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxUnackedMessagesOnSubscription(maxUnackedNum);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Integer> internalGetMaxUnackedMessagesOnConsumer(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getMaxUnackedMessagesOnConsumer).orElseGet(() -> {
            if (applied) {
                Integer maxUnacked = this.getNamespacePolicies((NamespaceName)this.namespaceName).max_unacked_messages_per_consumer;
                return maxUnacked == null ? this.config().getMaxUnackedMessagesPerConsumer() : maxUnacked.intValue();
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetMaxUnackedMessagesOnConsumer(Integer maxUnackedNum, boolean isGlobal) {
        if (maxUnackedNum != null && maxUnackedNum < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedNum must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxUnackedMessagesOnConsumer(maxUnackedNum);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalSetDeduplicationSnapshotInterval(Integer interval, boolean isGlobal) {
        if (interval != null && interval < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "interval must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies policies = op.orElseGet(TopicPolicies::new);
            policies.setDeduplicationSnapshotIntervalSeconds(interval);
            policies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, policies);
        });
    }

    private void internalUnloadNonPartitionedTopicAsync(AsyncResponse asyncResponse, boolean authoritative) {
        ((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(unused -> ((CompletableFuture)((CompletableFuture)this.validateTopicOperationAsync(this.topicName, TopicOperation.UNLOAD).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> topic.close(false))).thenRun(() -> {
            log.info("[{}] Successfully unloaded topic {}", (Object)this.clientAppId(), (Object)this.topicName);
            asyncResponse.resume((Object)Response.noContent().build());
        }))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to unload topic {}, {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private void internalUnloadTransactionCoordinatorAsync(AsyncResponse asyncResponse, boolean authoritative) {
        ((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> ((CompletableFuture)this.validateTopicOperationAsync(this.topicName, TopicOperation.UNLOAD).thenCompose(v -> this.pulsar().getTransactionMetadataStoreService().removeTransactionMetadataStore(TransactionCoordinatorID.get((long)this.topicName.getPartitionIndex())))).thenRun(() -> {
            log.info("[{}] Successfully unloaded tc {}", (Object)this.clientAppId(), (Object)this.topicName.getPartitionIndex());
            asyncResponse.resume((Object)Response.noContent().build());
        }))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to unload tc {},{}", new Object[]{this.clientAppId(), this.topicName.getPartitionIndex(), ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected CompletableFuture<Void> internalDeleteTopicAsync(boolean authoritative, boolean force) {
        return ((CompletableFuture)this.validateNamespaceOperationAsync(this.topicName.getNamespaceObject(), NamespaceOperation.DELETE_TOPIC).thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.pulsar().getBrokerService().deleteTopic(this.topicName.toString(), force));
    }

    private boolean isUnexpectedTopicName(PartitionedTopicMetadata topicMetadata) {
        if (!this.topicName.toString().contains("-partition-")) {
            return false;
        }
        if (topicMetadata.partitions <= 0) {
            return false;
        }
        return this.topicName.getPartition(0).toString().equals(this.topicName.toString());
    }

    protected void internalGetSubscriptions(AsyncResponse asyncResponse, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)future.thenCompose(__ -> ((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(unused -> this.validateTopicOperationAsync(this.topicName, TopicOperation.GET_SUBSCRIPTIONS))).thenAccept(unused1 -> {
            if (this.topicName.isPartitioned()) {
                this.internalGetSubscriptionsForNonPartitionedTopic(asyncResponse);
            } else {
                ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                    block7: {
                        if (partitionMetadata.partitions > 0 && !this.isUnexpectedTopicName((PartitionedTopicMetadata)partitionMetadata)) {
                            try {
                                Set<String> subscriptions = Collections.newSetFromMap(new ConcurrentHashMap(partitionMetadata.partitions));
                                ArrayList<CompletableFuture<Object>> subscriptionFutures = new ArrayList<CompletableFuture<Object>>();
                                if (this.topicName.getDomain() == TopicDomain.persistent) {
                                    ConcurrentHashMap<Integer, CompletableFuture> existsFutures = new ConcurrentHashMap<Integer, CompletableFuture>(partitionMetadata.partitions);
                                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                                        existsFutures.put(i, this.topicResources().persistentTopicExists(this.topicName.getPartition(i)));
                                    }
                                    ((CompletableFuture)((CompletableFuture)FutureUtil.waitForAll(new ArrayList(existsFutures.values())).thenApply(unused2 -> existsFutures.entrySet().stream().filter(e -> (Boolean)((CompletableFuture)e.getValue()).join()).map(item -> this.topicName.getPartition(((Integer)item.getKey()).intValue()).toString()).collect(Collectors.toList()))).thenAccept(topics -> {
                                        if (log.isDebugEnabled()) {
                                            log.debug("activeTopics : {}", topics);
                                        }
                                        topics.forEach(topic -> {
                                            try {
                                                CompletableFuture subscriptionsAsync = this.pulsar().getAdminClient().topics().getSubscriptionsAsync(topic);
                                                subscriptionFutures.add((CompletableFuture<Object>)subscriptionsAsync.thenApply(subscriptions::addAll));
                                            }
                                            catch (PulsarServerException e) {
                                                throw new RestException(e);
                                            }
                                        });
                                    })).thenAccept(unused3 -> this.resumeAsyncResponse(asyncResponse, subscriptions, subscriptionFutures));
                                    break block7;
                                }
                                for (int i = 0; i < partitionMetadata.partitions; ++i) {
                                    CompletableFuture subscriptionsAsync = this.pulsar().getAdminClient().topics().getSubscriptionsAsync(this.topicName.getPartition(i).toString());
                                    subscriptionFutures.add((CompletableFuture<Object>)subscriptionsAsync.thenApply(subscriptions::addAll));
                                }
                                this.resumeAsyncResponse(asyncResponse, subscriptions, subscriptionFutures);
                            }
                            catch (Exception e) {
                                log.error("[{}] Failed to get list of subscriptions for {}", new Object[]{this.clientAppId(), this.topicName, e});
                                asyncResponse.resume((Throwable)e);
                            }
                        } else {
                            this.internalGetSubscriptionsForNonPartitionedTopic(asyncResponse);
                        }
                    }
                })).exceptionally(ex -> {
                    if (!PersistentTopicsBase.isRedirectException(ex)) {
                        log.error("[{}] Failed to get partitioned topic metadata while get subscriptions for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                    }
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to validate the global namespace/topic ownership while get subscriptions for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        }))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to get subscriptions for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private void resumeAsyncResponse(AsyncResponse asyncResponse, Set<String> subscriptions, List<CompletableFuture<Object>> subscriptionFutures) {
        FutureUtil.waitForAll(subscriptionFutures).whenComplete((r, ex) -> {
            if (ex != null) {
                log.warn("[{}] Failed to get list of subscriptions for {}: {}", new Object[]{this.clientAppId(), this.topicName, ex.getMessage()});
                if (ex instanceof PulsarAdminException) {
                    PulsarAdminException pae = (PulsarAdminException)((Object)ex);
                    if (pae.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Internal topics have not been generated yet")));
                        return;
                    }
                    asyncResponse.resume((Throwable)((Object)new RestException(pae)));
                    return;
                }
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                return;
            }
            asyncResponse.resume(new ArrayList(subscriptions));
        });
    }

    private void internalGetSubscriptionsForNonPartitionedTopic(AsyncResponse asyncResponse) {
        ((CompletableFuture)this.getTopicReferenceAsync(this.topicName).thenAccept(topic -> asyncResponse.resume(new ArrayList(topic.getSubscriptions().keys())))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to get list of subscriptions for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected CompletableFuture<? extends TopicStats> internalGetStatsAsync(boolean authoritative, GetStatsOptions getStatsOptions) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenComposeAsync(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.GET_STATS))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> topic.asyncGetStats(getStatsOptions));
    }

    protected CompletableFuture<PersistentTopicInternalStats> internalGetInternalStatsAsync(boolean authoritative, boolean metadata) {
        CompletableFuture<Object> ret = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)ret.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.GET_STATS))).thenCompose(__ -> {
            if (metadata) {
                return this.validateTopicOperationAsync(this.topicName, TopicOperation.GET_METADATA);
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> topic.getInternalStats(metadata));
    }

    protected void internalGetManagedLedgerInfo(AsyncResponse asyncResponse, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)future.thenAccept(__ -> {
            if (this.topicName.isPartitioned()) {
                this.internalGetManagedLedgerInfoForNonPartitionedTopic(asyncResponse);
            } else {
                ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                    if (partitionMetadata.partitions > 0) {
                        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(partitionMetadata.partitions);
                        for (int i = 0; i < partitionMetadata.partitions; ++i) {
                            TopicName topicNamePartition = this.topicName.getPartition(i);
                            try {
                                ObjectReader managedLedgerInfoReader = this.objectReader().forType(ManagedLedgerInfo.class);
                                futures.add(this.pulsar().getAdminClient().topics().getInternalInfoAsync(topicNamePartition.toString()).thenApply(response -> {
                                    try {
                                        return Pair.of((Object)topicNamePartition.toString(), (Object)((ManagedLedgerInfo)managedLedgerInfoReader.readValue(response)));
                                    }
                                    catch (JsonProcessingException e) {
                                        throw new UncheckedIOException((IOException)((Object)e));
                                    }
                                }));
                                continue;
                            }
                            catch (PulsarServerException e) {
                                log.error("[{}] Failed to get admin client while get managed info for {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                                throw new RestException(e);
                            }
                        }
                        FutureUtil.waitForAll(futures).whenComplete((result, exception) -> {
                            if (exception != null) {
                                Throwable t = exception.getCause();
                                if (t instanceof PulsarAdminException.NotFoundException) {
                                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                                } else {
                                    log.error("[{}] Failed to get managed info for {}", new Object[]{this.clientAppId(), this.topicName, t});
                                    asyncResponse.resume((Throwable)((Object)new RestException(t)));
                                }
                            } else {
                                PartitionedManagedLedgerInfo partitionedManagedLedgerInfo = new PartitionedManagedLedgerInfo();
                                for (CompletableFuture infoFuture : futures) {
                                    Pair info = infoFuture.getNow(null);
                                    partitionedManagedLedgerInfo.partitions.put((String)info.getKey(), (ManagedLedgerInfo)info.getValue());
                                }
                                asyncResponse.resume(output -> this.objectWriter().writeValue(output, (Object)partitionedManagedLedgerInfo));
                            }
                        });
                    } else {
                        this.internalGetManagedLedgerInfoForNonPartitionedTopic(asyncResponse);
                    }
                })).exceptionally(ex -> {
                    if (!PersistentTopicsBase.isRedirectException(ex)) {
                        log.error("[{}] Failed to get partitioned metadata while get managed info for {}", new Object[]{this.clientAppId(), this.topicName, ex});
                    }
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to validate the global namespace ownership while get managed info for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalGetManagedLedgerInfoForNonPartitionedTopic(final AsyncResponse asyncResponse) {
        ((CompletableFuture)this.validateTopicOperationAsync(this.topicName, TopicOperation.GET_STATS).thenAccept(__ -> {
            String managedLedger = this.topicName.getPersistenceNamingEncoding();
            this.pulsar().getManagedLedgerFactory().asyncGetManagedLedgerInfo(managedLedger, new AsyncCallbacks.ManagedLedgerInfoCallback(){

                public void getInfoComplete(ManagedLedgerInfo info, Object ctx) {
                    asyncResponse.resume(output -> PersistentTopicsBase.this.objectWriter().writeValue(output, (Object)info));
                }

                public void getInfoFailed(ManagedLedgerException exception, Object ctx) {
                    asyncResponse.resume((Throwable)exception);
                }
            }, null);
        })).exceptionally(ex -> {
            log.error("[{}] Failed to get managed info for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalGetPartitionedStats(AsyncResponse asyncResponse, boolean authoritative, boolean perPartition, GetStatsOptions getStatsOptions) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false))).thenAccept(partitionMetadata -> {
            if (partitionMetadata.partitions == 0) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getPartitionedTopicNotFoundErrorMessage(this.topicName.toString()))));
                return;
            }
            PartitionedTopicStatsImpl stats = new PartitionedTopicStatsImpl(partitionMetadata);
            ArrayList<CompletionStage> topicStatsFutureList = new ArrayList<CompletionStage>(partitionMetadata.partitions);
            org.apache.pulsar.client.admin.GetStatsOptions statsOptions = new org.apache.pulsar.client.admin.GetStatsOptions(getStatsOptions.isGetPreciseBacklog(), getStatsOptions.isSubscriptionBacklogSize(), getStatsOptions.isGetEarliestTimeInBacklog(), getStatsOptions.isExcludePublishers(), getStatsOptions.isExcludeConsumers());
            for (int i = 0; i < partitionMetadata.partitions; ++i) {
                TopicName partition = this.topicName.getPartition(i);
                topicStatsFutureList.add(this.pulsar().getNamespaceService().isServiceUnitOwnedAsync((ServiceUnitId)partition).thenCompose(owned -> {
                    if (owned.booleanValue()) {
                        return this.getTopicReferenceAsync(partition).thenApply(ref -> ref.getStats(getStatsOptions));
                    }
                    try {
                        return this.pulsar().getAdminClient().topics().getStatsAsync(partition.toString(), statsOptions);
                    }
                    catch (PulsarServerException e) {
                        return FutureUtil.failedFuture((Throwable)e);
                    }
                }));
            }
            FutureUtil.waitForAll(topicStatsFutureList).handle((result, exception) -> {
                CompletableFuture statFuture = null;
                for (int i = 0; i < topicStatsFutureList.size(); ++i) {
                    statFuture = (CompletableFuture)topicStatsFutureList.get(i);
                    if (!statFuture.isDone() || statFuture.isCompletedExceptionally()) continue;
                    try {
                        stats.add((TopicStats)statFuture.get());
                        if (!perPartition) continue;
                        stats.getPartitions().put(this.topicName.getPartition(i).toString(), (TopicStats)statFuture.get());
                        continue;
                    }
                    catch (Exception e) {
                        asyncResponse.resume((Throwable)((Object)new RestException(e)));
                        return null;
                    }
                }
                if (perPartition && stats.partitions.isEmpty()) {
                    try {
                        boolean pathExists = this.namespaceResources().getPartitionedTopicResources().partitionedTopicExists(this.topicName);
                        if (!pathExists) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Internal topics have not been generated yet")));
                            return null;
                        }
                        stats.partitions.put(this.topicName.toString(), new TopicStatsImpl());
                    }
                    catch (Exception e) {
                        asyncResponse.resume((Throwable)((Object)new RestException(e)));
                        return null;
                    }
                }
                asyncResponse.resume((Object)stats);
                return null;
            });
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to get partitioned internal stats for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalGetPartitionedStatsInternal(AsyncResponse asyncResponse, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false))).thenAccept(partitionMetadata -> {
            if (partitionMetadata.partitions == 0) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getPartitionedTopicNotFoundErrorMessage(this.topicName.toString()))));
                return;
            }
            PartitionedTopicInternalStats stats = new PartitionedTopicInternalStats(partitionMetadata);
            ArrayList<CompletableFuture> topicStatsFutureList = new ArrayList<CompletableFuture>();
            for (int i = 0; i < partitionMetadata.partitions; ++i) {
                try {
                    topicStatsFutureList.add(this.pulsar().getAdminClient().topics().getInternalStatsAsync(this.topicName.getPartition(i).toString(), false));
                    continue;
                }
                catch (PulsarServerException e) {
                    asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    return;
                }
            }
            FutureUtil.waitForAll(topicStatsFutureList).handle((result, exception) -> {
                CompletableFuture statFuture = null;
                for (int i = 0; i < topicStatsFutureList.size(); ++i) {
                    statFuture = (CompletableFuture)topicStatsFutureList.get(i);
                    if (!statFuture.isDone() || statFuture.isCompletedExceptionally()) continue;
                    try {
                        stats.partitions.put(this.topicName.getPartition(i).toString(), (PersistentTopicInternalStats)statFuture.get());
                        continue;
                    }
                    catch (Exception e) {
                        asyncResponse.resume((Throwable)((Object)new RestException(e)));
                        return null;
                    }
                }
                asyncResponse.resume(!stats.partitions.isEmpty() ? stats : new RestException(Response.Status.NOT_FOUND, "Internal topics have not been generated yet"));
                return null;
            });
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to get partitioned internal stats for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected CompletableFuture<Void> internalDeleteSubscriptionAsync(String subName, boolean authoritative, boolean force) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)future.thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.UNSUBSCRIBE, subName))).thenCompose(__ -> {
            if (this.topicName.isPartitioned()) {
                return this.internalDeleteSubscriptionForNonPartitionedTopicAsync(subName, authoritative, force);
            }
            return this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(partitionMetadata -> {
                if (partitionMetadata.partitions > 0) {
                    PulsarAdmin adminClient;
                    ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                    try {
                        adminClient = this.pulsar().getAdminClient();
                    }
                    catch (PulsarServerException e) {
                        return CompletableFuture.failedFuture(e);
                    }
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        futures.add(adminClient.topics().deleteSubscriptionAsync(topicNamePartition.toString(), subName, false));
                    }
                    return FutureUtil.waitForAll(futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable t = exception.getCause();
                            if (t instanceof PulsarAdminException.NotFoundException) {
                                throw new RestException(Response.Status.NOT_FOUND, "Subscription not found");
                            }
                            if (t instanceof PulsarAdminException.PreconditionFailedException) {
                                throw new RestException(Response.Status.PRECONDITION_FAILED, "Subscription has active connected consumers");
                            }
                            throw new RestException(t);
                        }
                        return null;
                    });
                }
                return this.internalDeleteSubscriptionForNonPartitionedTopicAsync(subName, authoritative, force);
            });
        });
    }

    private CompletableFuture<Void> internalDeleteSubscriptionForNonPartitionedTopicAsync(String subName, boolean authoritative, boolean force) {
        return ((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> {
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName));
            }
            return force ? sub.deleteForcefully() : sub.delete();
        });
    }

    private void internalAnalyzeSubscriptionBacklogForNonPartitionedTopic(AsyncResponse asyncResponse, String subName, Optional<Position> position, boolean authoritative) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.CONSUME, subName))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> {
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName));
            }
            return sub.analyzeBacklog(position);
        })).thenAccept(rawResult -> {
            AnalyzeSubscriptionBacklogResult result = new AnalyzeSubscriptionBacklogResult();
            if (rawResult.getFirstPosition() != null) {
                result.setFirstMessageId(rawResult.getFirstPosition().getLedgerId() + ":" + rawResult.getFirstPosition().getEntryId());
            }
            if (rawResult.getLastPosition() != null) {
                result.setLastMessageId(rawResult.getLastPosition().getLedgerId() + ":" + rawResult.getLastPosition().getEntryId());
            }
            result.setEntries(rawResult.getEntries());
            result.setMessages(rawResult.getMessages());
            result.setFilterAcceptedEntries(rawResult.getFilterAcceptedEntries());
            result.setFilterRejectedEntries(rawResult.getFilterRejectedEntries());
            result.setFilterRescheduledEntries(rawResult.getFilterRescheduledEntries());
            result.setFilterAcceptedMessages(rawResult.getFilterAcceptedMessages());
            result.setFilterRejectedMessages(rawResult.getFilterRejectedMessages());
            result.setFilterRescheduledMessages(rawResult.getFilterRescheduledMessages());
            result.setAborted(rawResult.getScanOutcome() != ScanOutcome.COMPLETED);
            log.info("[{}] analyzeBacklog topic {} subscription {} result {}", new Object[]{this.clientAppId(), subName, this.topicName, result});
            asyncResponse.resume((Object)result);
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to analyze subscription backlog {} {}", new Object[]{this.clientAppId(), this.topicName, subName, cause});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, cause);
            return null;
        });
    }

    private void internalUpdateSubscriptionPropertiesForNonPartitionedTopic(AsyncResponse asyncResponse, String subName, Map<String, String> subscriptionProperties, boolean authoritative) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.CONSUME, subName))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> {
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName));
            }
            return sub.updateSubscriptionProperties(subscriptionProperties);
        })).thenRun(() -> {
            log.info("[{}][{}] Updated subscription {}", new Object[]{this.clientAppId(), this.topicName, subName});
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to update subscription {} {}", new Object[]{this.clientAppId(), this.topicName, subName, cause});
            }
            asyncResponse.resume((Throwable)((Object)new RestException(cause)));
            return null;
        });
    }

    private void internalGetSubscriptionPropertiesForNonPartitionedTopic(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.CONSUME, subName))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenApply(topic -> {
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName));
            }
            return sub.getSubscriptionProperties();
        })).thenAccept(properties -> {
            if (properties == null) {
                properties = Collections.emptyMap();
            }
            asyncResponse.resume((Object)Response.ok(properties).build());
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to update subscription {} {}", new Object[]{this.clientAppId(), this.topicName, subName, cause});
            }
            asyncResponse.resume((Throwable)((Object)new RestException(cause)));
            return null;
        });
    }

    protected void internalDeleteSubscriptionForcefully(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)future.thenAccept(__ -> {
            if (this.topicName.isPartitioned()) {
                this.internalDeleteSubscriptionForNonPartitionedTopicForcefully(asyncResponse, subName, authoritative);
            } else {
                ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                    if (partitionMetadata.partitions > 0) {
                        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                        for (int i = 0; i < partitionMetadata.partitions; ++i) {
                            TopicName topicNamePartition = this.topicName.getPartition(i);
                            try {
                                futures.add(this.pulsar().getAdminClient().topics().deleteSubscriptionAsync(topicNamePartition.toString(), subName, true));
                                continue;
                            }
                            catch (Exception e) {
                                log.error("[{}] Failed to delete subscription forcefully {} {}", new Object[]{this.clientAppId(), topicNamePartition, subName, e});
                                asyncResponse.resume((Throwable)((Object)new RestException(e)));
                                return;
                            }
                        }
                        FutureUtil.waitForAll(futures).handle((result, exception) -> {
                            if (exception != null) {
                                Throwable t = exception.getCause();
                                if (t instanceof PulsarAdminException.NotFoundException) {
                                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                                    return null;
                                }
                                log.error("[{}] Failed to delete subscription forcefully {} {}", new Object[]{this.clientAppId(), this.topicName, subName, t});
                                asyncResponse.resume((Throwable)((Object)new RestException(t)));
                                return null;
                            }
                            asyncResponse.resume((Object)Response.noContent().build());
                            return null;
                        });
                    } else {
                        this.internalDeleteSubscriptionForNonPartitionedTopicForcefully(asyncResponse, subName, authoritative);
                    }
                })).exceptionally(ex -> {
                    if (!PersistentTopicsBase.isRedirectException(ex)) {
                        log.error("[{}] Failed to delete subscription forcefully {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
                    }
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to delete subscription {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private void internalDeleteSubscriptionForNonPartitionedTopicForcefully(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.UNSUBSCRIBE, subName))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> {
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName));
            }
            return sub.deleteForcefully();
        })).thenRun(() -> {
            log.info("[{}][{}] Deleted subscription forcefully {}", new Object[]{this.clientAppId(), this.topicName, subName});
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to delete subscription forcefully {} {}", new Object[]{this.clientAppId(), this.topicName, subName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalSkipAllMessages(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.SKIP, subName))).thenCompose(__ -> {
            if (this.topicName.isPartitioned()) {
                return this.internalSkipAllMessagesForNonPartitionedTopicAsync(asyncResponse, subName);
            }
            return this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(partitionMetadata -> {
                if (partitionMetadata.partitions > 0) {
                    ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            futures.add(this.pulsar().getAdminClient().topics().skipAllMessagesAsync(topicNamePartition.toString(), subName));
                            continue;
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to skip all messages {} {}", new Object[]{this.clientAppId(), topicNamePartition, subName, e});
                            asyncResponse.resume((Throwable)((Object)new RestException(e)));
                            return CompletableFuture.completedFuture(null);
                        }
                    }
                    return FutureUtil.waitForAll(futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable t = exception.getCause();
                            if (t instanceof PulsarAdminException.NotFoundException) {
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                            } else {
                                log.error("[{}] Failed to skip all messages {} {}", new Object[]{this.clientAppId(), this.topicName, subName, t});
                                asyncResponse.resume((Throwable)((Object)new RestException(t)));
                            }
                            return null;
                        }
                        asyncResponse.resume((Object)Response.noContent().build());
                        return null;
                    });
                }
                return this.internalSkipAllMessagesForNonPartitionedTopicAsync(asyncResponse, subName);
            });
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to skip all messages for subscription {} on topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Void> internalSkipAllMessagesForNonPartitionedTopicAsync(AsyncResponse asyncResponse, String subName) {
        return ((CompletableFuture)this.getTopicReferenceAsync(this.topicName).thenCompose(t -> {
            PersistentTopic topic = (PersistentTopic)t;
            BiConsumer<Void, Throwable> biConsumer = (v, ex) -> {
                if (ex != null) {
                    asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                    log.error("[{}] Failed to skip all messages {} {}", new Object[]{this.clientAppId(), this.topicName, subName, ex});
                } else {
                    asyncResponse.resume((Object)Response.noContent().build());
                    log.info("[{}] Cleared backlog on {} {}", new Object[]{this.clientAppId(), this.topicName, subName});
                }
            };
            if (subName.startsWith(topic.getReplicatorPrefix())) {
                String remoteCluster = PersistentReplicator.getRemoteCluster(subName);
                PersistentReplicator repl = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
                if (repl == null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                    return CompletableFuture.completedFuture(null);
                }
                return repl.clearBacklog().whenComplete((BiConsumer)biConsumer);
            }
            PersistentSubscription sub = topic.getSubscription(subName);
            if (sub == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                return CompletableFuture.completedFuture(null);
            }
            return sub.clearBacklog().whenComplete((BiConsumer)biConsumer);
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to skip all messages for subscription {} on topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalSkipMessages(AsyncResponse asyncResponse, String subName, int numMessages, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.SKIP, subName))).thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(partitionMetadata -> {
            if (partitionMetadata.partitions > 0) {
                String msg = "Skip messages on a partitioned topic is not allowed";
                log.warn("[{}] {} {} {}", new Object[]{this.clientAppId(), msg, this.topicName, subName});
                throw new RestException(Response.Status.METHOD_NOT_ALLOWED, msg);
            }
            return this.getTopicReferenceAsync(this.topicName).thenCompose(t -> {
                PersistentTopic topic = (PersistentTopic)t;
                if (topic == null) {
                    throw new RestException((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                }
                if (subName.startsWith(topic.getReplicatorPrefix())) {
                    String remoteCluster = PersistentReplicator.getRemoteCluster(subName);
                    PersistentReplicator repl = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
                    if (repl == null) {
                        return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Replicator not found")));
                    }
                    return repl.skipMessages(numMessages).thenAccept(unused -> {
                        log.info("[{}] Skipped {} messages on {} {}", new Object[]{this.clientAppId(), numMessages, this.topicName, subName});
                        asyncResponse.resume((Object)Response.noContent().build());
                    });
                }
                PersistentSubscription sub = topic.getSubscription(subName);
                if (sub == null) {
                    return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                }
                return sub.skipMessages(numMessages).thenAccept(unused -> {
                    log.info("[{}] Skipped {} messages on {} {}", new Object[]{this.clientAppId(), numMessages, this.topicName, subName});
                    asyncResponse.resume((Object)Response.noContent().build());
                });
            });
        }))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to skip {} messages {} {}", new Object[]{this.clientAppId(), numMessages, this.topicName, subName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalExpireMessagesForAllSubscriptions(AsyncResponse asyncResponse, int expireTimeInSeconds, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)future.thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
            if (this.topicName.isPartitioned()) {
                this.internalExpireMessagesForAllSubscriptionsForNonPartitionedTopic(asyncResponse, (PartitionedTopicMetadata)partitionMetadata, expireTimeInSeconds, authoritative);
            } else if (partitionMetadata.partitions > 0) {
                ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(partitionMetadata.partitions);
                for (int i = 0; i < partitionMetadata.partitions; ++i) {
                    TopicName topicNamePartition = this.topicName.getPartition(i);
                    try {
                        futures.add(this.pulsar().getAdminClient().topics().expireMessagesForAllSubscriptionsAsync(topicNamePartition.toString(), (long)expireTimeInSeconds));
                        continue;
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to expire messages up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, topicNamePartition, e});
                        asyncResponse.resume((Throwable)((Object)new RestException(e)));
                        return;
                    }
                }
                FutureUtil.waitForAll(futures).handle((result, exception) -> {
                    if (exception != null) {
                        Throwable t = FutureUtil.unwrapCompletionException((Throwable)exception);
                        if (t instanceof PulsarAdminException) {
                            log.warn("[{}] Failed to expire messages up to {} on {}: {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, t.toString()});
                        } else {
                            log.error("[{}] Failed to expire messages up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, t});
                        }
                        PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, t);
                        return null;
                    }
                    asyncResponse.resume((Object)Response.noContent().build());
                    return null;
                });
            } else {
                this.internalExpireMessagesForAllSubscriptionsForNonPartitionedTopic(asyncResponse, (PartitionedTopicMetadata)partitionMetadata, expireTimeInSeconds, authoritative);
            }
        }))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to expire messages for all subscription on topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private void internalExpireMessagesForAllSubscriptionsForNonPartitionedTopic(AsyncResponse asyncResponse, PartitionedTopicMetadata partitionMetadata, int expireTimeInSeconds, boolean authoritative) {
        ((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.EXPIRE_MESSAGES))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName).thenAccept(t -> {
            if (t == null) {
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                return;
            }
            if (!(t instanceof PersistentTopic)) {
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Expire messages for all subscriptions on a non-persistent topic is not allowed")));
                return;
            }
            PersistentTopic topic = (PersistentTopic)t;
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>((int)topic.getReplicators().size());
            ArrayList<String> subNames = new ArrayList<String>((int)topic.getSubscriptions().size());
            subNames.addAll(topic.getSubscriptions().keys().stream().filter(subName -> !subName.equals("__compaction")).toList());
            for (int i = 0; i < subNames.size(); ++i) {
                try {
                    futures.add(this.internalExpireMessagesByTimestampForSinglePartitionAsync(partitionMetadata, (String)subNames.get(i), expireTimeInSeconds));
                    continue;
                }
                catch (Exception e) {
                    log.error("[{}] Failed to expire messages for all subscription up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, e});
                    asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    return;
                }
            }
            FutureUtil.waitForAll(futures).handle((result, exception) -> {
                if (exception != null) {
                    Throwable throwable = FutureUtil.unwrapCompletionException((Throwable)exception);
                    if (throwable instanceof RestException) {
                        log.warn("[{}] Failed to expire messages for all subscription up to {} on {}: {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, throwable.toString()});
                    } else {
                        log.error("[{}] Failed to expire messages for all subscription up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, throwable});
                    }
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, throwable);
                    return null;
                }
                asyncResponse.resume((Object)Response.noContent().build());
                return null;
            });
        }))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to expire messages for all subscription up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected CompletableFuture<Void> internalResetCursorAsync(String subName, long timestamp, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.RESET_CURSOR, subName))).thenCompose(__ -> {
            if (this.topicName.isPartitioned()) {
                return this.internalResetCursorForNonPartitionedTopic(subName, timestamp, authoritative);
            }
            return this.internalResetCursorForPartitionedTopic(subName, timestamp, authoritative);
        });
    }

    private CompletableFuture<Void> internalResetCursorForPartitionedTopic(String subName, long timestamp, boolean authoritative) {
        return this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(partitionMetadata -> {
            int numPartitions = partitionMetadata.partitions;
            if (numPartitions > 0) {
                CompletableFuture future = new CompletableFuture();
                AtomicInteger count = new AtomicInteger(numPartitions);
                AtomicInteger failureCount = new AtomicInteger(0);
                AtomicReference partitionException = new AtomicReference();
                for (int i = 0; i < numPartitions; ++i) {
                    TopicName topicNamePartition = this.topicName.getPartition(i);
                    try {
                        this.pulsar().getAdminClient().topics().resetCursorAsync(topicNamePartition.toString(), subName, timestamp).handle((r, ex) -> {
                            if (ex != null) {
                                if (ex instanceof PulsarAdminException.PreconditionFailedException) {
                                    failureCount.incrementAndGet();
                                    partitionException.set(ex);
                                } else {
                                    log.warn("[{}] [{}] Failed to reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), topicNamePartition, subName, timestamp, ex});
                                    future.completeExceptionally((Throwable)ex);
                                    return null;
                                }
                            }
                            if (count.decrementAndGet() == 0) {
                                future.complete(null);
                            }
                            return null;
                        });
                        continue;
                    }
                    catch (Exception e) {
                        log.warn("[{}] [{}] Failed to reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), topicNamePartition, subName, timestamp, e});
                        future.completeExceptionally(e);
                    }
                }
                return future.whenComplete((r, ex) -> {
                    if (failureCount.get() == numPartitions) {
                        log.warn("[{}] [{}] Failed to reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp, partitionException.get()});
                        throw new RestException(Response.Status.PRECONDITION_FAILED, ((Throwable)partitionException.get()).getMessage());
                    }
                    if (failureCount.get() > 0) {
                        log.warn("[{}] [{}] Partial errors for reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp, partitionException.get()});
                    }
                });
            }
            return this.internalResetCursorForNonPartitionedTopic(subName, timestamp, authoritative);
        });
    }

    private CompletableFuture<Void> internalResetCursorForNonPartitionedTopic(String subName, long timestamp, boolean authoritative) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.RESET_CURSOR, subName))).thenCompose(__ -> {
            log.info("[{}] [{}] Received reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp});
            return this.getTopicReferenceAsync(this.topicName);
        })).thenCompose(topic -> {
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName));
            }
            return sub.resetCursor(timestamp);
        })).thenRun(() -> log.info("[{}][{}] Reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp}));
    }

    protected void internalCreateSubscription(AsyncResponse asyncResponse, String subscriptionName, MessageIdImpl messageId, boolean authoritative, boolean replicated, Map<String, String> properties) {
        CompletableFuture<Object> ret = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)ret.thenAccept(__ -> {
            MessageIdImpl targetMessageId = messageId == null ? (MessageIdImpl)MessageId.latest : messageId;
            log.info("[{}][{}] Creating subscription {} at message id {} with properties {}", new Object[]{this.clientAppId(), this.topicName, subscriptionName, targetMessageId, properties});
            if (this.topicName.isPartitioned()) {
                this.internalCreateSubscriptionForNonPartitionedTopic(asyncResponse, subscriptionName, targetMessageId, authoritative, replicated, properties);
            } else {
                ((CompletableFuture)this.pulsar().getBrokerService().isAllowAutoTopicCreationAsync(this.topicName).thenCompose(allowAutoTopicCreation -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, (boolean)allowAutoTopicCreation).thenAccept(partitionMetadata -> {
                    int numPartitions = partitionMetadata.partitions;
                    if (numPartitions > 0) {
                        CompletableFuture future = new CompletableFuture();
                        AtomicInteger count = new AtomicInteger(numPartitions);
                        AtomicInteger failureCount = new AtomicInteger(0);
                        AtomicReference partitionException = new AtomicReference();
                        for (int i = 0; i < numPartitions; ++i) {
                            TopicName topicNamePartition = this.topicName.getPartition(i);
                            try {
                                this.pulsar().getAdminClient().topics().createSubscriptionAsync(topicNamePartition.toString(), subscriptionName, (MessageId)targetMessageId, false, properties).handle((r, ex) -> {
                                    if (!(ex == null || failureCount.incrementAndGet() != numPartitions && ex instanceof PulsarAdminException.ConflictException)) {
                                        partitionException.set(ex);
                                    }
                                    if (count.decrementAndGet() == 0) {
                                        future.complete(null);
                                    }
                                    return null;
                                });
                                continue;
                            }
                            catch (Exception e) {
                                log.warn("[{}] [{}] Failed to create subscription {} at message id {}", new Object[]{this.clientAppId(), topicNamePartition, subscriptionName, targetMessageId, e});
                                future.completeExceptionally(e);
                            }
                        }
                        future.whenComplete((r, ex) -> {
                            if (ex != null) {
                                if (ex instanceof PulsarAdminException) {
                                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)((Object)((Object)((Object)((Object)ex)))))));
                                    return;
                                }
                                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                                return;
                            }
                            if (partitionException.get() != null) {
                                log.warn("[{}] [{}] Failed to create subscription {} at message id {}", new Object[]{this.clientAppId(), this.topicName, subscriptionName, targetMessageId, partitionException.get()});
                                if (partitionException.get() instanceof PulsarAdminException) {
                                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)((Object)((Object)((Object)((Object)((Object)partitionException.get()))))))));
                                    return;
                                }
                                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)partitionException.get())));
                                return;
                            }
                            asyncResponse.resume((Object)Response.noContent().build());
                        });
                    } else {
                        this.internalCreateSubscriptionForNonPartitionedTopic(asyncResponse, subscriptionName, targetMessageId, authoritative, replicated, properties);
                    }
                }))).exceptionally(ex -> {
                    if (!PersistentTopicsBase.isRedirectException(ex)) {
                        log.error("[{}] Failed to create subscription {} on topic {}", new Object[]{this.clientAppId(), subscriptionName, this.topicName, ex});
                    }
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to create subscription {} on topic {}", new Object[]{this.clientAppId(), subscriptionName, this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private void internalCreateSubscriptionForNonPartitionedTopic(AsyncResponse asyncResponse, String subscriptionName, MessageIdImpl targetMessageId, boolean authoritative, boolean replicated, Map<String, String> properties) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.SUBSCRIBE, subscriptionName))).thenCompose(__ -> this.pulsar().getBrokerService().isAllowAutoTopicCreationAsync(this.topicName))).thenCompose(isAllowAutoTopicCreation -> this.pulsar().getBrokerService().getTopic(this.topicName.toString(), (boolean)isAllowAutoTopicCreation))).thenApply(optTopic -> {
            if (optTopic.isPresent()) {
                return (Topic)optTopic.get();
            }
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic does not exist and cannot be auto-created");
        })).thenCompose(topic -> {
            if (topic.getSubscriptions().containsKey((Object)subscriptionName)) {
                throw new RestException(Response.Status.CONFLICT, "Subscription already exists for topic");
            }
            return topic.createSubscription(subscriptionName, CommandSubscribe.InitialPosition.Latest, replicated, properties);
        })).thenCompose(subscription -> {
            ((PersistentSubscription)subscription).deactivateCursor();
            return subscription.resetCursor((Position)PositionImpl.get((long)targetMessageId.getLedgerId(), (long)targetMessageId.getEntryId()));
        })).thenRun(() -> {
            log.info("[{}][{}] Successfully created subscription {} at message id {}", new Object[]{this.clientAppId(), this.topicName, subscriptionName, targetMessageId});
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable t;
            Throwable throwable = t = ex instanceof CompletionException ? ex.getCause() : ex;
            if (!(t instanceof WebApplicationException)) {
                log.warn("[{}][{}] Failed to create subscription {} at message id {}", new Object[]{this.clientAppId(), this.topicName, subscriptionName, targetMessageId, t});
            }
            if (t instanceof BrokerServiceException.SubscriptionInvalidCursorPosition) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Unable to find position for position specified: " + t.getMessage())));
            } else if (t instanceof BrokerServiceException.SubscriptionBusyException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Failed for Subscription Busy: " + t.getMessage())));
            } else {
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, t);
            }
            return null;
        });
    }

    protected void internalUpdateSubscriptionProperties(AsyncResponse asyncResponse, String subName, Map<String, String> subscriptionProperties, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenAccept(__ -> {
            if (this.topicName.isPartitioned()) {
                this.internalUpdateSubscriptionPropertiesForNonPartitionedTopic(asyncResponse, subName, subscriptionProperties, authoritative);
            } else {
                ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAcceptAsync(partitionMetadata -> {
                    if (partitionMetadata.partitions > 0) {
                        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                        for (int i = 0; i < partitionMetadata.partitions; ++i) {
                            TopicName topicNamePartition = this.topicName.getPartition(i);
                            try {
                                futures.add(this.pulsar().getAdminClient().topics().updateSubscriptionPropertiesAsync(topicNamePartition.toString(), subName, subscriptionProperties));
                                continue;
                            }
                            catch (Exception e) {
                                log.error("[{}] Failed to update properties for subscription {} {}", new Object[]{this.clientAppId(), topicNamePartition, subName, e});
                                asyncResponse.resume((Throwable)((Object)new RestException(e)));
                                return;
                            }
                        }
                        FutureUtil.waitForAll(futures).handle((result, exception) -> {
                            if (exception != null) {
                                Throwable t = exception.getCause();
                                if (t instanceof PulsarAdminException.NotFoundException) {
                                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                                    return null;
                                }
                                if (t instanceof PulsarAdminException.PreconditionFailedException) {
                                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Subscription has active connected consumers")));
                                    return null;
                                }
                                log.error("[{}] Failed to update properties for subscription {} {}", new Object[]{this.clientAppId(), this.topicName, subName, t});
                                asyncResponse.resume((Throwable)((Object)new RestException(t)));
                                return null;
                            }
                            asyncResponse.resume((Object)Response.noContent().build());
                            return null;
                        });
                    } else {
                        this.internalUpdateSubscriptionPropertiesForNonPartitionedTopic(asyncResponse, subName, subscriptionProperties, authoritative);
                    }
                }, (Executor)this.pulsar().getExecutor())).exceptionally(ex -> {
                    log.error("[{}] Failed to update properties for subscription {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to update subscription {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalAnalyzeSubscriptionBacklog(AsyncResponse asyncResponse, String subName, Optional<Position> position, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> {
            if (this.topicName.isPartitioned()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(metadata -> {
                if (metadata.partitions > 0) {
                    throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Analyze backlog on a partitioned topic is not allowed, please try do it on specific topic partition");
                }
            });
        })).thenAccept(__ -> this.internalAnalyzeSubscriptionBacklogForNonPartitionedTopic(asyncResponse, subName, position, authoritative))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to analyze back log of subscription {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalGetSubscriptionProperties(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenAccept(__ -> {
            if (this.topicName.isPartitioned()) {
                this.internalGetSubscriptionPropertiesForNonPartitionedTopic(asyncResponse, subName, authoritative);
            } else {
                ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAcceptAsync(partitionMetadata -> {
                    if (partitionMetadata.partitions > 0) {
                        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                        for (int i = 0; i < partitionMetadata.partitions; ++i) {
                            TopicName topicNamePartition = this.topicName.getPartition(i);
                            try {
                                futures.add(this.pulsar().getAdminClient().topics().getSubscriptionPropertiesAsync(topicNamePartition.toString(), subName));
                                continue;
                            }
                            catch (Exception e) {
                                log.error("[{}] Failed to update properties for subscription {} {}", new Object[]{this.clientAppId(), topicNamePartition, subName, e});
                                asyncResponse.resume((Throwable)((Object)new RestException(e)));
                                return;
                            }
                        }
                        FutureUtil.waitForAll(futures).handle((result, exception) -> {
                            if (exception != null) {
                                Throwable t = exception.getCause();
                                if (t instanceof PulsarAdminException.NotFoundException) {
                                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                                    return null;
                                }
                                log.error("[{}] Failed to get properties for subscription {} {}", new Object[]{this.clientAppId(), this.topicName, subName, t});
                                asyncResponse.resume((Throwable)((Object)new RestException(t)));
                                return null;
                            }
                            HashMap aggregatedResult = new HashMap();
                            futures.forEach(f -> {
                                try {
                                    aggregatedResult.putAll((Map)f.get());
                                }
                                catch (Exception impossible) {
                                    asyncResponse.resume((Throwable)((Object)new RestException(impossible)));
                                }
                            });
                            asyncResponse.resume((Object)Response.ok(aggregatedResult).build());
                            return null;
                        });
                    } else {
                        this.internalGetSubscriptionPropertiesForNonPartitionedTopic(asyncResponse, subName, authoritative);
                    }
                }, (Executor)this.pulsar().getExecutor())).exceptionally(ex -> {
                    log.error("[{}] Failed to update properties for subscription {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to update subscription {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalResetCursorOnPosition(AsyncResponse asyncResponse, String subName, boolean authoritative, MessageIdImpl messageId, boolean isExcluded, int batchIndex) {
        CompletionStage<Object> ret = !this.topicName.isPartitioned() ? this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(topicMetadata -> {
            if (topicMetadata.partitions > 0) {
                log.warn("[{}] Not supported operation on partitioned-topic {} {}", new Object[]{this.clientAppId(), this.topicName, subName});
                throw new CompletionException((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Reset-cursor at position is not allowed for partitioned-topic")));
            }
            return CompletableFuture.completedFuture(null);
        }) : CompletableFuture.completedFuture(null);
        CompletionStage<Object> future = this.topicName.isGlobal() ? ret.thenCompose(__ -> this.validateGlobalNamespaceOwnershipAsync(this.namespaceName)) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)future.thenAccept(__ -> {
            log.info("[{}][{}] received reset cursor on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId});
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(ignore -> this.validateTopicOperationAsync(this.topicName, TopicOperation.RESET_CURSOR, subName))).thenCompose(ignore -> this.getTopicReferenceAsync(this.topicName))).thenAccept(topic -> {
                if (topic == null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                    return;
                }
                PersistentSubscription sub = ((PersistentTopic)topic).getSubscription(subName);
                if (sub == null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                    return;
                }
                CompletableFuture<Integer> batchSizeFuture = new CompletableFuture<Integer>();
                this.getEntryBatchSize(batchSizeFuture, (PersistentTopic)topic, messageId, batchIndex);
                ((CompletableFuture)batchSizeFuture.thenAccept(bi -> {
                    PositionImpl seekPosition = this.calculatePositionAckSet(isExcluded, (int)bi, batchIndex, messageId);
                    ((CompletableFuture)sub.resetCursor((Position)seekPosition).thenRun(() -> {
                        log.info("[{}][{}] successfully reset cursor on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId});
                        asyncResponse.resume((Object)Response.noContent().build());
                    })).exceptionally(ex -> {
                        Throwable t = ex instanceof CompletionException ? ex.getCause() : ex;
                        log.warn("[{}][{}] Failed to reset cursor on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, t});
                        if (t instanceof BrokerServiceException.SubscriptionInvalidCursorPosition) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Unable to find position for position specified: " + t.getMessage())));
                        } else if (t instanceof BrokerServiceException.SubscriptionBusyException) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Failed for Subscription Busy: " + t.getMessage())));
                        } else {
                            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, t);
                        }
                        return null;
                    });
                })).exceptionally(e -> {
                    asyncResponse.resume(e);
                    return null;
                });
            })).exceptionally(ex -> {
                if (!PersistentTopicsBase.isRedirectException(ex)) {
                    log.warn("[{}][{}] Failed to reset cursor on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, ex.getCause()});
                }
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex.getCause());
                return null;
            });
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.warn("[{}][{}] Failed to reset cursor on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, ex.getCause()});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex.getCause());
            return null;
        });
    }

    private void getEntryBatchSize(final CompletableFuture<Integer> batchSizeFuture, PersistentTopic topic, MessageIdImpl messageId, int batchIndex) {
        if (batchIndex >= 0) {
            try {
                ManagedLedgerImpl ledger = (ManagedLedgerImpl)topic.getManagedLedger();
                ledger.asyncReadEntry(new PositionImpl(messageId.getLedgerId(), messageId.getEntryId()), new AsyncCallbacks.ReadEntryCallback(){

                    public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                        batchSizeFuture.complete(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void readEntryComplete(Entry entry, Object ctx) {
                        block7: {
                            try {
                                try {
                                    if (entry == null) {
                                        batchSizeFuture.complete(0);
                                        break block7;
                                    }
                                    MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)entry.getDataBuffer());
                                    batchSizeFuture.complete(metadata.getNumMessagesInBatch());
                                }
                                catch (Exception e) {
                                    batchSizeFuture.completeExceptionally((Throwable)((Object)new RestException(e)));
                                }
                            }
                            finally {
                                if (entry != null) {
                                    entry.release();
                                }
                            }
                        }
                    }

                    public String toString() {
                        return String.format("Topic [{}] get entry batch size", PersistentTopicsBase.this.topicName);
                    }
                }, null);
            }
            catch (NullPointerException npe) {
                batchSizeFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Message not found")));
            }
            catch (Exception exception) {
                log.error("[{}] Failed to get message with ledgerId {} entryId {} from {}", new Object[]{this.clientAppId(), messageId.getLedgerId(), messageId.getEntryId(), this.topicName, exception});
                batchSizeFuture.completeExceptionally((Throwable)((Object)new RestException(exception)));
            }
        } else {
            batchSizeFuture.complete(0);
        }
    }

    private PositionImpl calculatePositionAckSet(boolean isExcluded, int batchSize, int batchIndex, MessageIdImpl messageId) {
        PositionImpl seekPosition;
        if (batchSize > 0) {
            BitSetRecyclable bitSet = BitSetRecyclable.create();
            bitSet.set(0, batchSize);
            if (isExcluded) {
                bitSet.clear(0, Math.max(batchIndex + 1, 0));
                if (bitSet.length() > 0) {
                    long[] ackSet = bitSet.toLongArray();
                    seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId(), (long[])ackSet);
                } else {
                    seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId());
                    seekPosition = seekPosition.getNext();
                }
            } else if (batchIndex - 1 >= 0) {
                bitSet.clear(0, batchIndex);
                long[] ackSet = bitSet.toLongArray();
                seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId(), (long[])ackSet);
            } else {
                seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId());
            }
            bitSet.recycle();
        } else {
            seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId());
            seekPosition = isExcluded ? seekPosition.getNext() : seekPosition;
        }
        return seekPosition;
    }

    protected CompletableFuture<Response> internalGetMessageById(long ledgerId, long entryId, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> {
            if (this.topicName.isPartitioned()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(topicMetadata -> {
                if (topicMetadata.partitions > 0) {
                    log.warn("[{}] Not supported getMessageById operation on partitioned-topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                    throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "GetMessageById is not allowed on partitioned-topic");
                }
            });
        })).thenCompose(ignore -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.PEEK_MESSAGES))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> {
            final CompletableFuture results = new CompletableFuture();
            ManagedLedgerImpl ledger = (ManagedLedgerImpl)((PersistentTopic)topic).getManagedLedger();
            ledger.asyncReadEntry(new PositionImpl(ledgerId, entryId), new AsyncCallbacks.ReadEntryCallback(){

                public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                    if (exception instanceof ManagedLedgerException.LedgerNotExistException) {
                        throw new RestException(Response.Status.NOT_FOUND, "Message id not found");
                    }
                    throw new RestException(exception);
                }

                public void readEntryComplete(Entry entry, Object ctx) {
                    try {
                        results.complete(PersistentTopicsBase.this.generateResponseWithEntry(entry));
                    }
                    catch (IOException exception) {
                        throw new RestException(exception);
                    }
                    finally {
                        if (entry != null) {
                            entry.release();
                        }
                    }
                }

                public String toString() {
                    return String.format("Topic [{}] internal get message by id", PersistentTopicsBase.this.topicName);
                }
            }, null);
            return results;
        });
    }

    protected CompletableFuture<MessageId> internalGetMessageIdByTimestampAsync(long timestamp, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> {
            if (this.topicName.isPartitioned()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(metadata -> {
                if (metadata.partitions > 0) {
                    throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Get message ID by timestamp on a partitioned topic is not allowed, please try do it on specific topic partition");
                }
            });
        })).thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.PEEK_MESSAGES))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> {
            if (!(topic instanceof PersistentTopic)) {
                log.error("[{}] Not supported operation of non-persistent topic {} ", (Object)this.clientAppId(), (Object)this.topicName);
                throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Get message ID by timestamp on a non-persistent topic is not allowed");
            }
            PersistentTopic persistentTopic = (PersistentTopic)topic;
            return persistentTopic.getTopicCompactionService().readLastCompactedEntry().thenCompose(lastEntry -> {
                MessageMetadata metadata;
                if (lastEntry == null) {
                    return this.findMessageIdByPublishTime(timestamp, persistentTopic.getManagedLedger());
                }
                Position position = lastEntry.getPosition();
                try {
                    metadata = Commands.parseMessageMetadata((ByteBuf)lastEntry.getDataBuffer());
                }
                finally {
                    lastEntry.release();
                }
                if (timestamp == metadata.getPublishTime()) {
                    return CompletableFuture.completedFuture(new MessageIdImpl(position.getLedgerId(), position.getEntryId(), this.topicName.getPartitionIndex()));
                }
                if (timestamp < metadata.getPublishTime()) {
                    return persistentTopic.getTopicCompactionService().findEntryByPublishTime(timestamp).thenApply(compactedEntry -> {
                        try {
                            MessageIdImpl messageIdImpl = new MessageIdImpl(compactedEntry.getLedgerId(), compactedEntry.getEntryId(), this.topicName.getPartitionIndex());
                            return messageIdImpl;
                        }
                        finally {
                            compactedEntry.release();
                        }
                    });
                }
                return this.findMessageIdByPublishTime(timestamp, persistentTopic.getManagedLedger());
            });
        });
    }

    private CompletableFuture<MessageId> findMessageIdByPublishTime(long timestamp, ManagedLedger managedLedger) {
        return managedLedger.asyncFindPosition(entry -> {
            try {
                long entryTimestamp = Commands.getEntryTimestamp((ByteBuf)entry.getDataBuffer());
                boolean bl = MessageImpl.isEntryPublishedEarlierThan((long)entryTimestamp, (long)timestamp);
                return bl;
            }
            catch (Exception e) {
                log.error("[{}] Error deserializing message for message position find", (Object)this.topicName, (Object)e);
            }
            finally {
                entry.release();
            }
            return false;
        }).thenApply(position -> {
            if (position == null) {
                return null;
            }
            return new MessageIdImpl(position.getLedgerId(), position.getEntryId(), this.topicName.getPartitionIndex());
        });
    }

    protected CompletableFuture<Response> internalPeekNthMessageAsync(String subName, int messagePosition, boolean authoritative) {
        CompletionStage<Object> ret = !this.topicName.isPartitioned() ? this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(topicMetadata -> {
            if (topicMetadata.partitions > 0) {
                throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Peek messages on a partitioned topic is not allowed");
            }
            return CompletableFuture.completedFuture(null);
        }) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)ret.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.PEEK_MESSAGES, subName))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> {
            CompletableFuture<Entry> entry;
            if (!(topic instanceof PersistentTopic)) {
                log.error("[{}] Not supported operation of non-persistent topic {} {}", new Object[]{this.clientAppId(), this.topicName, subName});
                throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Peek messages on a non-persistent topic is not allowed");
            }
            if (subName.startsWith(((PersistentTopic)topic).getReplicatorPrefix())) {
                PersistentReplicator repl = this.getReplicatorReference(subName, (PersistentTopic)topic);
                entry = repl.peekNthMessage(messagePosition);
            } else {
                PersistentSubscription sub = (PersistentSubscription)this.getSubscriptionReference(subName, (PersistentTopic)topic);
                entry = sub.peekNthMessage(messagePosition);
            }
            return entry;
        })).thenCompose(entry -> {
            try {
                Response response = this.generateResponseWithEntry((Entry)entry);
                CompletableFuture<Response> completableFuture = CompletableFuture.completedFuture(response);
                return completableFuture;
            }
            catch (NullPointerException npe) {
                throw new RestException(Response.Status.NOT_FOUND, "Message not found");
            }
            catch (Exception exception) {
                log.error("[{}] Failed to peek message at position {} from {} {}", new Object[]{this.clientAppId(), messagePosition, this.topicName, subName, exception});
                throw new RestException(exception);
            }
            finally {
                if (entry != null) {
                    entry.release();
                }
            }
        });
    }

    protected CompletableFuture<Response> internalExamineMessageAsync(String initialPosition, long messagePosition, boolean authoritative) {
        String initialPositionLocal;
        CompletionStage<Object> ret = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ret = ((CompletableFuture)ret).thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative));
        long messagePositionLocal = messagePosition < 1L ? 1L : messagePosition;
        String string = initialPositionLocal = initialPosition == null ? "latest" : initialPosition;
        if (!this.topicName.isPartitioned()) {
            ret = ((CompletableFuture)((CompletableFuture)ret).thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false))).thenCompose(partitionedTopicMetadata -> {
                if (partitionedTopicMetadata.partitions > 0) {
                    throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Examine messages on a partitioned topic is not allowed, please try examine message on specific topic partition");
                }
                return CompletableFuture.completedFuture(null);
            });
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)ret).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> {
            if (!(topic instanceof PersistentTopic)) {
                log.error("[{}] Not supported operation of non-persistent topic {} ", (Object)this.clientAppId(), (Object)this.topicName);
                throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Examine messages on a non-persistent topic is not allowed");
            }
            try {
                PersistentTopic persistentTopic = (PersistentTopic)topic;
                long totalMessage = persistentTopic.getNumberOfEntries();
                if (totalMessage <= 0L) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Could not examine messages due to the total message is zero");
                }
                PositionImpl startPosition = persistentTopic.getFirstPosition();
                long messageToSkip = initialPositionLocal.equals("earliest") ? messagePositionLocal : totalMessage - messagePositionLocal + 1L;
                final CompletableFuture future = new CompletableFuture();
                PositionImpl readPosition = persistentTopic.getPositionAfterN(startPosition, messageToSkip);
                persistentTopic.asyncReadEntry(readPosition, new AsyncCallbacks.ReadEntryCallback(){

                    public void readEntryComplete(Entry entry, Object ctx) {
                        future.complete(entry);
                    }

                    public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                        future.completeExceptionally(exception);
                    }

                    public String toString() {
                        return String.format("Topic [{}] internal examine message async", PersistentTopicsBase.this.topicName);
                    }
                }, null);
                return future;
            }
            catch (ManagedLedgerException exception) {
                log.error("[{}] Failed to examine message at position {} from {} due to {}", new Object[]{this.clientAppId(), messagePosition, this.topicName, exception});
                throw new RestException(exception);
            }
        })).thenApply(entry -> {
            try {
                Response response = this.generateResponseWithEntry((Entry)entry);
                return response;
            }
            catch (IOException exception) {
                throw new RestException(exception);
            }
            finally {
                if (entry != null) {
                    entry.release();
                }
            }
        });
    }

    private Response generateResponseWithEntry(Entry entry) throws IOException {
        PersistentTopicsBase.checkNotNull(entry);
        PositionImpl pos = (PositionImpl)entry.getPosition();
        ByteBuf metadataAndPayload = entry.getDataBuffer();
        long totalSize = metadataAndPayload.readableBytes();
        BrokerEntryMetadata brokerEntryMetadata = Commands.peekBrokerEntryMetadataIfExist((ByteBuf)metadataAndPayload);
        MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)metadataAndPayload);
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.header("X-Pulsar-Message-ID", (Object)pos.toString());
        Map<String, String> properties = metadata.getPropertiesList().stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue, (v1, v2) -> v2));
        responseBuilder.header("X-Pulsar-PROPERTY", (Object)new Gson().toJson(properties));
        if (brokerEntryMetadata != null) {
            if (brokerEntryMetadata.hasBrokerTimestamp()) {
                responseBuilder.header("X-Pulsar-Broker-Entry-METADATA-timestamp", (Object)DateFormatter.format((long)brokerEntryMetadata.getBrokerTimestamp()));
            }
            if (brokerEntryMetadata.hasIndex()) {
                responseBuilder.header("X-Pulsar-Broker-Entry-METADATA-index", (Object)brokerEntryMetadata.getIndex());
            }
        }
        if (metadata.hasPublishTime()) {
            responseBuilder.header("X-Pulsar-publish-time", (Object)DateFormatter.format((long)metadata.getPublishTime()));
        }
        if (metadata.hasEventTime()) {
            responseBuilder.header("X-Pulsar-event-time", (Object)DateFormatter.format((long)metadata.getEventTime()));
        }
        if (metadata.hasDeliverAtTime()) {
            responseBuilder.header("X-Pulsar-deliver-at-time", (Object)DateFormatter.format((long)metadata.getDeliverAtTime()));
        }
        if (metadata.hasNumMessagesInBatch()) {
            responseBuilder.header("X-Pulsar-num-batch-message", (Object)metadata.getNumMessagesInBatch());
            responseBuilder.header("X-Pulsar-batch-size", (Object)(totalSize - (long)metadata.getSerializedSize()));
        }
        if (metadata.hasNullValue()) {
            responseBuilder.header("X-Pulsar-null-value", (Object)metadata.isNullValue());
        }
        if (metadata.hasNumChunksFromMsg()) {
            responseBuilder.header("X-Pulsar-PROPERTY-TOTAL-CHUNKS", (Object)Integer.toString(metadata.getNumChunksFromMsg()));
            responseBuilder.header("X-Pulsar-PROPERTY-CHUNK-ID", (Object)Integer.toString(metadata.getChunkId()));
        }
        responseBuilder.header("X-Pulsar-Is-Encrypted", (Object)(metadata.getEncryptionKeysCount() > 0 ? 1 : 0));
        if (metadata.hasProducerName()) {
            responseBuilder.header("X-Pulsar-producer-name", (Object)metadata.getProducerName());
        }
        if (metadata.hasSequenceId()) {
            responseBuilder.header("X-Pulsar-sequence-id", (Object)metadata.getSequenceId());
        }
        if (metadata.hasReplicatedFrom()) {
            responseBuilder.header("X-Pulsar-replicated-from", (Object)metadata.getReplicatedFrom());
        }
        for (String replicatedTo : metadata.getReplicateTosList()) {
            responseBuilder.header("X-Pulsar-replicated-to", (Object)replicatedTo);
        }
        if (metadata.hasPartitionKey()) {
            responseBuilder.header("X-Pulsar-partition-key", (Object)metadata.getPartitionKey());
        }
        if (metadata.hasCompression()) {
            responseBuilder.header("X-Pulsar-compression", (Object)metadata.getCompression());
        }
        if (metadata.hasUncompressedSize()) {
            responseBuilder.header("X-Pulsar-uncompressed-size", (Object)metadata.getUncompressedSize());
        }
        if (metadata.hasEncryptionAlgo()) {
            responseBuilder.header("X-Pulsar-encryption-algo", (Object)metadata.getEncryptionAlgo());
        }
        for (EncryptionKeys encryptionKeys : metadata.getEncryptionKeysList()) {
            responseBuilder.header("X-Pulsar-Base64-encryption-keys", (Object)Base64.getEncoder().encodeToString(encryptionKeys.toByteArray()));
        }
        if (metadata.hasEncryptionParam()) {
            responseBuilder.header("X-Pulsar-Base64-encryption-param", (Object)Base64.getEncoder().encodeToString(metadata.getEncryptionParam()));
        }
        if (metadata.hasSchemaVersion()) {
            responseBuilder.header("X-Pulsar-Base64-schema-version", (Object)Base64.getEncoder().encodeToString(metadata.getSchemaVersion()));
        }
        if (metadata.hasPartitionKeyB64Encoded()) {
            responseBuilder.header("X-Pulsar-partition-key-b64-encoded", (Object)metadata.isPartitionKeyB64Encoded());
        }
        if (metadata.hasOrderingKey()) {
            responseBuilder.header("X-Pulsar-Base64-ordering-key", (Object)Base64.getEncoder().encodeToString(metadata.getOrderingKey()));
        }
        if (metadata.hasMarkerType()) {
            responseBuilder.header("X-Pulsar-marker-type", (Object)metadata.getMarkerType());
        }
        if (metadata.hasTxnidLeastBits()) {
            responseBuilder.header("X-Pulsar-txnid-least-bits", (Object)metadata.getTxnidLeastBits());
        }
        if (metadata.hasTxnidMostBits()) {
            responseBuilder.header("X-Pulsar-txnid-most-bits", (Object)metadata.getTxnidMostBits());
        }
        if (metadata.hasHighestSequenceId()) {
            responseBuilder.header("X-Pulsar-highest-sequence-id", (Object)metadata.getHighestSequenceId());
        }
        if (metadata.hasUuid()) {
            responseBuilder.header("X-Pulsar-uuid", (Object)metadata.getUuid());
        }
        if (metadata.hasNumChunksFromMsg()) {
            responseBuilder.header("X-Pulsar-num-chunks-from-msg", (Object)metadata.getNumChunksFromMsg());
        }
        if (metadata.hasTotalChunkMsgSize()) {
            responseBuilder.header("X-Pulsar-total-chunk-msg-size", (Object)metadata.getTotalChunkMsgSize());
        }
        if (metadata.hasChunkId()) {
            responseBuilder.header("X-Pulsar-chunk-id", (Object)metadata.getChunkId());
        }
        if (metadata.hasNullPartitionKey()) {
            responseBuilder.header("X-Pulsar-null-partition-key", (Object)metadata.isNullPartitionKey());
        }
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec((CompressionType)metadata.getCompression());
        ByteBuf uncompressedPayload = codec.decode(metadataAndPayload, metadata.getUncompressedSize());
        ByteBuf data = PulsarByteBufAllocator.DEFAULT.heapBuffer(uncompressedPayload.readableBytes(), uncompressedPayload.readableBytes());
        data.writeBytes(uncompressedPayload);
        uncompressedPayload.release();
        StreamingOutput stream = output -> {
            output.write(data.array(), data.arrayOffset(), data.readableBytes());
            data.release();
        };
        return responseBuilder.entity((Object)stream).build();
    }

    protected CompletableFuture<PersistentOfflineTopicStats> internalGetBacklogAsync(boolean authoritative) {
        CompletableFuture<Object> ret = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)ret.thenCompose(__ -> this.namespaceResources().getPoliciesAsync(this.namespaceName))).thenCompose(__ -> {
            long elapsedMs;
            PersistentOfflineTopicStats offlineTopicStats = this.pulsar().getBrokerService().getOfflineTopicStat(this.topicName);
            if (offlineTopicStats != null && TimeUnit.MINUTES.convert(elapsedMs = System.currentTimeMillis() - offlineTopicStats.statGeneratedAt.getTime(), TimeUnit.MILLISECONDS) < 10L) {
                return CompletableFuture.completedFuture(offlineTopicStats);
            }
            return this.pulsar().getBrokerService().getManagedLedgerConfig(this.topicName).thenCompose(config -> {
                ManagedLedgerOfflineBacklog offlineTopicBacklog = new ManagedLedgerOfflineBacklog(config.getDigestType(), config.getPassword(), this.pulsar().getAdvertisedAddress(), false);
                try {
                    PersistentOfflineTopicStats estimateOfflineTopicStats = offlineTopicBacklog.estimateUnloadedTopicBacklog((ManagedLedgerFactoryImpl)this.pulsar().getManagedLedgerFactory(), this.topicName);
                    this.pulsar().getBrokerService().cacheOfflineTopicStats(this.topicName, estimateOfflineTopicStats);
                    return CompletableFuture.completedFuture(estimateOfflineTopicStats);
                }
                catch (Exception e) {
                    throw new RestException(e);
                }
            });
        });
    }

    protected CompletableFuture<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>> internalGetBacklogQuota(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> {
            Map quotaMap = op.map(TopicPolicies::getBackLogQuotaMap).map(map -> {
                HashMap hashMap = new HashMap();
                map.forEach((key, value) -> hashMap.put(BacklogQuota.BacklogQuotaType.valueOf((String)key), value));
                return hashMap;
            }).orElse(new HashMap());
            if (applied && quotaMap.isEmpty() && (quotaMap = this.getNamespacePolicies((NamespaceName)this.namespaceName).backlog_quota_map).isEmpty()) {
                for (BacklogQuota.BacklogQuotaType backlogQuotaType : BacklogQuota.BacklogQuotaType.values()) {
                    quotaMap.put(backlogQuotaType, this.namespaceBacklogQuota(this.namespaceName, backlogQuotaType));
                }
            }
            return quotaMap;
        });
    }

    protected void internalGetBacklogSizeByMessageId(AsyncResponse asyncResponse, MessageIdImpl messageId, boolean authoritative) {
        CompletionStage<Object> ret = !this.topicName.isPartitioned() ? this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(topicMetadata -> {
            if (topicMetadata.partitions > 0) {
                log.warn("[{}] Not supported calculate backlog size operation on partitioned-topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "calculate backlog size is not allowed for partitioned-topic")));
            }
            return CompletableFuture.completedFuture(null);
        }) : CompletableFuture.completedFuture(null);
        CompletionStage<Object> future = this.topicName.isGlobal() ? ret.thenCompose(__ -> this.validateGlobalNamespaceOwnershipAsync(this.namespaceName)) : ret;
        ((CompletableFuture)future.thenAccept(__ -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(unused -> this.validateTopicOperationAsync(this.topicName, TopicOperation.GET_BACKLOG_SIZE))).thenCompose(unused -> this.getTopicReferenceAsync(this.topicName))).thenAccept(t -> {
            PersistentTopic topic = (PersistentTopic)t;
            PositionImpl pos = new PositionImpl(messageId.getLedgerId(), messageId.getEntryId());
            if (topic == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                return;
            }
            ManagedLedgerImpl managedLedger = (ManagedLedgerImpl)topic.getManagedLedger();
            if (messageId.getLedgerId() == -1L) {
                asyncResponse.resume((Object)managedLedger.getTotalSize());
            } else {
                asyncResponse.resume((Object)managedLedger.getEstimatedBacklogSize(pos));
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to get backlog size for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        }))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to validate global namespace ownership to get backlog size for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected CompletableFuture<Void> internalSetBacklogQuota(BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuotaImpl backlogQuota, boolean isGlobal) {
        BacklogQuota.BacklogQuotaType finalBacklogQuotaType = backlogQuotaType == null ? BacklogQuota.BacklogQuotaType.destination_storage : backlogQuotaType;
        return ((CompletableFuture)((CompletableFuture)this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.BACKLOG, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal))).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            return this.getRetentionPoliciesAsync(this.topicName, topicPolicies).thenCompose(retentionPolicies -> {
                if (!this.checkBacklogQuota((BacklogQuota)backlogQuota, (RetentionPolicies)retentionPolicies)) {
                    log.warn("[{}] Failed to update backlog configuration for topic {}: conflicts with retention quota", (Object)this.clientAppId(), (Object)this.topicName);
                    return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Backlog Quota exceeds configured retention quota for topic. Please increase retention quota and retry")));
                }
                if (backlogQuota != null) {
                    topicPolicies.getBackLogQuotaMap().put(finalBacklogQuotaType.name(), backlogQuota);
                } else {
                    topicPolicies.getBackLogQuotaMap().remove(finalBacklogQuotaType.name());
                }
                Map backLogQuotaMap = topicPolicies.getBackLogQuotaMap();
                topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
                return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies).thenRun(() -> {
                    try {
                        log.info("[{}] Successfully updated backlog quota map: namespace={}, topic={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), this.objectWriter().writeValueAsString((Object)backLogQuotaMap)});
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        // empty catch block
                    }
                });
            });
        });
    }

    protected CompletableFuture<Void> internalSetReplicationClusters(List<String> clusterIds) {
        return ((CompletableFuture)((CompletableFuture)this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.REPLICATION, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> {
            if (CollectionUtils.isEmpty((Collection)clusterIds)) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "ClusterIds should not be null or empty");
            }
            HashSet replicationClusters = Sets.newHashSet((Iterable)clusterIds);
            if (replicationClusters.contains("global")) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot specify global in the list of replication clusters");
            }
            Set<String> clusters = this.clusters();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(replicationClusters.size());
            for (String clusterId : replicationClusters) {
                if (!clusters.contains(clusterId)) {
                    throw new RestException(Response.Status.FORBIDDEN, "Invalid cluster id: " + clusterId);
                }
                futures.add(this.validatePeerClusterConflictAsync(clusterId, replicationClusters));
                futures.add(this.validateClusterForTenantAsync(this.namespaceName.getTenant(), clusterId));
            }
            return FutureUtil.waitForAll(futures);
        })).thenCompose(__ -> this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setReplicationClusters(clusterIds);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies).thenRun(() -> log.info("[{}] Successfully set replication clusters for namespace={}, topic={}, clusters={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), topicPolicies.getReplicationClusters()}));
        }));
    }

    protected CompletableFuture<Void> internalRemoveReplicationClusters() {
        return ((CompletableFuture)this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.REPLICATION, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setReplicationClusters(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies).thenRun(() -> log.info("[{}] Successfully set replication clusters for namespace={}, topic={}, clusters={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), topicPolicies.getReplicationClusters()}));
        }));
    }

    protected CompletableFuture<Boolean> internalGetDeduplication(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getDeduplicationEnabled).orElseGet(() -> {
            if (applied) {
                Boolean enabled = this.getNamespacePolicies((NamespaceName)this.namespaceName).deduplicationEnabled;
                return enabled == null ? this.config().isBrokerDeduplicationEnabled() : enabled.booleanValue();
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetDeduplication(Boolean enabled, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setDeduplicationEnabled(enabled);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalSetMessageTTL(Integer ttlInSecond, boolean isGlobal) {
        if (ttlInSecond != null && ttlInSecond < 0) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL")));
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMessageTTLInSeconds(ttlInSecond);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies).thenRun(() -> log.info("[{}] Successfully set topic message ttl: namespace={}, topic={}, ttl={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), ttlInSecond}));
        });
    }

    private CompletableFuture<RetentionPolicies> getRetentionPoliciesAsync(TopicName topicName, TopicPolicies topicPolicies) {
        RetentionPolicies retentionPolicies = topicPolicies.getRetentionPolicies();
        if (retentionPolicies != null) {
            return CompletableFuture.completedFuture(retentionPolicies);
        }
        return this.getNamespacePoliciesAsync(topicName.getNamespaceObject()).thenApply(policies -> policies.retention_policies);
    }

    protected CompletableFuture<RetentionPolicies> internalGetRetention(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getRetentionPolicies).orElseGet(() -> {
            if (applied) {
                RetentionPolicies policies = this.getNamespacePolicies((NamespaceName)this.namespaceName).retention_policies;
                return policies == null ? new RetentionPolicies(this.config().getDefaultRetentionTimeInMinutes(), (long)this.config().getDefaultRetentionSizeInMB()) : policies;
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetRetention(RetentionPolicies retention, boolean isGlobal) {
        if (retention == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            for (BacklogQuota.BacklogQuotaType backlogQuotaType : BacklogQuota.BacklogQuotaType.values()) {
                BacklogQuota backlogQuota = (BacklogQuota)topicPolicies.getBackLogQuotaMap().get(backlogQuotaType.name());
                if (backlogQuota == null) {
                    Policies policies = this.getNamespacePolicies(this.topicName.getNamespaceObject());
                    backlogQuota = (BacklogQuota)policies.backlog_quota_map.get(backlogQuotaType);
                }
                if (this.checkBacklogQuota(backlogQuota, retention)) continue;
                log.warn("[{}] Failed to update retention quota configuration for topic {}: conflicts with retention quota", (Object)this.clientAppId(), (Object)this.topicName);
                return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Retention Quota must exceed configured backlog quota for topic. Please increase retention quota and retry")));
            }
            topicPolicies.setRetentionPolicies(retention);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveRetention(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setRetentionPolicies(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<PersistencePolicies> internalGetPersistence(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getPersistence).orElseGet(() -> {
            if (applied) {
                PersistencePolicies namespacePolicy = this.getNamespacePolicies((NamespaceName)this.namespaceName).persistence;
                return namespacePolicy == null ? new PersistencePolicies(this.pulsar().getConfiguration().getManagedLedgerDefaultEnsembleSize(), this.pulsar().getConfiguration().getManagedLedgerDefaultWriteQuorum(), this.pulsar().getConfiguration().getManagedLedgerDefaultAckQuorum(), this.pulsar().getConfiguration().getManagedLedgerDefaultMarkDeleteRateLimit()) : namespacePolicy;
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetPersistence(PersistencePolicies persistencePolicies, boolean isGlobal) {
        this.validatePersistencePolicies(persistencePolicies);
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setPersistence(persistencePolicies);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemovePersistence(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setPersistence(null);
            ((TopicPolicies)op.get()).setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Void> internalSetMaxMessageSize(Integer maxMessageSize, boolean isGlobal) {
        if (maxMessageSize != null && (maxMessageSize < 0 || maxMessageSize > this.config().getMaxMessageSize())) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "topic-level maxMessageSize must be greater than or equal to 0 and must be smaller than that in the broker-level");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxMessageSize(maxMessageSize);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Optional<Integer>> internalGetMaxMessageSize(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getMaxMessageSize));
    }

    protected CompletableFuture<Integer> internalGetMaxProducers(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getMaxProducerPerTopic).orElseGet(() -> {
            if (applied) {
                Integer maxProducer = this.getNamespacePolicies((NamespaceName)this.namespaceName).max_producers_per_topic;
                return maxProducer == null ? this.config().getMaxProducersPerTopic() : maxProducer.intValue();
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetMaxProducers(Integer maxProducers, boolean isGlobal) {
        if (maxProducers != null && maxProducers < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxProducers must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxProducerPerTopic(maxProducers);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Optional<Integer>> internalGetMaxSubscriptionsPerTopic(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getMaxSubscriptionsPerTopic));
    }

    protected CompletableFuture<Void> internalSetMaxSubscriptionsPerTopic(Integer maxSubscriptionsPerTopic, boolean isGlobal) {
        if (maxSubscriptionsPerTopic != null && maxSubscriptionsPerTopic < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxSubscriptionsPerTopic must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxSubscriptionsPerTopic(maxSubscriptionsPerTopic);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<DispatchRateImpl> internalGetReplicatorDispatchRate(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getReplicatorDispatchRate).orElseGet(() -> {
            if (applied) {
                DispatchRateImpl namespacePolicy = (DispatchRateImpl)this.getNamespacePolicies((NamespaceName)this.namespaceName).replicatorDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
                return namespacePolicy == null ? this.replicatorDispatchRate() : namespacePolicy;
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetReplicatorDispatchRate(DispatchRateImpl dispatchRate, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setReplicatorDispatchRate(dispatchRate);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> preValidation(boolean authoritative) {
        if (!this.config().isTopicLevelPoliciesEnabled()) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Topic level policies is disabled, to enable the topic level policy and retry.")));
        }
        if (this.topicName.isPartitioned()) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Not allowed to set/get topic policy for a partition")));
        }
        CompletableFuture<Object> ret = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)ret.thenCompose(__ -> this.checkTopicExistsAsync(this.topicName))).thenCompose(exist -> {
            if (!exist.booleanValue()) {
                throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()));
            }
            return this.getPartitionedTopicMetadataAsync(this.topicName, false, false).thenCompose(metadata -> {
                if (metadata.partitions > 0) {
                    return this.validateTopicOwnershipAsync(TopicName.get((String)(this.topicName.toString() + "-partition-0")), authoritative);
                }
                return this.validateTopicOwnershipAsync(this.topicName, authoritative);
            });
        });
    }

    protected CompletableFuture<Void> internalRemoveMaxProducers(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setMaxProducerPerTopic(null);
            ((TopicPolicies)op.get()).setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Integer> internalGetMaxConsumers(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getMaxConsumerPerTopic).orElseGet(() -> {
            if (applied) {
                Integer maxConsumer = this.getNamespacePolicies((NamespaceName)this.namespaceName).max_consumers_per_topic;
                return maxConsumer == null ? this.config().getMaxConsumersPerTopic() : maxConsumer.intValue();
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetMaxConsumers(Integer maxConsumers, boolean isGlobal) {
        if (maxConsumers != null && maxConsumers < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumers must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxConsumerPerTopic(maxConsumers);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveMaxConsumers(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setMaxConsumerPerTopic(null);
            ((TopicPolicies)op.get()).setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<MessageId> internalTerminateAsync(boolean authoritative) {
        if (SystemTopicNames.isSystemTopic((TopicName)this.topicName)) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Termination of a system topic is not allowed")));
        }
        CompletableFuture<Object> ret = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)ret.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.TERMINATE))).thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false))).thenAccept(partitionMetadata -> {
            if (partitionMetadata.partitions > 0) {
                throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Termination of a partitioned topic is not allowed");
            }
        })).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(topic -> {
            if (!(topic instanceof PersistentTopic)) {
                throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Termination of a non-persistent topic is not allowed");
            }
            return ((PersistentTopic)topic).terminate();
        });
    }

    protected void internalTerminatePartitionedTopic(AsyncResponse asyncResponse, boolean authoritative) {
        if (this.topicName.isPartitioned()) {
            String msg = "Termination of a non-partitioned topic is not allowed using partitioned-terminate, please use terminate commands";
            log.error("[{}] [{}] {}", new Object[]{this.clientAppId(), this.topicName, msg});
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, msg)));
            return;
        }
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)future.thenCompose(__ -> ((CompletableFuture)((CompletableFuture)this.validateTopicOperationAsync(this.topicName, TopicOperation.TERMINATE).thenCompose(unused -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false))).thenAccept(partitionMetadata -> {
            if (partitionMetadata.partitions == 0) {
                String msg = "Termination of a non-partitioned topic is not allowed using partitioned-terminate, please use terminate commands";
                log.error("[{}] [{}] {}", new Object[]{this.clientAppId(), this.topicName, msg});
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, msg)));
                return;
            }
            if (partitionMetadata.partitions > 0) {
                ConcurrentHashMap messageIds = new ConcurrentHashMap(partitionMetadata.partitions);
                ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(partitionMetadata.partitions);
                int i = 0;
                while (i < partitionMetadata.partitions) {
                    TopicName topicNamePartition = this.topicName.getPartition(i);
                    try {
                        int finalI = i++;
                        futures.add(this.pulsar().getAdminClient().topics().terminateTopicAsync(topicNamePartition.toString()).whenComplete((messageId, throwable) -> {
                            if (throwable != null) {
                                log.error("[{}] Failed to terminate topic {}", new Object[]{this.clientAppId(), topicNamePartition, throwable});
                                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)throwable)));
                            }
                            messageIds.put(finalI, messageId);
                        }));
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to terminate topic {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                        throw new RestException(e);
                    }
                }
                FutureUtil.waitForAll(futures).handle((result, exception) -> {
                    if (exception != null) {
                        Throwable t = exception.getCause();
                        if (t instanceof PulsarAdminException.NotFoundException) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                        } else {
                            log.error("[{}] Failed to terminate topic {}", new Object[]{this.clientAppId(), this.topicName, t});
                            asyncResponse.resume((Throwable)((Object)new RestException(t)));
                        }
                    }
                    asyncResponse.resume((Object)messageIds);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to terminate topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        }))).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to terminate topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalExpireMessagesByTimestamp(AsyncResponse asyncResponse, String subName, int expireTimeInSeconds, boolean authoritative) {
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)future.thenCompose(__ -> ((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(unused -> this.validateTopicOperationAsync(this.topicName, TopicOperation.EXPIRE_MESSAGES, subName))).thenCompose(unused2 -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(partitionMetadata -> {
            if (this.topicName.isPartitioned()) {
                return this.internalExpireMessagesByTimestampForSinglePartitionAsync((PartitionedTopicMetadata)partitionMetadata, subName, expireTimeInSeconds).thenAccept(unused3 -> asyncResponse.resume((Object)Response.noContent().build()));
            }
            if (partitionMetadata.partitions > 0) {
                return CompletableFuture.completedFuture(null).thenAccept(unused -> {
                    ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            futures.add(this.pulsar().getAdminClient().topics().expireMessagesAsync(topicNamePartition.toString(), subName, (long)expireTimeInSeconds));
                            continue;
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to expire messages up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, topicNamePartition, e});
                            asyncResponse.resume((Throwable)((Object)new RestException(e)));
                            return;
                        }
                    }
                    FutureUtil.waitForAll(futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable t = FutureUtil.unwrapCompletionException((Throwable)exception);
                            if (t instanceof PulsarAdminException.NotFoundException) {
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                                return null;
                            }
                            if (t instanceof PulsarAdminException) {
                                log.warn("[{}] Failed to expire messages up to {} on {}: {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, t.toString()});
                            } else {
                                log.error("[{}] Failed to expire messages up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, t});
                            }
                            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, t);
                            return null;
                        }
                        asyncResponse.resume((Object)Response.noContent().build());
                        return null;
                    });
                });
            }
            return this.internalExpireMessagesByTimestampForSinglePartitionAsync((PartitionedTopicMetadata)partitionMetadata, subName, expireTimeInSeconds).thenAccept(unused -> asyncResponse.resume((Object)Response.noContent().build()));
        })))).exceptionally(ex -> {
            Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (!PersistentTopicsBase.isRedirectException(cause)) {
                if (cause instanceof RestException) {
                    log.warn("[{}] Failed to expire messages up to {} on {}: {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, cause.toString()});
                } else {
                    log.error("[{}] Failed to expire messages up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, cause});
                }
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, cause);
            return null;
        });
    }

    private CompletableFuture<Void> internalExpireMessagesByTimestampForSinglePartitionAsync(PartitionedTopicMetadata partitionMetadata, String subName, int expireTimeInSeconds) {
        if (!this.topicName.isPartitioned() && partitionMetadata.partitions > 0) {
            String msg = "This method should not be called for partitioned topic";
            return FutureUtil.failedFuture((Throwable)new IllegalStateException(msg));
        }
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        ((CompletableFuture)this.getTopicReferenceAsync(this.topicName).thenAccept(t -> {
            MessageExpirer messageExpirer;
            if (t == null) {
                resultFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                return;
            }
            if (!(t instanceof PersistentTopic)) {
                resultFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Expire messages on a non-persistent topic is not allowed")));
                return;
            }
            PersistentTopic topic = (PersistentTopic)t;
            if (subName.startsWith(topic.getReplicatorPrefix())) {
                String remoteCluster = PersistentReplicator.getRemoteCluster(subName);
                messageExpirer = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
            } else {
                messageExpirer = topic.getSubscription(subName);
            }
            if (messageExpirer == null) {
                String message = subName.startsWith(topic.getReplicatorPrefix()) ? "Replicator not found" : PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName);
                resultFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, message)));
                return;
            }
            if (!messageExpirer.expireMessages(expireTimeInSeconds)) {
                if (log.isDebugEnabled()) {
                    log.debug("Expire message by timestamp not issued on topic {} for subscription {} due to ongoing message expiration not finished or subscription almost catch up. If it's performed on a partitioned topic operation might succeeded on other partitions, please check stats of individual partition.", (Object)this.topicName, (Object)subName);
                }
                resultFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Expire message by timestamp not issued on topic " + this.topicName + " for subscription " + subName + " due to ongoing message expiration not finished or subscription almost catch  up. If it's performed on a partitioned topic operation might succeeded on other partitions, please check stats of individual partition.")));
                return;
            }
            log.info("[{}] Message expire started up to {} on {} {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, subName});
            resultFuture.complete(null);
        })).exceptionally(e -> {
            resultFuture.completeExceptionally(FutureUtil.unwrapCompletionException((Throwable)e));
            return null;
        });
        return resultFuture;
    }

    protected void internalExpireMessagesByPosition(AsyncResponse asyncResponse, String subName, boolean authoritative, MessageIdImpl messageId, boolean isExcluded, int batchIndex) {
        if (messageId.getPartitionIndex() != this.topicName.getPartitionIndex()) {
            String msg = "Invalid parameter for expire message by position, partition index of passed in message position doesn't match partition index for the topic";
            log.warn("[{}] {} {}({}).", new Object[]{this.clientAppId(), msg, this.topicName, messageId});
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, msg)));
            return;
        }
        CompletionStage<Object> ret = !this.topicName.isPartitioned() ? this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(topicMetadata -> {
            if (topicMetadata.partitions > 0) {
                String msg = "Expire message at position is not supported for partitioned-topic";
                log.warn("[{}] {} {}({}) {}", new Object[]{this.clientAppId(), msg, this.topicName, messageId, subName});
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, msg)));
            }
            return CompletableFuture.completedFuture(null);
        }) : CompletableFuture.completedFuture(null);
        CompletionStage<Object> future = this.topicName.isGlobal() ? ret.thenCompose(__ -> this.validateGlobalNamespaceOwnershipAsync(this.namespaceName)) : ret;
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.EXPIRE_MESSAGES, subName))).thenCompose(__ -> {
            log.info("[{}][{}] Received expire messages on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId});
            return this.internalExpireMessagesNonPartitionedTopicByPosition(asyncResponse, subName, messageId, isExcluded, batchIndex);
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to expire messages up to {} on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Void> internalExpireMessagesNonPartitionedTopicByPosition(AsyncResponse asyncResponse, String subName, MessageIdImpl messageId, boolean isExcluded, int batchIndex) {
        return ((CompletableFuture)this.getTopicReferenceAsync(this.topicName).thenAccept(t -> {
            PersistentTopic topic = (PersistentTopic)t;
            if (topic == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                return;
            }
            try {
                MessageExpirer messageExpirer;
                if (subName.startsWith(topic.getReplicatorPrefix())) {
                    String remoteCluster = PersistentReplicator.getRemoteCluster(subName);
                    messageExpirer = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
                } else {
                    messageExpirer = topic.getSubscription(subName);
                }
                if (messageExpirer == null) {
                    String message = subName.startsWith(topic.getReplicatorPrefix()) ? "Replicator not found" : PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName);
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, message)));
                    return;
                }
                CompletableFuture<Integer> batchSizeFuture = new CompletableFuture<Integer>();
                this.getEntryBatchSize(batchSizeFuture, topic, messageId, batchIndex);
                ((CompletableFuture)batchSizeFuture.thenAccept(bi -> {
                    PositionImpl position = this.calculatePositionAckSet(isExcluded, (int)bi, batchIndex, messageId);
                    try {
                        if (!messageExpirer.expireMessages((Position)position)) {
                            if (log.isDebugEnabled()) {
                                log.debug("Expire message by position not issued on topic {} for subscription {} due to ongoing message expiration not finished or subscription almost catch up.", (Object)this.topicName, (Object)subName);
                            }
                            throw new RestException(Response.Status.CONFLICT, "Expire message by position not issued on topic " + this.topicName + " for subscription " + subName + " due to ongoing message expiration not finished or invalid message position provided.");
                        }
                        log.info("[{}] Message expire started up to {} on {} {}", new Object[]{this.clientAppId(), position, this.topicName, subName});
                    }
                    catch (RestException exception) {
                        throw exception;
                    }
                    catch (Exception exception) {
                        throw new RestException(exception);
                    }
                    asyncResponse.resume((Object)Response.noContent().build());
                })).exceptionally(e -> {
                    Throwable throwable = FutureUtil.unwrapCompletionException((Throwable)e);
                    if (throwable instanceof RestException) {
                        log.warn("[{}] Failed to expire messages up to {} on {} with subscription {}: {}", new Object[]{this.clientAppId(), messageId, this.topicName, subName, throwable.toString()});
                    } else {
                        log.error("[{}] Failed to expire messages up to {} on {} with subscription {}", new Object[]{this.clientAppId(), messageId, this.topicName, subName, throwable});
                    }
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, throwable);
                    return null;
                });
            }
            catch (Exception e2) {
                log.warn("[{}][{}] Failed to expire messages up to {} on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, messageId, subName, messageId, e2});
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, e2);
            }
        })).exceptionally(ex -> {
            Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (cause instanceof RestException) {
                log.warn("[{}] Failed to expire messages up to {} on subscription {} to position {}: {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, cause.toString()});
            } else {
                log.error("[{}] Failed to expire messages up to {} on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, cause});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, cause);
            return null;
        });
    }

    protected void internalTriggerCompaction(AsyncResponse asyncResponse, boolean authoritative) {
        log.info("[{}] Trigger compaction on topic {}", (Object)this.clientAppId(), (Object)this.topicName);
        CompletableFuture<Object> future = this.topicName.isGlobal() ? this.validateGlobalNamespaceOwnershipAsync(this.namespaceName) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)future.thenAccept(__ -> {
            if (this.topicName.isPartitioned()) {
                this.internalTriggerCompactionNonPartitionedTopic(asyncResponse, authoritative);
            } else {
                ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                    int numPartitions = partitionMetadata.partitions;
                    if (numPartitions > 0) {
                        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(numPartitions);
                        for (int i = 0; i < numPartitions; ++i) {
                            TopicName topicNamePartition = this.topicName.getPartition(i);
                            try {
                                futures.add(this.pulsar().getAdminClient().topics().triggerCompactionAsync(topicNamePartition.toString()));
                                continue;
                            }
                            catch (Exception e) {
                                log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                                asyncResponse.resume((Throwable)((Object)new RestException(e)));
                                return;
                            }
                        }
                        FutureUtil.waitForAll(futures).handle((result, exception) -> {
                            if (exception != null) {
                                Throwable th = exception.getCause();
                                if (th instanceof PulsarAdminException.NotFoundException) {
                                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, th.getMessage())));
                                    return null;
                                }
                                if (th instanceof WebApplicationException) {
                                    asyncResponse.resume(th);
                                    return null;
                                }
                                log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, exception});
                                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)exception)));
                                return null;
                            }
                            asyncResponse.resume((Object)Response.noContent().build());
                            return null;
                        });
                    } else {
                        this.internalTriggerCompactionNonPartitionedTopic(asyncResponse, authoritative);
                    }
                })).exceptionally(ex -> {
                    if (!PersistentTopicsBase.isRedirectException(ex)) {
                        log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                    }
                    PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to validate global namespace ownership to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalTriggerCompactionNonPartitionedTopic(AsyncResponse asyncResponse, boolean authoritative) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.COMPACT))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenAccept(topic -> {
            try {
                ((PersistentTopic)topic).triggerCompaction();
                asyncResponse.resume((Object)Response.noContent().build());
            }
            catch (BrokerServiceException.AlreadyRunningException e) {
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)((Object)new RestException(Response.Status.CONFLICT, e.getMessage())));
                return;
            }
            catch (Exception e) {
                log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)((Object)new RestException(e)));
                return;
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to trigger compaction for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected CompletableFuture<LongRunningProcessStatus> internalCompactionStatusAsync(boolean authoritative) {
        return ((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.COMPACT))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenApply(topic -> ((PersistentTopic)topic).compactionStatus());
    }

    protected void internalTriggerOffload(AsyncResponse asyncResponse, boolean authoritative, MessageIdImpl messageId) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.OFFLOAD))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenAccept(topic -> {
            try {
                ((PersistentTopic)topic).triggerOffload(messageId);
                asyncResponse.resume((Object)Response.noContent().build());
            }
            catch (BrokerServiceException.AlreadyRunningException e) {
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)((Object)new RestException(Response.Status.CONFLICT, e.getMessage())));
                return;
            }
            catch (Exception e) {
                log.warn("Unexpected error triggering offload", (Throwable)e);
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)((Object)new RestException(e)));
                return;
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to trigger offload for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalOffloadStatus(AsyncResponse asyncResponse, boolean authoritative) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.OFFLOAD))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenAccept(topic -> {
            OffloadProcessStatus offloadProcessStatus = ((PersistentTopic)topic).offloadStatus();
            asyncResponse.resume((Object)offloadProcessStatus);
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to offload status on topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadata(PulsarService pulsar, String clientAppId, String originalPrincipal, AuthenticationDataSource authenticationData, TopicName topicName) {
        CompletableFuture<PartitionedTopicMetadata> metadataFuture = new CompletableFuture<PartitionedTopicMetadata>();
        CompletableFuture authorizationFuture = new CompletableFuture();
        ((CompletableFuture)PersistentTopicsBase.checkAuthorizationAsync(pulsar, topicName, clientAppId, authenticationData).thenRun(() -> authorizationFuture.complete(null))).exceptionally(e -> {
            Throwable throwable = FutureUtil.unwrapCompletionException((Throwable)e);
            if (throwable instanceof RestException) {
                ((CompletableFuture)this.validateAdminAccessForTenantAsync(pulsar, clientAppId, originalPrincipal, topicName.getTenant(), authenticationData).thenRun(() -> authorizationFuture.complete(null))).exceptionally(ex -> {
                    Throwable throwable2 = FutureUtil.unwrapCompletionException((Throwable)ex);
                    if (throwable2 instanceof RestException) {
                        log.warn("Failed to authorize {} on topic {}", (Object)clientAppId, (Object)topicName);
                        authorizationFuture.completeExceptionally((Throwable)new PulsarClientException(String.format("Authorization failed %s on topic %s with error %s", clientAppId, topicName, throwable2.getMessage())));
                    } else {
                        authorizationFuture.completeExceptionally(throwable2);
                    }
                    return null;
                });
            } else {
                log.warn("Failed to authorize {} on topic {}", new Object[]{clientAppId, topicName, throwable});
                authorizationFuture.completeExceptionally(throwable);
            }
            return null;
        });
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)authorizationFuture.thenCompose(__ -> PersistentTopicsBase.checkLocalOrGetPeerReplicationCluster(pulsar, topicName.getNamespaceObject(), SystemTopicNames.isSystemTopic((TopicName)topicName)))).thenCompose(res -> pulsar.getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName))).thenAccept(metadata -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Total number of partitions for topic {} is {}", new Object[]{clientAppId, topicName, metadata.partitions});
            }
            metadataFuture.complete((PartitionedTopicMetadata)metadata);
        })).exceptionally(e -> {
            metadataFuture.completeExceptionally(FutureUtil.unwrapCompletionException((Throwable)e));
            return null;
        });
        return metadataFuture;
    }

    public static CompletableFuture<PartitionedTopicMetadata> unsafeGetPartitionedTopicMetadataAsync(PulsarService pulsar, TopicName topicName) {
        CompletableFuture<PartitionedTopicMetadata> metadataFuture = new CompletableFuture<PartitionedTopicMetadata>();
        ((CompletableFuture)((CompletableFuture)PersistentTopicsBase.checkLocalOrGetPeerReplicationCluster(pulsar, topicName.getNamespaceObject(), SystemTopicNames.isSystemTopic((TopicName)topicName)).thenCompose(res -> pulsar.getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName))).thenAccept(metadata -> {
            if (log.isDebugEnabled()) {
                log.debug("Total number of partitions for topic {} is {}", (Object)topicName, (Object)metadata.partitions);
            }
            metadataFuture.complete((PartitionedTopicMetadata)metadata);
        })).exceptionally(ex -> {
            metadataFuture.completeExceptionally(ex.getCause());
            return null;
        });
        return metadataFuture;
    }

    private CompletableFuture<Topic> getTopicReferenceAsync(TopicName topicName) {
        return this.pulsar().getBrokerService().getTopicIfExists(topicName.toString()).thenCompose(optTopic -> optTopic.map(CompletableFuture::completedFuture).orElseGet(() -> this.topicNotFoundReasonAsync(topicName)));
    }

    private CompletableFuture<Topic> topicNotFoundReasonAsync(TopicName topicName) {
        if (!topicName.isPartitioned()) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(topicName.toString()))));
        }
        return ((CompletableFuture)((CompletableFuture)this.getPartitionedTopicMetadataAsync(TopicName.get((String)topicName.getPartitionedTopicName()), false, false).thenAccept(partitionedTopicMetadata -> {
            if (partitionedTopicMetadata == null || partitionedTopicMetadata.partitions == 0) {
                String topicErrorType = partitionedTopicMetadata == null ? "has no metadata" : "has zero partitions";
                throw new RestException(Response.Status.NOT_FOUND, String.format("Partitioned Topic not found: %s %s", topicName.toString(), topicErrorType));
            }
        })).thenCompose(__ -> this.internalGetListAsync(Optional.empty()))).thenApply(topics -> {
            if (!topics.contains(topicName.toString())) {
                throw new RestException(Response.Status.NOT_FOUND, "Topic partitions were not yet created");
            }
            throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getPartitionedTopicNotFoundErrorMessage(topicName.toString()));
        });
    }

    private Subscription getSubscriptionReference(String subName, PersistentTopic topic) {
        try {
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                sub = topic.createSubscription(subName, CommandSubscribe.InitialPosition.Earliest, false, null).get();
            }
            return PersistentTopicsBase.checkNotNull(sub);
        }
        catch (Exception e) {
            throw new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName));
        }
    }

    private PersistentReplicator getReplicatorReference(String replName, PersistentTopic topic) {
        try {
            String remoteCluster = PersistentReplicator.getRemoteCluster(replName);
            PersistentReplicator repl = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
            return PersistentTopicsBase.checkNotNull(repl);
        }
        catch (Exception e) {
            throw new RestException(Response.Status.NOT_FOUND, "Replicator not found");
        }
    }

    protected CompletableFuture<Void> internalValidateClientVersionAsync() {
        if (!this.pulsar().getConfiguration().isClientLibraryVersionCheckEnabled()) {
            return CompletableFuture.completedFuture(null);
        }
        String userAgent = this.httpRequest.getHeader("User-Agent");
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Client lib is not compatible to access partitioned metadata: version in user-agent is not present")));
        }
        if (userAgent.contains(DEPRECATED_CLIENT_VERSION_PREFIX)) {
            try {
                String[] splits;
                String[] tokens = userAgent.split(DEPRECATED_CLIENT_VERSION_PREFIX);
                String[] stringArray = splits = tokens.length > 1 ? tokens[1].split("-")[0].trim().split("\\.") : null;
                if (splits != null && splits.length > 1 && (LEAST_SUPPORTED_CLIENT_VERSION_PREFIX.getMajorVersion() > Integer.parseInt(splits[0]) || LEAST_SUPPORTED_CLIENT_VERSION_PREFIX.getMinorVersion() > Integer.parseInt(splits[1]))) {
                    return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Client lib is not compatible to access partitioned metadata: version " + userAgent + " is not supported")));
                }
            }
            catch (Exception e) {
                log.warn("[{}] Failed to parse version {} ", (Object)this.clientAppId(), (Object)userAgent);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> validateNonPartitionTopicNameAsync(String topicName) {
        CompletionStage<Object> ret = CompletableFuture.completedFuture(null);
        if (topicName.contains("-partition-")) {
            try {
                int partitionIndex = topicName.indexOf("-partition-");
                long suffix = Long.parseLong(topicName.substring(partitionIndex + "-partition-".length()));
                TopicName partitionTopicName = TopicName.get((String)this.domain(), (NamespaceName)this.namespaceName, (String)topicName.substring(0, partitionIndex));
                ret = this.getPartitionedTopicMetadataAsync(partitionTopicName, false, false).thenAccept(metadata -> {
                    if (metadata.partitions > 0 && suffix >= (long)metadata.partitions) {
                        log.warn("[{}] Can't create topic {} with \"-partition-\" followed by a number smaller then number of partition of partitioned topic {}.", new Object[]{this.clientAppId(), topicName, partitionTopicName.getLocalName()});
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "Can't create topic " + topicName + " with \"-partition-\" followed by a number smaller then number of partition of partitioned topic " + partitionTopicName.getLocalName());
                    }
                    if (metadata.partitions == 0) {
                        log.warn("[{}] Can't create topic {} with \"-partition-\" followed by numeric value if there isn't a partitioned topic {} created.", new Object[]{this.clientAppId(), topicName, partitionTopicName.getLocalName()});
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "Can't create topic " + topicName + " with \"-partition-\" followed by numeric value if there isn't a partitioned topic " + partitionTopicName.getLocalName() + " created.");
                    }
                });
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    protected void internalGetLastMessageId(AsyncResponse asyncResponse, boolean authoritative) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, TopicOperation.PEEK_MESSAGES))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenAccept(topic -> {
            if (topic == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                return;
            }
            if (!(topic instanceof PersistentTopic)) {
                log.error("[{}] Not supported operation of non-persistent topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "GetLastMessageId on a non-persistent topic is not allowed")));
                return;
            }
            topic.getLastMessageId().whenComplete((v, e) -> {
                if (e != null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())));
                } else {
                    asyncResponse.resume(v);
                }
            });
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to get last messageId {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected CompletableFuture<Void> internalTrimTopic(AsyncResponse asyncResponse, boolean authoritative) {
        if (!this.topicName.isPersistent()) {
            log.info("[{}] Trim on a non-persistent topic {} is not allowed", (Object)this.clientAppId(), (Object)this.topicName);
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Trim on a non-persistent topic is not allowed")));
            return null;
        }
        if (this.topicName.isPartitioned()) {
            return this.validateTopicOperationAsync(this.topicName, TopicOperation.TRIM_TOPIC).thenCompose(x -> this.trimNonPartitionedTopic(asyncResponse, this.topicName, authoritative));
        }
        return ((CompletableFuture)this.validateTopicOperationAsync(this.topicName, TopicOperation.TRIM_TOPIC).thenCompose(__ -> this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName))).thenCompose(metadata -> {
            if (metadata.partitions > 0) {
                return this.trimPartitionedTopic(asyncResponse, (PartitionedTopicMetadata)metadata);
            }
            return this.trimNonPartitionedTopic(asyncResponse, this.topicName, authoritative);
        });
    }

    private CompletableFuture<Void> trimNonPartitionedTopic(AsyncResponse asyncResponse, TopicName topicName, boolean authoritative) {
        return ((CompletableFuture)this.validateTopicOwnershipAsync(topicName, authoritative).thenCompose(__ -> this.getTopicReferenceAsync(topicName))).thenCompose(topic -> {
            if (!(topic instanceof PersistentTopic)) {
                log.info("[{}] Trim on a non-persistent topic {} is not allowed", (Object)this.clientAppId(), (Object)topicName);
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Trim on a non-persistent topic is not allowed")));
                return CompletableFuture.completedFuture(null);
            }
            PersistentTopic persistentTopic = (PersistentTopic)topic;
            ManagedLedger managedLedger = persistentTopic.getManagedLedger();
            if (managedLedger == null) {
                asyncResponse.resume(null);
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture result = new CompletableFuture();
            managedLedger.trimConsumedLedgersInBackground(result);
            return result.whenComplete((res, e) -> {
                if (e != null) {
                    asyncResponse.resume(e);
                } else {
                    asyncResponse.resume(res);
                }
            });
        });
    }

    private CompletableFuture<Void> trimPartitionedTopic(AsyncResponse asyncResponse, PartitionedTopicMetadata metadata) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(metadata.partitions);
        for (int i = 0; i < metadata.partitions; ++i) {
            TopicName topicNamePartition = this.topicName.getPartition(i);
            try {
                futures.add(this.pulsar().getAdminClient().topics().trimTopicAsync(topicNamePartition.toString()));
                continue;
            }
            catch (Exception e) {
                log.error("[{}] Failed to trim topic {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                throw new RestException(e);
            }
        }
        return FutureUtil.waitForAll(futures).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0));
    }

    protected CompletableFuture<DispatchRateImpl> internalGetDispatchRate(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getDispatchRate).orElseGet(() -> {
            if (applied) {
                DispatchRateImpl namespacePolicy = (DispatchRateImpl)this.getNamespacePolicies((NamespaceName)this.namespaceName).topicDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
                return namespacePolicy == null ? this.dispatchRate() : namespacePolicy;
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetDispatchRate(DispatchRateImpl dispatchRate, boolean isGlobal) {
        if (dispatchRate == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setDispatchRate(dispatchRate);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveDispatchRate(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            TopicPolicies topicPolicies = (TopicPolicies)op.get();
            topicPolicies.setDispatchRate(null);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<DispatchRate> internalGetSubscriptionDispatchRate(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> (DispatchRate)op.map(TopicPolicies::getSubscriptionDispatchRate).orElseGet(() -> {
            if (applied) {
                DispatchRateImpl namespacePolicy = (DispatchRateImpl)this.getNamespacePolicies((NamespaceName)this.namespaceName).subscriptionDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
                return namespacePolicy == null ? this.subscriptionDispatchRate() : namespacePolicy;
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetSubscriptionDispatchRate(DispatchRateImpl dispatchRate, boolean isGlobal) {
        if (dispatchRate == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setSubscriptionDispatchRate(dispatchRate);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveSubscriptionDispatchRate(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            TopicPolicies topicPolicies = (TopicPolicies)op.get();
            topicPolicies.setSubscriptionDispatchRate(null);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<DispatchRate> internalGetSubscriptionLevelDispatchRate(String subName, boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(otp -> {
            DispatchRateImpl rate = otp.map(tp -> (SubscriptionPolicies)tp.getSubscriptionPolicies().get(subName)).map(SubscriptionPolicies::getDispatchRate).orElse(null);
            if (applied && rate == null) {
                return this.internalGetSubscriptionDispatchRate(true, isGlobal);
            }
            return CompletableFuture.completedFuture(rate);
        });
    }

    protected CompletableFuture<Void> internalSetSubscriptionLevelDispatchRate(String subName, DispatchRateImpl dispatchRate, boolean isGlobal) {
        DispatchRateImpl newDispatchRate = DispatchRateImpl.normalize((DispatchRateImpl)dispatchRate);
        if (newDispatchRate == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            topicPolicies.getSubscriptionPolicies().computeIfAbsent(subName, k -> new SubscriptionPolicies()).setDispatchRate(newDispatchRate);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveSubscriptionLevelDispatchRate(String subName, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            TopicPolicies topicPolicies = (TopicPolicies)op.get();
            SubscriptionPolicies sp = (SubscriptionPolicies)topicPolicies.getSubscriptionPolicies().get(subName);
            if (sp == null) {
                return CompletableFuture.completedFuture(null);
            }
            sp.setDispatchRate(null);
            if (sp.checkEmpty()) {
                topicPolicies.getSubscriptionPolicies().remove(subName, sp);
            }
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Optional<Integer>> internalGetMaxConsumersPerSubscription(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getMaxConsumersPerSubscription));
    }

    protected CompletableFuture<Void> internalSetMaxConsumersPerSubscription(Integer maxConsumersPerSubscription, boolean isGlobal) {
        if (maxConsumersPerSubscription != null && maxConsumersPerSubscription < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for maxConsumersPerSubscription");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxConsumersPerSubscription(maxConsumersPerSubscription);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveMaxConsumersPerSubscription(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setMaxConsumersPerSubscription(null);
            ((TopicPolicies)op.get()).setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Long> internalGetCompactionThreshold(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getCompactionThreshold).orElseGet(() -> {
            if (applied) {
                Long namespacePolicy = this.getNamespacePolicies((NamespaceName)this.namespaceName).compaction_threshold;
                return namespacePolicy == null ? this.pulsar().getConfiguration().getBrokerServiceCompactionThresholdInBytes() : namespacePolicy.longValue();
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetCompactionThreshold(Long compactionThreshold, boolean isGlobal) {
        if (compactionThreshold != null && compactionThreshold < 0L) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for compactionThreshold");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setCompactionThreshold(compactionThreshold);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveCompactionThreshold(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            TopicPolicies topicPolicies = (TopicPolicies)op.get();
            topicPolicies.setCompactionThreshold(null);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Optional<PublishRate>> internalGetPublishRate(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getPublishRate));
    }

    protected CompletableFuture<Void> internalSetPublishRate(PublishRate publishRate, boolean isGlobal) {
        if (publishRate == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setPublishRate(publishRate);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Optional<List<CommandSubscribe.SubType>>> internalGetSubscriptionTypesEnabled(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getSubscriptionTypesEnabled));
    }

    protected CompletableFuture<Void> internalSetSubscriptionTypesEnabled(Set<SubscriptionType> subscriptionTypesEnabled, boolean isGlobal) {
        ArrayList subTypes = new ArrayList();
        subscriptionTypesEnabled.forEach(subscriptionType -> subTypes.add(CommandSubscribe.SubType.valueOf((String)subscriptionType.name())));
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setSubscriptionTypesEnabled(subTypes);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveSubscriptionTypesEnabled(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setSubscriptionTypesEnabled(new ArrayList());
            ((TopicPolicies)op.get()).setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Void> internalRemovePublishRate(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setPublishRate(null);
            ((TopicPolicies)op.get()).setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<SubscribeRate> internalGetSubscribeRate(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getSubscribeRate).orElseGet(() -> {
            if (applied) {
                SubscribeRate namespacePolicy = (SubscribeRate)this.getNamespacePolicies((NamespaceName)this.namespaceName).clusterSubscribeRate.get(this.pulsar().getConfiguration().getClusterName());
                return namespacePolicy == null ? this.subscribeRate() : namespacePolicy;
            }
            return null;
        }));
    }

    protected CompletableFuture<Void> internalSetSubscribeRate(SubscribeRate subscribeRate, boolean isGlobal) {
        if (subscribeRate == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setSubscribeRate(subscribeRate);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveSubscribeRate(boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setSubscribeRate(null);
            ((TopicPolicies)op.get()).setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected void handleTopicPolicyException(String methodName, Throwable thr, AsyncResponse asyncResponse) {
        Throwable cause = thr.getCause();
        if (!(cause instanceof WebApplicationException) || ((WebApplicationException)cause).getResponse().getStatus() != 307 && ((WebApplicationException)cause).getResponse().getStatus() != 404) {
            log.error("[{}] Failed to perform {} on topic {}", new Object[]{this.clientAppId(), methodName, this.topicName, cause});
        }
        PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, cause);
    }

    protected CompletableFuture<Void> internalTruncateNonPartitionedTopicAsync(boolean authoritative) {
        return ((CompletableFuture)((CompletableFuture)this.validateAdminAccessForTenantAsync(this.topicName.getTenant()).thenCompose(__ -> this.validateTopicOwnershipAsync(this.topicName, authoritative))).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenCompose(Topic::truncate);
    }

    protected CompletableFuture<Void> internalTruncateTopicAsync(boolean authoritative) {
        if (this.topicName.isPartitioned()) {
            return this.internalTruncateNonPartitionedTopicAsync(authoritative);
        }
        return this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenCompose(meta -> {
            if (meta.partitions > 0) {
                ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(meta.partitions);
                for (int i = 0; i < meta.partitions; ++i) {
                    TopicName topicNamePartition = this.topicName.getPartition(i);
                    try {
                        futures.add(this.pulsar().getAdminClient().topics().truncateAsync(topicNamePartition.toString()));
                        continue;
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to truncate topic {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                        return FutureUtil.failedFuture((Throwable)((Object)new RestException(e)));
                    }
                }
                return FutureUtil.waitForAll(futures);
            }
            return this.internalTruncateNonPartitionedTopicAsync(authoritative);
        });
    }

    protected void internalSetReplicatedSubscriptionStatus(AsyncResponse asyncResponse, String subName, boolean authoritative, boolean enabled) {
        log.info("[{}] Attempting to change replicated subscription status to {} - {} {}", new Object[]{this.clientAppId(), enabled, this.topicName, subName});
        if (!this.topicName.isPersistent()) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Cannot enable/disable replicated subscriptions on non-persistent topics")));
            return;
        }
        if (!this.topicName.isGlobal()) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Cannot enable/disable replicated subscriptions on non-global topics")));
            return;
        }
        CompletionStage validateFuture = this.validateTopicOperationAsync(this.topicName, TopicOperation.SET_REPLICATED_SUBSCRIPTION_STATUS, subName).thenCompose(__ -> this.validateGlobalNamespaceOwnershipAsync(this.namespaceName));
        CompletionStage resultFuture = this.topicName.isPartitioned() ? ((CompletableFuture)validateFuture).thenAccept(__ -> this.internalSetReplicatedSubscriptionStatusForNonPartitionedTopic(asyncResponse, subName, authoritative, enabled)) : ((CompletableFuture)((CompletableFuture)validateFuture).thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false))).thenAccept(partitionMetadata -> {
            if (partitionMetadata.partitions > 0) {
                ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                for (int i = 0; i < partitionMetadata.partitions; ++i) {
                    TopicName topicNamePartition = this.topicName.getPartition(i);
                    try {
                        futures.add(this.pulsar().getAdminClient().topics().setReplicatedSubscriptionStatusAsync(topicNamePartition.toString(), subName, enabled));
                        continue;
                    }
                    catch (Exception e) {
                        log.warn("[{}] Failed to change replicated subscription status to {} - {} {}", new Object[]{this.clientAppId(), enabled, topicNamePartition, subName, e});
                        PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, e);
                        return;
                    }
                }
                FutureUtil.waitForAll(futures).handle((result, exception) -> {
                    if (exception != null) {
                        Throwable t = exception.getCause();
                        if (t instanceof PulsarAdminException.NotFoundException) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Topic or subscription not found")));
                            return null;
                        }
                        if (t instanceof PulsarAdminException.PreconditionFailedException) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Cannot enable/disable replicated subscriptions on non-global topics")));
                            return null;
                        }
                        log.warn("[{}] Failed to change replicated subscription status to {} - {} {}", new Object[]{this.clientAppId(), enabled, this.topicName, subName, t});
                        asyncResponse.resume((Throwable)((Object)new RestException(t)));
                        return null;
                    }
                    asyncResponse.resume((Object)Response.noContent().build());
                    return null;
                });
            } else {
                this.internalSetReplicatedSubscriptionStatusForNonPartitionedTopic(asyncResponse, subName, authoritative, enabled);
            }
        });
        ((CompletableFuture)resultFuture).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.warn("[{}] Failed to change replicated subscription status to {} - {} {}", new Object[]{this.clientAppId(), enabled, this.topicName, subName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private void internalSetReplicatedSubscriptionStatusForNonPartitionedTopic(AsyncResponse asyncResponse, String subName, boolean authoritative, boolean enabled) {
        ((CompletableFuture)((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.getTopicReferenceAsync(this.topicName))).thenAccept(topic -> {
            if (topic == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getTopicNotFoundErrorMessage(this.topicName.toString()))));
                return;
            }
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(this.topicName.toString(), subName))));
                return;
            }
            if (topic instanceof PersistentTopic && sub instanceof PersistentSubscription) {
                if (!((PersistentSubscription)sub).setReplicated(enabled)) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to update cursor properties")));
                    return;
                }
                ((PersistentTopic)topic).checkReplicatedSubscriptionControllerState();
                log.info("[{}] Changed replicated subscription status to {} - {} {}", new Object[]{this.clientAppId(), enabled, this.topicName, subName});
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Cannot enable/disable replicated subscriptions on non-persistent topics")));
            }
        })).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to set replicated subscription status on {} {}", new Object[]{this.clientAppId(), this.topicName, subName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    protected void internalGetReplicatedSubscriptionStatus(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        log.info("[{}] Attempting to get replicated subscription status on {} {}", new Object[]{this.clientAppId(), this.topicName, subName});
        if (!this.topicName.isPersistent()) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Cannot get replicated subscriptions on non-persistent topics")));
            return;
        }
        if (!this.topicName.isGlobal()) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Cannot get replicated subscriptions on non-global topics")));
            return;
        }
        CompletableFuture<Void> validateFuture = this.validateTopicOperationAsync(this.topicName, TopicOperation.GET_REPLICATED_SUBSCRIPTION_STATUS, subName);
        CompletionStage resultFuture = this.topicName.isPartitioned() ? validateFuture.thenAccept(__ -> this.internalGetReplicatedSubscriptionStatusForNonPartitionedTopic(asyncResponse, subName, authoritative)) : ((CompletableFuture)validateFuture.thenCompose(__ -> this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false))).thenAccept(partitionMetadata -> {
            if (partitionMetadata.partitions > 0) {
                ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(partitionMetadata.partitions);
                ConcurrentHashMap status = new ConcurrentHashMap(partitionMetadata.partitions);
                for (int i = 0; i < partitionMetadata.partitions; ++i) {
                    TopicName partition = this.topicName.getPartition(i);
                    futures.add(((CompletableFuture)this.pulsar().getNamespaceService().isServiceUnitOwnedAsync((ServiceUnitId)partition).thenCompose(owned -> {
                        if (owned.booleanValue()) {
                            return this.getReplicatedSubscriptionStatusFromLocalBroker(partition, subName);
                        }
                        try {
                            return this.pulsar().getAdminClient().topics().getReplicatedSubscriptionStatusAsync(partition.toString(), subName).whenComplete((__, throwable) -> {
                                if (throwable != null) {
                                    log.error("[{}] Failed to get replicated subscriptions on {} {}", new Object[]{this.clientAppId(), partition, subName, throwable});
                                }
                            });
                        }
                        catch (Exception e) {
                            log.warn("[{}] Failed to get replicated subscription status on {} {}", new Object[]{this.clientAppId(), partition, subName, e});
                            return FutureUtil.failedFuture((Throwable)e);
                        }
                    })).thenAccept(status::putAll));
                }
                FutureUtil.waitForAll(futures).handle((result, exception) -> {
                    if (exception != null) {
                        Throwable t = exception.getCause();
                        if (t instanceof PulsarAdminException.NotFoundException) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Topic or subscription not found")));
                        } else if (t instanceof PulsarAdminException.PreconditionFailedException) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Cannot get replicated subscriptions on non-global topics")));
                        } else {
                            log.error("[{}] Failed to get replicated subscription status on {} {}", new Object[]{this.clientAppId(), this.topicName, subName, t});
                            asyncResponse.resume((Throwable)((Object)new RestException(t)));
                        }
                        return null;
                    }
                    asyncResponse.resume((Object)status);
                    return null;
                });
            } else {
                this.internalGetReplicatedSubscriptionStatusForNonPartitionedTopic(asyncResponse, subName, authoritative);
            }
        });
        ((CompletableFuture)resultFuture).exceptionally(ex -> {
            if (!PersistentTopicsBase.isRedirectException(ex)) {
                log.error("[{}] Failed to get replicated subscription status on {} {}", new Object[]{this.clientAppId(), this.topicName, subName, ex});
            }
            PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Map<String, Boolean>> getReplicatedSubscriptionStatusFromLocalBroker(TopicName localTopicName, String subName) {
        return this.getTopicReferenceAsync(localTopicName).thenCompose(topic -> {
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, PersistentTopicsBase.getSubNotFoundErrorMessage(localTopicName.toString(), subName))));
            }
            if (topic instanceof PersistentTopic && sub instanceof PersistentSubscription) {
                return CompletableFuture.completedFuture(Collections.singletonMap(localTopicName.toString(), sub.isReplicated()));
            }
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Cannot get replicated subscriptions on non-persistent topics")));
        });
    }

    private void internalGetReplicatedSubscriptionStatusForNonPartitionedTopic(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        ((CompletableFuture)this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.getReplicatedSubscriptionStatusFromLocalBroker(this.topicName, subName))).whenComplete((res, e) -> {
            if (e != null) {
                Throwable cause = FutureUtil.unwrapCompletionException((Throwable)e);
                log.error("[{}] Failed to get replicated subscription status on {} {}", new Object[]{this.clientAppId(), this.topicName, subName, cause});
                PersistentTopicsBase.resumeAsyncResponseExceptionally(asyncResponse, e);
            } else {
                asyncResponse.resume(res);
            }
        });
    }

    protected CompletableFuture<SchemaCompatibilityStrategy> internalGetSchemaCompatibilityStrategy(boolean applied) {
        if (applied) {
            return this.getSchemaCompatibilityStrategyAsync();
        }
        return this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ).thenCompose(n -> this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> {
            if (!op.isPresent()) {
                return null;
            }
            SchemaCompatibilityStrategy strategy = ((TopicPolicies)op.get()).getSchemaCompatibilityStrategy();
            return SchemaCompatibilityStrategy.isUndefined((SchemaCompatibilityStrategy)strategy) ? null : strategy;
        }));
    }

    protected CompletableFuture<Void> internalSetSchemaCompatibilityStrategy(SchemaCompatibilityStrategy strategy) {
        return this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE).thenCompose(__ -> this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setSchemaCompatibilityStrategy(strategy == SchemaCompatibilityStrategy.UNDEFINED ? null : strategy);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        }));
    }

    protected CompletableFuture<Boolean> internalGetSchemaValidationEnforced(boolean applied) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getSchemaValidationEnforced).orElseGet(() -> {
            if (applied) {
                boolean namespacePolicy = this.getNamespacePolicies((NamespaceName)this.namespaceName).schema_validation_enforced;
                return namespacePolicy || this.pulsar().getConfiguration().isSchemaValidationEnforced();
            }
            return false;
        }));
    }

    protected CompletableFuture<Void> internalSetSchemaValidationEnforced(boolean schemaValidationEnforced) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setSchemaValidationEnforced(Boolean.valueOf(schemaValidationEnforced));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<EntryFilters> internalGetEntryFilters(boolean applied, boolean isGlobal) {
        return this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.ENTRY_FILTERS, PolicyOperation.READ).thenCompose(__ -> {
            if (!applied) {
                return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getEntryFilters).orElse(null));
            }
            if (!this.pulsar().getConfiguration().isAllowOverrideEntryFilters()) {
                return CompletableFuture.completedFuture(new EntryFilters(String.join((CharSequence)",", this.pulsar().getConfiguration().getEntryFilterNames())));
            }
            return ((CompletableFuture)this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> op.map(TopicPolicies::getEntryFilters))).thenCompose(policyEntryFilters -> {
                if (policyEntryFilters.isPresent()) {
                    return CompletableFuture.completedFuture((EntryFilters)policyEntryFilters.get());
                }
                return ((CompletableFuture)this.getNamespacePoliciesAsync(this.namespaceName).thenApply(policies -> policies.entryFilters)).thenCompose(nsEntryFilters -> {
                    if (nsEntryFilters != null) {
                        return CompletableFuture.completedFuture(nsEntryFilters);
                    }
                    return CompletableFuture.completedFuture(new EntryFilters(String.join((CharSequence)",", this.pulsar().getConfiguration().getEntryFilterNames())));
                });
            });
        });
    }

    protected CompletableFuture<Void> internalSetEntryFilters(EntryFilters entryFilters, boolean isGlobal) {
        return ((CompletableFuture)this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.ENTRY_FILTERS, PolicyOperation.WRITE).thenAccept(__ -> this.validateEntryFilters(entryFilters))).thenCompose(__ -> this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setEntryFilters(entryFilters);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        }));
    }

    protected CompletableFuture<Void> internalRemoveEntryFilters(boolean isGlobal) {
        return this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.ENTRY_FILTERS, PolicyOperation.WRITE).thenCompose(__ -> this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setEntryFilters(null);
            ((TopicPolicies)op.get()).setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        }));
    }

    protected CompletableFuture<Void> validateShadowTopics(List<String> shadowTopics) {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(shadowTopics.size());
        for (String shadowTopic : shadowTopics) {
            try {
                TopicName shadowTopicName = TopicName.get((String)shadowTopic);
                if (!shadowTopicName.isPersistent()) {
                    return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Only persistent topic can be set as shadow topic")));
                }
                futures.add(this.pulsar().getNamespaceService().checkTopicExists(shadowTopicName).thenAccept(isExists -> {
                    if (!isExists.booleanValue()) {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "Shadow topic [" + shadowTopic + "] not exists.");
                    }
                }));
            }
            catch (IllegalArgumentException e) {
                return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.FORBIDDEN, "Invalid shadow topic name: " + shadowTopic)));
            }
        }
        return FutureUtil.waitForAll(futures);
    }

    protected CompletableFuture<Void> internalSetShadowTopic(List<String> shadowTopics) {
        if (!this.topicName.isPersistent()) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Only persistent source topic is supported with shadow topics.")));
        }
        if (CollectionUtils.isEmpty(shadowTopics)) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Cannot specify empty shadow topics, please use remove command instead.")));
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.SHADOW_TOPIC, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.validateShadowTopics(shadowTopics))).thenCompose(__ -> this.getTopicPoliciesAsyncWithRetry(this.topicName))).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setShadowTopics(shadowTopics);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalDeleteShadowTopics() {
        return ((CompletableFuture)((CompletableFuture)this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.SHADOW_TOPIC, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(shadowTopicName -> this.getTopicPoliciesAsyncWithRetry(this.topicName))).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            List shadowTopics = topicPolicies.getShadowTopics();
            if (CollectionUtils.isEmpty((Collection)shadowTopics)) {
                return CompletableFuture.completedFuture(null);
            }
            topicPolicies.setShadowTopics(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalSetAutoSubscriptionCreation(AutoSubscriptionCreationOverrideImpl autoSubscriptionCreationOverride, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setAutoSubscriptionCreationOverride(autoSubscriptionCreationOverride);
            topicPolicies.setIsGlobal(Boolean.valueOf(isGlobal));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<AutoSubscriptionCreationOverride> internalGetAutoSubscriptionCreation(boolean applied, boolean isGlobal) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName, isGlobal).thenApply(op -> (AutoSubscriptionCreationOverride)op.map(TopicPolicies::getAutoSubscriptionCreationOverride).orElseGet(() -> {
            if (applied) {
                AutoSubscriptionCreationOverride namespacePolicy = this.getNamespacePolicies((NamespaceName)this.namespaceName).autoSubscriptionCreationOverride;
                return namespacePolicy == null ? this.autoSubscriptionCreationOverride() : (AutoSubscriptionCreationOverrideImpl)namespacePolicy;
            }
            return null;
        }));
    }
}

