/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shell.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.pulsar.shell.config.ConfigStore;

public class FileConfigStore
implements ConfigStore {
    private final ObjectMapper mapper = new ObjectMapper();
    private final File file;
    private final ConfigStore.ConfigEntry defaultConfig;
    private FileConfig fileConfig;

    public FileConfigStore(File file, ConfigStore.ConfigEntry defaultConfig) throws IOException {
        this.file = file;
        if (file.exists()) {
            this.read();
        } else {
            this.fileConfig = new FileConfig();
        }
        if (defaultConfig != null) {
            this.defaultConfig = new ConfigStore.ConfigEntry(defaultConfig.getName(), defaultConfig.getValue());
            ConfigStore.cleanupValue(this.defaultConfig);
        } else {
            this.defaultConfig = null;
        }
    }

    private void read() throws IOException {
        try (BufferedInputStream buffered = new BufferedInputStream(new FileInputStream(this.file));){
            try {
                this.fileConfig = (FileConfig)this.mapper.readValue((InputStream)buffered, FileConfig.class);
            }
            catch (MismatchedInputException mismatchedInputException) {
                this.fileConfig = new FileConfig();
            }
        }
    }

    private void write() throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));){
            this.mapper.writeValue((OutputStream)bufferedOutputStream, (Object)this.fileConfig);
        }
    }

    @Override
    public void putConfig(ConfigStore.ConfigEntry entry) throws IOException {
        if ("default".equals(entry.getName())) {
            throw new IllegalArgumentException("'default' can't be modified.");
        }
        ConfigStore.cleanupValue(entry);
        this.fileConfig.configs.put(entry.getName(), entry);
        this.write();
    }

    @Override
    public ConfigStore.ConfigEntry getConfig(String name) {
        if ("default".equals(name)) {
            return this.defaultConfig;
        }
        return this.fileConfig.configs.get(name);
    }

    @Override
    public void deleteConfig(String name) throws IOException {
        if ("default".equals(name)) {
            throw new IllegalArgumentException("'default' can't be deleted.");
        }
        ConfigStore.ConfigEntry old = (ConfigStore.ConfigEntry)this.fileConfig.configs.remove(name);
        if (old != null) {
            this.write();
        }
    }

    @Override
    public List<ConfigStore.ConfigEntry> listConfigs() {
        ArrayList<ConfigStore.ConfigEntry> all = new ArrayList<ConfigStore.ConfigEntry>(this.fileConfig.configs.values());
        if (this.defaultConfig != null) {
            all.add(0, this.defaultConfig);
        }
        return all;
    }

    @Override
    public void setLastUsed(String name) throws IOException {
        this.fileConfig.last = name;
        this.write();
    }

    @Override
    public ConfigStore.ConfigEntry getLastUsed() throws IOException {
        if (this.fileConfig.last != null) {
            return this.getConfig(this.fileConfig.last);
        }
        return null;
    }

    public static class FileConfig {
        private LinkedHashMap<String, ConfigStore.ConfigEntry> configs = new LinkedHashMap();
        private String last;

        public LinkedHashMap<String, ConfigStore.ConfigEntry> getConfigs() {
            return this.configs;
        }

        public String getLast() {
            return this.last;
        }

        public void setConfigs(LinkedHashMap<String, ConfigStore.ConfigEntry> configs) {
            this.configs = configs;
        }

        public void setLast(String last) {
            this.last = last;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileConfig)) {
                return false;
            }
            FileConfig other = (FileConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LinkedHashMap<String, ConfigStore.ConfigEntry> this$configs = this.getConfigs();
            LinkedHashMap<String, ConfigStore.ConfigEntry> other$configs = other.getConfigs();
            if (this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs)) {
                return false;
            }
            String this$last = this.getLast();
            String other$last = other.getLast();
            return !(this$last == null ? other$last != null : !this$last.equals(other$last));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LinkedHashMap<String, ConfigStore.ConfigEntry> $configs = this.getConfigs();
            result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
            String $last = this.getLast();
            result = result * 59 + ($last == null ? 43 : $last.hashCode());
            return result;
        }

        public String toString() {
            return "FileConfigStore.FileConfig(configs=" + this.getConfigs() + ", last=" + this.getLast() + ")";
        }
    }
}

