/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.PulsarAdminTool;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Generate documents automatically.")
public class CmdGenerateDocument
extends CmdBase {
    private static final Logger log = LoggerFactory.getLogger(CmdGenerateDocument.class);
    private final JCommander baseJcommander = new JCommander();
    private final IUsageFormatter usageFormatter = new DefaultUsageFormatter(this.baseJcommander);
    private PulsarAdminTool tool;

    public CmdGenerateDocument(Supplier<PulsarAdmin> admin) {
        super("documents", admin);
        try {
            this.tool = new PulsarAdminTool(new Properties());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            this.baseJcommander.usage();
            return;
        }
        for (Map.Entry<String, Class<?>> c : this.tool.commandMap.entrySet()) {
            try {
                if (c.getKey().equals("documents") || c.getValue() == null) continue;
                this.baseJcommander.addCommand(c.getKey(), c.getValue().getConstructor(Supplier.class).newInstance(admin));
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.err.println();
                this.baseJcommander.usage();
                return;
            }
        }
        this.jcommander.addCommand("generate", (Object)new GenerateDocument());
    }

    public JCommander getBaseJcommander() {
        return this.baseJcommander;
    }

    @Override
    public IUsageFormatter getUsageFormatter() {
        return this.usageFormatter;
    }

    public PulsarAdminTool getTool() {
        return this.tool;
    }

    @Parameters(commandDescription="Generate document for modules")
    private class GenerateDocument
    extends CliCommand {
        @Parameter(description="Please specify the module name, if not, documents will be generated for all modules.Optional modules(clusters, tenants, brokers, broker-stats, namespaces, topics, schemas, bookies,functions, ns-isolation-policy, resource-quotas, functions, sources, sinks)")
        private List<String> modules;

        private GenerateDocument() {
        }

        @Override
        void run() throws PulsarAdminException {
            StringBuilder sb = new StringBuilder();
            if (this.modules == null || this.modules.isEmpty()) {
                CmdGenerateDocument.this.baseJcommander.getCommands().forEach((k, v) -> this.generateDocument(sb, (String)k, (JCommander)v));
            } else {
                String module = GenerateDocument.getOneArgument(this.modules);
                JCommander obj = (JCommander)CmdGenerateDocument.this.baseJcommander.getCommands().get(module);
                this.generateDocument(sb, module, obj);
            }
        }

        private boolean needsLangSupport(String module, String subK) {
            String[] langSupport = new String[]{"localrun", "create", "update"};
            return module.equals("functions") && Arrays.asList(langSupport).contains(subK);
        }

        private void generateDocument(StringBuilder sb, String module, JCommander obj) {
            sb.append("# ").append(module).append("\n\n");
            sb.append(CmdGenerateDocument.this.usageFormatter.getCommandDescription(module)).append("\n");
            sb.append("\n\n```shell\n").append("$ pulsar-admin ").append(module).append(" subcommand").append("\n```");
            sb.append("\n\n");
            CmdBase cmdObj = (CmdBase)obj.getObjects().get(0);
            cmdObj.jcommander.getCommands().forEach((subK, subV) -> {
                sb.append("\n\n## <em>").append((String)subK).append("</em>\n\n");
                sb.append(cmdObj.getUsageFormatter().getCommandDescription(subK)).append("\n\n");
                sb.append("**Command:**\n\n");
                sb.append("```shell\n$ pulsar-admin ").append(module).append(" ").append((String)subK).append(" options").append("\n```\n\n");
                List options = ((JCommander)cmdObj.jcommander.getCommands().get(subK)).getParameters();
                if (options.size() > 0) {
                    sb.append("**Options:**\n\n");
                    sb.append("|Flag|Description|Default|");
                    if (this.needsLangSupport(module, (String)subK)) {
                        sb.append("Support|\n");
                        sb.append("|---|---|---|---|\n");
                    } else {
                        sb.append("\n|---|---|---|\n");
                    }
                }
                options.stream().filter(ele -> ele.getParameterAnnotation() == null || !ele.getParameterAnnotation().hidden()).forEach(option -> {
                    String[] descriptions = option.getDescription().replace("\n", " ").split(" #");
                    sb.append("| `").append(option.getNames()).append("` | ").append(descriptions[0]).append("|").append(option.getDefault()).append("|");
                    if (this.needsLangSupport(module, (String)subK) && descriptions.length > 1) {
                        sb.append(descriptions[1]);
                    }
                    sb.append("|\n");
                });
            });
            System.out.println(sb);
        }
    }
}

