/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.examples;

import java.util.HashMap;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.api.Function;

public class TypedMessageBuilderPublish
implements Function<String, Void> {
    public Void process(String input, Context context) {
        String publishTopic = (String)context.getUserConfigValueOrDefault("publish-topic", (Object)"publishtopic");
        String output = String.format("%s!", input);
        HashMap properties = new HashMap();
        properties.put("input_topic", context.getCurrentRecord().getTopicName().get());
        properties.putAll(context.getCurrentRecord().getProperties());
        try {
            TypedMessageBuilder messageBuilder = context.newOutputMessage(publishTopic, Schema.STRING).value((Object)output).properties(properties);
            if (context.getCurrentRecord().getKey().isPresent()) {
                messageBuilder.key((String)context.getCurrentRecord().getKey().get());
            }
            messageBuilder.eventTime(System.currentTimeMillis()).sendAsync();
        }
        catch (PulsarClientException e) {
            context.getLogger().error(e.toString());
        }
        return null;
    }
}

