/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.examples;

import java.util.stream.Collectors;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.api.Function;
import org.slf4j.Logger;

public class ContextFunction
implements Function<String, Void> {
    public Void process(String input, Context context) {
        Logger LOG = context.getLogger();
        String inputTopics = context.getInputTopics().stream().collect(Collectors.joining(", "));
        String functionName = context.getFunctionName();
        String logMessage = String.format("A message with a value of \"%s\" has arrived on one of the following topics: %s\n", input, inputTopics);
        LOG.info(logMessage);
        String metricName = String.format("function-%s-messages-received", functionName);
        context.recordMetric(metricName, 1.0);
        return null;
    }
}

