---
id: version-2.5.0-helm-overview
title: Apache Pulsar Helm Chart
sidebar_label: Overview
original_id: helm-overview
---

This is the official supported Helm chart to install Apache Pulsar on a cloud-native environment. It was enhanced based on StreamNative's [Helm Chart](https://github.com/streamnative/charts).

## Introduction

The Apache Pulsar Helm chart is one of the most convenient ways 
to operate Pulsar on Kubernetes. This chart contains all the required components to get started and can scale to large deployments.

This chart includes all the components for a complete experience, but each part can be configured to install separately.

- Pulsar core components:
    - ZooKeeper
    - Bookies
    - Brokers
    - Function workers
    - Proxies
- Control Center:
    - Pulsar Manager
    - Prometheus
    - Grafana
    - Alert Manager

It includes support for:

- Security
    - Automatically provisioned TLS certs, using [Jetstack](https://www.jetstack.io/)'s [cert-manager](https://cert-manager.io/docs/)
        - self-signed
        - [Let's Encrypt](https://letsencrypt.org/)
    - TLS Encryption
        - Proxy
        - Broker
        - Toolset
        - Bookie
        - ZooKeeper
    - Authentication
        - JWT
    - Authorization
- Storage
    - Non-persistence storage
    - Persistence Volume
    - Local Persistent Volumes
- Functions
    - Kubernetes Runtime
    - Process Runtime
    - Thread Runtime
- Operations
    - Independent Image Versions for all components, enabling controlled upgrades

## Pulsar Helm chart quick start

For those looking to get up and running with these charts as fast
as possible, in a **non-production** use case, we provide
a [quick start guide](getting-started-helm.md) for Proof of Concept (PoC) deployments.

This guide walks the user through deploying these charts with default
values & features, but *does not* meet production ready requirements.
If you wish to deploy these charts into production under sustained load,
you should follow the complete [Installation Guide](helm-install.md).

## Troubleshooting

We've done our best to make these charts as seamless as possible,
occasionally troubles do surface outside of our control. We've collected
tips and tricks for troubleshooting common issues. Please examine these first before raising an [issue](https://github.com/apache/pulsar/issues/new/choose), and feel free to add to them by raising a [Pull Request](https://github.com/apache/pulsar/compare)!

## Installation

The Apache Pulsar Helm chart contains all required dependencies.

If you are just looking to deploy a Proof of Concept for testing,
we strongly suggest you follow our [Quick Start Guide](getting-started-helm.md) for your first iteration.

1. [Preparation](helm-prepare.md)
2. [Deployment](helm-deploy.md)

## Upgrading

Once your Pulsar Chart is installed, configuration changes and chart
updates should be done using `helm upgrade`.

```bash
git clone https://github.com/apache/pulsar-helm-chart
cd pulsar-helm-chart
helm get values <pulsar-release-name> > pulsar.yaml
helm upgrade <pulsar-release-name> charts/pulsar -f pulsar.yaml
```

For more detailed information, see [Upgrading](helm-upgrade.md).

## Uninstall

To uninstall the Pulsar Chart, run the following command:

```bash
helm delete <pulsar-release-name>
```

For the purposes of continuity, these charts have some Kubernetes objects that are not removed when performing `helm delete`.
These items we require you to *consciously* remove them, as they affect re-deployment should you choose to.

* PVCs for stateful data, which you must *consciously* remove
    - ZooKeeper: This is your metadata.
    - BookKeeper: This is your data.
    - Prometheus: This is your metrics data, which can be safely removed.
* Secrets, if generated by our [prepare release script](https://github.com/apache/pulsar-helm-chart/blob/master/scripts/pulsar/prepare_helm_release.sh). They contain secret keys, tokens, etc. You can use [cleanup release script](https://github.com/apache/pulsar-helm-chart/blob/master/scripts/pulsar/cleanup_helm_release.sh) to remove these secrets and tokens as needed.
