---
id: version-2.9.1-helm-overview
title: Apache Pulsar Helm Chart
sidebar_label: Overview
original_id: helm-overview
---

[Helm chart](https://github.com/apache/pulsar-helm-chart) supports you to install Apache Pulsar in a cloud-native environment.

## Introduction

The Apache Pulsar Helm chart provides one of the most convenient ways to operate Pulsar on Kubernetes. With all the required components, Helm chart is scalable and thus being suitable for large-scale deployments.

The Apache Pulsar Helm chart contains all components to support the features and functions that Pulsar delivers. You can install and configure these components separately.

- Pulsar core components:
    - ZooKeeper
    - Bookies
    - Brokers
    - Function workers
    - Proxies
- Control center:
    - Pulsar Manager
    - Prometheus
    - Grafana

Moreover, Helm chart supports:

- Security
    - Automatically provisioned TLS certificates, using [Jetstack](https://www.jetstack.io/)'s [cert-manager](https://cert-manager.io/docs/)
        - self-signed
        - [Let's Encrypt](https://letsencrypt.org/)
    - TLS Encryption
        - Proxy
        - Broker
        - Toolset
        - Bookie
        - ZooKeeper
    - Authentication
        - JWT
    - Authorization
- Storage
    - Non-persistence storage
    - Persistent volume
    - Local persistent volumes
- Functions
    - Kubernetes Runtime
    - Process Runtime
    - Thread Runtime
- Operations
    - Independent image versions for all components, enabling controlled upgrades

## Quick start

To run with Apache Pulsar Helm chart as fast as possible in a **non-production** use case, we provide a [quick start guide](getting-started-helm.md) for Proof of Concept (PoC) deployments.

This guide walks you through deploying Apache Pulsar Helm chart with default values and features, but it is *not* suitable for deployments in production-ready environments. To deploy the charts in production under sustained load, you can follow the complete [Installation Guide](helm-install.md).

## Troubleshooting

Although we have done our best to make these charts as seamless as possible, troubles do go out of our control occasionally. We have been collecting tips and tricks for troubleshooting common issues. Please check it first before raising an [issue](https://github.com/apache/pulsar/issues/new/choose), and feel free to add your solutions by creating a [Pull Request](https://github.com/apache/pulsar/compare).

## Installation

The Apache Pulsar Helm chart contains all required dependencies.

If you deploy a PoC for testing, we strongly suggest you follow this [Quick Start Guide](getting-started-helm.md) for your first iteration.

1. [Preparation](helm-prepare.md)
2. [Deployment](helm-deploy.md)

## Upgrading

Once the Apache Pulsar Helm chart is installed, you can use `helm upgrade` command to configure and update it.

```bash
helm repo add apache https://pulsar.apache.org/charts
helm repo update
helm get values <pulsar-release-name> > pulsar.yaml
helm upgrade <pulsar-release-name> apache/pulsar -f pulsar.yaml
```

For more detailed information, see [Upgrading](helm-upgrade.md).

## Uninstallation

To uninstall the Apache Pulsar Helm chart, run the following command:

```bash
helm delete <pulsar-release-name>
```

For the purposes of continuity, some Kubernetes objects in these charts cannot be removed by `helm delete` command. It is recommended to *consciously* remove these items, as they affect re-deployment.

* PVCs for stateful data: remove these items.
    - ZooKeeper: This is your metadata.
    - BookKeeper: This is your data.
    - Prometheus: This is your metrics data, which can be safely removed.
* Secrets: if the secrets are generated by the [prepare release script](https://github.com/apache/pulsar-helm-chart/blob/master/scripts/pulsar/prepare_helm_release.sh), they contain secret keys and tokens. You can use the [cleanup release script](https://github.com/apache/pulsar-helm-chart/blob/master/scripts/pulsar/cleanup_helm_release.sh) to remove these secrets and tokens as needed.
