---
id: io-connectors
title: Builtin Connectors
sidebar_label: "Builtin Connectors"
original_id: io-connectors
---

Pulsar distribution includes a set of common connectors that have been packaged and tested with the rest of Apache Pulsar.
These connectors import and export data from some of the most commonly used data systems. Using any these connectors is
as easy as writing a simple connector configuration and running the connector locally or submitting the connector to a
Pulsar Functions cluster.

- [Aerospike Sink Connector](io-aerospike)
- [Cassandra Sink Connector](io-cassandra)
- [Kafka Sink Connector](io-kafka.md#sink)
- [Kafka Source Connector](io-kafka.md#source)
- [Kinesis Sink Connector](io-kinesis.md#sink)
- [RabbitMQ Source Connector](io-rabbitmq.md#source)
- [Twitter Firehose Source Connector](io-twitter)
- [CDC Source Connector based on Debezium and Canal](io-cdc)
- [Netty Source Connector](io-netty.md#source)
- [Hbase Sink Connector](io-hbase.md#sink)
