---
author: Jennifer Huang  
authorURL: https://twitter.com/Jennife06125739  
title: Apache Pulsar Celebrates 300 Contributors

---

Dear Pulsar community,

Over the last few years, the shift to real-time streaming technologies has bolstered the adoption of Pulsar and there has been a major increase in both the interest and adoption of Pulsar in 2020 alone. With Pulsar being sought out by companies developing messaging and event-streaming applications — from Fortune 100 companies to forward-thinking start-ups — the community is growing quickly. 

This community growth has contributed to a new milestone for Pulsar - our [300th contributor](https://github.com/apache/pulsar/graphs/contributors) to the Pulsar repository. This milestone is even more exciting given that we added 100 contributors in the last 8 months alone!

As many of you know, Apache Pulsar is a cloud-native messaging and event streaming platform that has experienced rapid growth since it was committed to open source in 2016. Pulsar graduated as a Top-Level Project (TLP) in September 2018, has launched 92 releases, attracted 5100+ commits from 300 contributors, received 6.5k+ stars, 1.6k+ forks, and 2.2k+ Slack users. 

The influx of developers joining the Pulsar community is in large part due to the high market demand for next-generation messaging technologies, big-data insights, and real-time streaming. Top developers and industry leaders are joining the Pulsar community for the opportunity to help shape the future of this technology. 

## Community Events
To meet the high demand for education and training in the Pulsar community, the community has launched some key initiatives this year. We host weekly TGIP(Thank God It's Pulsar) training, which features Pulsar thought-leaders and Pulsar PMC Members. To meet global demand, we currently host two different weekly trainings. One [TGIP training](https://www.youtube.com/watch?v=Vc_a2ppRzlI&list=PLqRma1oIkcWhWAhKgImEeRiQi5vMlqTc-) runs on Pacific Time, and the other [TGIP-CN training](https://github.com/streamnative/tgip-cn) runs on Beijing Time. 

We also host monthly [webinars](https://www.youtube.com/watch?v=mncXc_T6JkU&list=PLqRma1oIkcWhfmUuJrMM5YIG8hjju62Ev) to bring together Pulsar and messaging community thought-leaders to share best practices, insights and product news. Thank [Matteo Merli](https://twitter.com/merlimat), [Addison Higham](https://twitter.com/addisonjh), Joe Francis, [Shivji Kumar Jha](https://twitter.com/ShivjiJha), [Devin Bost](https://twitter.com/DevinBost), [Pierre Zemb](https://twitter.com/PierreZ), [Jesse Anderson](https://twitter.com/jessetanderson), [Sijie Guo](https://twitter.com/sijieg) and other speakers for contributing so much valuable knowledge.

This year also marked our first global summit, held in June 2020. Hosted by StreamNative and Splunk, the first-ever [Pulsar Summit Virtual Conference](https://pulsar-summit.org/) featured 30+ talks from 20+ organizations. Thank all speakers for sharing your stories about Pulsar, and thank you to all of the attendees for joining the event.

We are excited to announce that we will be hosting Pulsar Summit Asia 2020 on November 28 and 29, and the call for presentations for this event will be coming soon.

## Pulsar Adoption
In addition to the growth in contributors, we are excited to see accelerated adoption of Pulsar in PoC and production environments. Pulsar is helping companies globally to unlock the power of real-time data and to grow their businesses with efficiency and simplicity. 

Key adoption stories illustrate Pulsar's ability to handle mission-critical applications. These include [Tencent’s adoption](https://streamnative.io/success-stories/tencent) of Pulsar for its transactional billing system, which processes more than 10 billion transactions and 10+ TBs of data daily. [Verizon Media is another success story](https://www.youtube.com/watch?v=FXQvsHz_S1A), having operated Pulsar in production for more than 5 years, managing millions of write requests/second, and supporting the business across six global data centers. Most recently Splunk, which had used Kafka in production environments for years, [adopted Pulsar for their new data processor](https://www.youtube.com/watch?v=_q8s3_0-BRQ). 

For more insights on Pulsar adoption, you can find a list for companies using or contributing to Apache Pulsar on [Pulsar Powered by page](http://pulsar.apache.org/en/powered-by/). 

## Ecosystem Development
Committed community partners have also contributed to key project advancements. Below, we look at two recent product launches.

### OVHCloud Helps Companies Move from Kafka to Pulsar
In March 2020, [OVHCloud and StreamNative launched Kafka-on-Pulsar (KoP)](https://streamnative.io/blog/tech/2020-03-24-bring-native-kafka-protocol-support-to-apache-pulsar), the result of the two companies working closely in partnership. [KoP](https://github.com/streamnative/kop) enables Kafka users to migrate their existing Kafka applications and services to Pulsar without modifying the code. Although only recently released, KoP has already been adopted by several organizations and is being used in production environments. Moreover, KoP's availability is helping to expand Pulsar's adoption.

### China Mobile Helps Companies Move from RabbitMQ to Pulsar
In June 2020, [China Mobile and StreamNative announced the launch of another major platform upgrade, AMQP-on-Pulsar (AoP)](https://streamnative.io/blog/tech/2020-06-15-announcing-aop-on-pulsar). Similar to KoP, [AoP](https://github.com/streamnative/aop) allows organizations currently using RabbitMQ (or other AMQP message brokers) to migrate existing applications and services to Pulsar without code modification. Again, this is a key initiative that will help drive the adoption and usage of Pulsar.

You can find a number of other connections and integrations, such as MQTT-on-Pulsar for building IoT applications, in the [StreamNative Hub](https://hub.streamnative.io/).

These events and initiatives illustrate the Pulsar community's firm commitment to education and ecosystem development. More importantly, they demonstrate the momentum and growth we can expect in the future.

## Special Thanks
We would like to thank the Pulsar community, contributors and committers, who have helped to drive development, growth and adoption for Pulsar. We would especially like to recognize our distinguished contributors and committers (including but not limited to): 
- [Matteo Merli](https://github.com/merlimat) from [Splunk](https://www.splunk.com/)
- [Rajan Dhabalia](https://github.com/rdhabalia) from [Verizon Media](https://www.verizonmedia.com/)
- [Sijie Guo](https://github.com/sijie) from [StreamNative](https://streamnative.io/)
- [Sanjeev Kulkarni](https://github.com/srkukarni) from [Splunk](https://www.splunk.com/)
- [Boyang Jerry Peng](https://github.com/jerrypeng) from [Splunk](https://www.splunk.com/)
- [Ivan Brendan Kelly](https://github.com/ivankelly) from [Splunk](https://www.splunk.com/)
- [Penghui Li](https://github.com/codelipenghui) from [Zhaopin.com](http://www.zhaopin.com/)
- [Jia Zhai](https://github.com/jiazhai) from [StreamNative](https://streamnative.io/)

To view other contributors, see [Pulsar contributor list](https://github.com/apache/pulsar/graphs/contributors).

## Get Involved
We invite you to join this fast-growing community. Together, we will continue to develop technology to meet today’s most innovative messaging and event-streaming use cases and to help companies unlock the value of real-time data. 

Whether it is joining our [Pulsar Slack channel](https://apache-pulsar.slack.com/), sharing your Pulsar story via a sponsored [webinar](https://www.youtube.com/watch?v=mncXc_T6JkU&list=PLqRma1oIkcWhfmUuJrMM5YIG8hjju62Ev) or case study, joining a [TGIP](https://github.com/streamnative/tgip)/[TGIP-CN](https://github.com/streamnative/tgip-cn), or attending or speaking at the next Pulsar Summit, we look forward to connecting with you. 

You can also subscribe our mailing lists: [users@pulsar.apache.org](mailto:users-subscribe@pulsar.apache.org) and [dev@pulsar.apache.org](mailto:dev-subscribe@pulsar.apache.org).