/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method createAttributeNS raises an INVALID_CHARACTER_ERR if the specified
 * qualified name contains an illegal character
 * <p>
 * Invoke the createAttributeNS method on this Document object with a valid value for
 * namespaceURI, and qualifiedNames that contain illegal characters.  Check if the an
 * INVALID_CHARACTER_ERR was thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS</a>
 */
public class documentcreateattributeNS03 {
    @Test
    void testRun() throws Throwable {
        Attr attribute;
        String namespaceURI = "http://www.w3.org/DOM/Test/Level2";
        String[] qualifiedNames = { "/", "//", "\\", ";", "&", "*", "]]", ">", "<" };
        Document doc = load("staffNS", false);
        for (String qualifiedName : qualifiedNames) {
            DOMException ex = assertThrows(DOMException.class, () -> doc.createAttributeNS(namespaceURI, qualifiedName));
            assertEquals(DOMException.INVALID_CHARACTER_ERR, ex.code, "documentcreateattributeNS03");
        }
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentcreateattributeNS03";
    }

}
