/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.antcontrib.net.Prop;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class PostTask
extends Task {
    private Hashtable props = new Hashtable();
    private URL to = null;
    private File propsFile = null;
    private String textProps = null;
    private String encoding = "UTF-8";
    private File log = null;
    private boolean append = true;
    private boolean verbose = true;
    private boolean wantResponse = true;
    private long maxwait = 180000L;
    private boolean failOnError = false;
    private URLConnection connection = null;
    private Thread currentRunner = null;

    public void setTo(URL uRL) {
        this.to = uRL;
    }

    public void setFile(File file) {
        this.propsFile = file;
    }

    public void setLogfile(File file) {
        this.log = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setWantresponse(boolean bl) {
        this.wantResponse = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setMaxwait(int n) {
        this.maxwait = n * 1000;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void addConfiguredProp(Prop prop) throws BuildException {
        String string = prop.getName();
        if (string == null) {
            throw new BuildException("name is null", this.getLocation());
        }
        String string2 = prop.getValue();
        if (string2 == null) {
            string2 = this.getProject().getProperty(string);
        }
        if (string2 == null) {
            throw new BuildException("value is null", this.getLocation());
        }
        this.props.put(string, string2);
    }

    public void addText(String string) {
        this.textProps = string;
    }

    public void execute() throws BuildException {
        block9: {
            if (this.to == null) {
                throw new BuildException("'to' attribute is required", this.getLocation());
            }
            final String string = this.getContent();
            try {
                this.log("Opening connection for post to " + this.to.toString() + "...");
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FilterOutputStream filterOutputStream = null;
                        try {
                            PostTask.this.connection = PostTask.this.to.openConnection();
                            PostTask.this.connection.setDoInput(true);
                            PostTask.this.connection.setDoOutput(true);
                            PostTask.this.connection.setUseCaches(false);
                            PostTask.this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Connected, sending data...");
                            }
                            filterOutputStream = new DataOutputStream(PostTask.this.connection.getOutputStream());
                            if (PostTask.this.verbose) {
                                PostTask.this.log(string);
                            }
                            ((DataOutputStream)filterOutputStream).writeBytes(string);
                            ((DataOutputStream)filterOutputStream).flush();
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Data sent.");
                            }
                        }
                        catch (Exception exception) {
                            if (PostTask.this.failOnError) {
                                throw new BuildException((Throwable)exception, PostTask.this.getLocation());
                            }
                        }
                        finally {
                            try {
                                filterOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                };
                thread.run();
                thread.join(this.maxwait);
                if (thread.isAlive()) {
                    thread.interrupt();
                    if (this.failOnError) {
                        throw new BuildException("maxwait exceeded, unable to send data", this.getLocation());
                    }
                    return;
                }
                if (this.wantResponse) {
                    if (this.verbose) {
                        this.log("Waiting for response...");
                    }
                    this.currentRunner = thread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            OutputStreamWriter outputStreamWriter = null;
                            BufferedReader bufferedReader = null;
                            try {
                                String string;
                                bufferedReader = new BufferedReader(new InputStreamReader(PostTask.this.connection.getInputStream()));
                                if (PostTask.this.log != null) {
                                    outputStreamWriter = new FileWriter(PostTask.this.log.getAbsolutePath(), PostTask.this.append);
                                }
                                while (null != (string = bufferedReader.readLine())) {
                                    if (PostTask.this.currentRunner != this) {
                                        break;
                                    }
                                    string = PostTask.this.decode(string);
                                    if (PostTask.this.verbose) {
                                        PostTask.this.log(string);
                                    }
                                    if (outputStreamWriter == null) continue;
                                    outputStreamWriter.write(string);
                                }
                            }
                            catch (Exception exception) {
                                if (PostTask.this.failOnError) {
                                    throw new BuildException((Throwable)exception, PostTask.this.getLocation());
                                }
                            }
                            finally {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Exception exception) {}
                                try {
                                    if (outputStreamWriter != null) {
                                        outputStreamWriter.flush();
                                        outputStreamWriter.close();
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                    };
                    thread.run();
                    thread.join(this.maxwait);
                    if (thread.isAlive()) {
                        this.currentRunner = null;
                        thread.interrupt();
                        if (this.failOnError) {
                            throw new BuildException("maxwait exceeded, unable to receive data", this.getLocation());
                        }
                    }
                }
                this.log("Post complete.");
            }
            catch (Exception exception) {
                if (!this.failOnError) break block9;
                throw new BuildException((Throwable)exception);
            }
        }
    }

    private String getContent() {
        if (this.propsFile != null) {
            this.loadFile(this.propsFile);
        }
        if (this.textProps != null) {
            this.loadTextProps(this.textProps);
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Enumeration enumeration = this.props.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.props.get(string);
                stringBuffer.append(this.encode(string));
                stringBuffer.append("=");
                stringBuffer.append(this.encode(string2));
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append("&");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) throws BuildException {
        block8: {
            Properties properties = new Properties();
            try {
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        properties.load(fileInputStream);
                    }
                    finally {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    this.addProperties(properties);
                    break block8;
                }
                this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
            }
            catch (IOException iOException) {
                if (!this.failOnError) break block8;
                throw new BuildException((Throwable)iOException, this.location);
            }
        }
    }

    private void loadTextProps(String string) {
        Properties properties = new Properties();
        Project project = this.getProject();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf("{");
            int n2 = string4.indexOf("}");
            if (n <= -1 || n2 <= -1 || n2 <= n || (string3 = project.getProperty(string2 = string4.substring(n + 1, n2 - n))) == null) continue;
            properties.setProperty(string2, string3);
        }
        this.addProperties(properties);
    }

    private void addProperties(Properties properties) {
        this.resolveAllProperties(properties);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.props.put(string, string2);
        }
    }

    private void resolveAllProperties(Properties properties) throws BuildException {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            boolean bl = false;
            while (!bl) {
                Vector vector = new Vector();
                Vector vector2 = new Vector();
                ProjectHelper.parsePropertyString((String)string2, vector, vector2);
                bl = true;
                if (vector2.size() == 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration2 = vector.elements();
                Enumeration enumeration3 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    if (string3 == null) {
                        String string4 = (String)enumeration3.nextElement();
                        if (string4.equals(string)) {
                            throw new BuildException("Property " + string + " was circularly " + "defined.");
                        }
                        string3 = this.getProject().getProperty(string4);
                        if (string3 == null) {
                            if (properties.containsKey(string4)) {
                                string3 = properties.getProperty(string4);
                                bl = false;
                            } else {
                                string3 = "${" + string4 + "}";
                            }
                        }
                    }
                    stringBuffer.append(string3);
                }
                string2 = stringBuffer.toString();
                properties.put(string, string2);
            }
        }
    }

    public String encode(String string) throws BuildException {
        return this.invokeCoder("encode", string);
    }

    public String decode(String string) throws BuildException {
        return this.invokeCoder("decode", string);
    }

    public String invokeCoder(String string, String string2) {
        try {
            Class<?> clazz = null;
            if (string.equals("encode")) {
                clazz = Class.forName("java.net.URLEncoder");
            } else if (string.equals("decode")) {
                clazz = Class.forName("java.net.URLDecoder");
            }
            if (clazz != null) {
                Class[] classArray = new Class[]{string2.getClass(), this.encoding.getClass()};
                Method method = null;
                try {
                    method = clazz.getMethod(string, classArray);
                    return (String)method.invoke(clazz, (Object[])new String[]{string2, this.encoding});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    classArray = new Class[]{string2.getClass()};
                    try {
                        method = clazz.getMethod(string, classArray);
                        return (String)method.invoke(clazz, (Object[])new String[]{string2});
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        throw new BuildException((Throwable)noSuchMethodException2);
                    }
                }
            }
            throw new IllegalArgumentException("Method name must be one of 'encode' or 'decode'.");
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }
}

