/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.*;
import static org.w3c.domts.DOMTest.isExpandEntityReferences;
import static org.w3c.domts.DOMTest.load;


/**
 * The "setNamedItemNS(arg)" method for a
 * NamedNodeMap should raise NO_MODIFICATION_ALLOWED_ERR DOMException if
 * this map is readonly.
 * <p>
 * Retrieve a list of "gender" elements. Get access to the THIRD element
 * which contains an ENTITY_REFERENCE child node.  Get access to the node's
 * map. Try to add an attribute node specified by arg with
 * method setNamedItemNS(arg).  This should result in NO_MODIFICATION_ALLOWED_ERR
 * DOMException.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-setNamedItemNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-setNamedItemNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])</a>
 */
public class setNamedItemNS04 {
    @Test
    @Disabled
    public void testRun() throws Throwable {
        String namespaceURI = "http://www.w3.org/2000/xmlns/";
        String localName = "local1";
        Document doc = load("staffNS", true);

        Node child;
        if (!isExpandEntityReferences()) {
            NodeList elementList = doc.getElementsByTagName("gender");
            Node testAddress = elementList.item(2);
            NodeList nList = testAddress.getChildNodes();
            child = nList.item(0);
        } else {
            child = doc.createEntityReference("ent4");
        }

        NodeList n2List = child.getChildNodes();
        Node child2 = n2List.item(0);
        assertNotNull(child2, "notnull");
        NamedNodeMap attributes = child2.getAttributes();
        Node arg = attributes.getNamedItemNS(namespaceURI, localName);

        DOMException ex = assertThrows(DOMException.class, () -> attributes.setNamedItemNS(arg));
        assertEquals(DOMException.NO_MODIFICATION_ALLOWED_ERR, ex.code, "throw_NO_MODIFICATION_ALLOWED_ERR");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/setNamedItemNS04";
    }

}
