/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.util.FileUtils;

public class AntCallBack
extends Task {
    private File dir = null;
    private String antFile = null;
    private String target = null;
    private String output = null;
    private boolean inheritAll = true;
    private boolean inheritRefs = false;
    private Vector properties = new Vector();
    private Vector references = new Vector();
    private Project newProject;
    private PrintStream out = null;
    private String returnName = null;

    public void setInheritAll(boolean bl) {
        this.inheritAll = bl;
    }

    public void setInheritRefs(boolean bl) {
        this.inheritRefs = bl;
    }

    public void init() {
        this.newProject = new Project();
        this.newProject.setJavaVersionProperty();
        this.newProject.addTaskDefinition("property", (Class)this.project.getTaskDefinitions().get("property"));
    }

    private void reinit() {
        this.init();
        int n = this.properties.size();
        for (int i = 0; i < n; ++i) {
            Property property = (Property)this.properties.elementAt(i);
            Property property2 = (Property)this.newProject.createTask("property");
            property2.setName(property.getName());
            if (property.getValue() != null) {
                property2.setValue(property.getValue());
            }
            if (property.getFile() != null) {
                property2.setFile(property.getFile());
            }
            if (property.getResource() != null) {
                property2.setResource(property.getResource());
            }
            if (property.getPrefix() != null) {
                property2.setPrefix(property.getPrefix());
            }
            if (property.getRefid() != null) {
                property2.setRefid(property.getRefid());
            }
            if (property.getEnvironment() != null) {
                property2.setEnvironment(property.getEnvironment());
            }
            if (property.getClasspath() != null) {
                property2.setClasspath(property.getClasspath());
            }
            this.properties.setElementAt(property2, i);
        }
    }

    private void initializeProject() {
        Object object;
        Object object2;
        Enumeration enumeration;
        Object object3;
        DefaultLogger defaultLogger;
        this.newProject.setInputHandler(this.getProject().getInputHandler());
        Vector vector = this.project.getBuildListeners();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.newProject.addBuildListener((BuildListener)vector.elementAt(i));
        }
        if (this.output != null) {
            File file = null;
            file = this.dir != null ? FileUtils.newFileUtils().resolveFile(this.dir, this.output) : this.getProject().resolveFile(this.output);
            try {
                this.out = new PrintStream(new FileOutputStream(file));
                defaultLogger = new DefaultLogger();
                defaultLogger.setMessageOutputLevel(2);
                defaultLogger.setOutputPrintStream(this.out);
                defaultLogger.setErrorPrintStream(this.out);
                this.newProject.addBuildListener((BuildListener)defaultLogger);
            }
            catch (IOException iOException) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        Hashtable hashtable = this.project.getTaskDefinitions();
        defaultLogger = hashtable.keys();
        while (defaultLogger.hasMoreElements()) {
            object3 = (String)defaultLogger.nextElement();
            if (((String)object3).equals("property")) continue;
            enumeration = (Class)hashtable.get(object3);
            this.newProject.addTaskDefinition((String)object3, (Class)((Object)enumeration));
        }
        object3 = this.project.getDataTypeDefinitions();
        enumeration = ((Hashtable)object3).keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (Class)((Hashtable)object3).get(object2);
            this.newProject.addDataTypeDefinition((String)object2, (Class)object);
        }
        this.getProject().copyUserProperties(this.newProject);
        if (!this.inheritAll) {
            this.newProject.setSystemProperties();
        } else {
            object2 = this.getProject().getProperties();
            enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement().toString();
                if ("basedir".equals(object) || "ant.file".equals(object)) continue;
                String string = ((Hashtable)object2).get(object).toString();
                if (this.newProject.getProperty((String)object) != null) continue;
                this.newProject.setNewProperty((String)object, string);
            }
        }
    }

    protected void handleOutput(String string) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(string, false);
        } else {
            super.handleOutput(string);
        }
    }

    protected void handleErrorOutput(String string) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(string, true);
        } else {
            super.handleErrorOutput(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.setAntfile(this.getProject().getProperty("ant.file"));
        File file = this.dir;
        String string = this.antFile;
        String string2 = this.target;
        try {
            if (this.newProject == null) {
                this.reinit();
            }
            if (this.dir == null && this.inheritAll) {
                this.dir = this.project.getBaseDir();
            }
            this.initializeProject();
            if (this.dir != null) {
                this.newProject.setBaseDir(this.dir);
                if (file != null) {
                    this.newProject.setInheritedProperty("basedir", this.dir.getAbsolutePath());
                }
            } else {
                this.dir = this.project.getBaseDir();
            }
            this.overrideProperties();
            if (this.antFile == null) {
                throw new BuildException("Attribute target is required.", this.location);
            }
            File file2 = FileUtils.newFileUtils().resolveFile(this.dir, this.antFile);
            this.antFile = file2.getAbsolutePath();
            this.log("calling target " + (this.target != null ? this.target : "[default]") + " in build file " + this.antFile.toString(), 3);
            this.newProject.setUserProperty("ant.file", this.antFile);
            ProjectHelper.configureProject((Project)this.newProject, (File)new File(this.antFile));
            if (this.target == null) {
                this.target = this.newProject.getDefaultTarget();
            }
            this.addReferences();
            if (this.newProject.getBaseDir().equals(this.project.getBaseDir()) && this.newProject.getProperty("ant.file").equals(this.project.getProperty("ant.file")) && this.getOwningTarget() != null && this.target.equals(this.getOwningTarget().getName())) {
                throw new BuildException("antcallback task calling its own parent target");
            }
            this.newProject.executeTarget(this.target);
            if (this.returnName != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.returnName, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    String string4 = this.newProject.getUserProperty(string3);
                    if (string4 != null) {
                        this.project.setUserProperty(string3, string4);
                        continue;
                    }
                    string4 = this.newProject.getProperty(string3);
                    if (string4 == null) continue;
                    this.project.setProperty(string3, string4);
                }
            }
        }
        finally {
            this.newProject = null;
            if (this.output != null && this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception exception) {}
            }
            this.dir = file;
            this.antFile = string;
            this.target = string2;
        }
    }

    private void overrideProperties() throws BuildException {
        Enumeration enumeration = this.properties.elements();
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            property.setProject(this.newProject);
            property.execute();
        }
        this.getProject().copyInheritedProperties(this.newProject);
    }

    private void addReferences() throws BuildException {
        Object object;
        Enumeration<Object> enumeration;
        Hashtable hashtable = (Hashtable)this.project.getReferences().clone();
        Hashtable hashtable2 = this.newProject.getReferences();
        if (this.references.size() > 0) {
            enumeration = this.references.elements();
            while (enumeration.hasMoreElements()) {
                object = (Reference)((Object)enumeration.nextElement());
                String string = object.getRefId();
                if (string == null) {
                    throw new BuildException("the refid attribute is required for reference elements");
                }
                if (!hashtable.containsKey(string)) {
                    this.log("Parent project doesn't contain any reference '" + string + "'", 1);
                    continue;
                }
                hashtable.remove(string);
                String string2 = object.getToRefid();
                if (string2 == null) {
                    string2 = string;
                }
                this.copyReference(string, string2);
            }
        }
        if (this.inheritRefs) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (hashtable2.containsKey(object)) continue;
                this.copyReference((String)object, (String)object);
            }
        }
    }

    private void copyReference(String string, String string2) {
        Method method;
        Object object = this.project.getReference(string);
        Class<?> clazz = object.getClass();
        Object object2 = object;
        try {
            method = clazz.getMethod("clone", new Class[0]);
            if (method != null) {
                object2 = method.invoke(object, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object2 instanceof ProjectComponent) {
            ((ProjectComponent)object2).setProject(this.newProject);
        } else {
            try {
                method = clazz.getMethod("setProject", Project.class);
                if (method != null) {
                    method.invoke(object2, this.newProject);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                String string3 = "Error setting new project instance for reference with id " + string;
                throw new BuildException(string3, (Throwable)exception, this.location);
            }
        }
        this.newProject.addReference(string2, object2);
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setAntfile(String string) {
        this.antFile = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public Property createProperty() {
        if (this.newProject == null) {
            this.reinit();
        }
        Property property = new Property();
        property.setProject(this.newProject);
        property.setTaskName("property");
        this.properties.addElement(property);
        return property;
    }

    public Property createParam() {
        return this.createProperty();
    }

    public void setReturn(String string) {
        this.returnName = string;
    }

    public void addReference(Reference reference) {
        this.references.addElement(reference);
    }

    public static class Reference
    extends org.apache.tools.ant.types.Reference {
        private String targetid = null;

        public void setToRefid(String string) {
            this.targetid = string;
        }

        public String getToRefid() {
            return this.targetid;
        }
    }
}

