/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class For
extends Task {
    private static boolean antVersionOk = true;
    private String list;
    private String param;
    private String delimiter = ",";
    private Path currPath;
    private boolean trim;
    private Reflector macroDef;
    private Object nestedSequential;

    public For() {
        if (!antVersionOk) {
            throw new BuildException("This task only works for ant >= 1.6Beta3");
        }
    }

    public void setTrim(boolean bl) {
        this.trim = bl;
    }

    public void setList(String string) {
        this.list = string;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setParam(String string) {
        this.param = string;
    }

    public Path createPath() {
        if (this.currPath == null) {
            this.currPath = new Path(this.getProject());
        }
        return this.currPath;
    }

    public Object createSequential() {
        this.macroDef = new Reflector("org.apache.tools.ant.taskdefs.MacroDef");
        this.macroDef.call("setProject", this.getProject());
        return this.macroDef.call("createSequential");
    }

    public void execute() {
        if (this.list == null && this.currPath == null) {
            throw new BuildException("You must have a list or path to iterate through");
        }
        if (this.param == null) {
            throw new BuildException("You must supply a property name to set on each iteration in param");
        }
        if (this.macroDef == null) {
            throw new BuildException("You must supply an embedded sequential to perform");
        }
        this.doTheTasks();
    }

    private void doSequentialIteration(String string) {
        Reflector reflector = new Reflector("org.apache.tools.ant.taskdefs.MacroInstance");
        reflector.call("setProject", this.getProject());
        reflector.call("setOwningTarget", this.getOwningTarget());
        reflector.call("setMacroDef", this.macroDef.getObject());
        reflector.call("setDynamicAttribute", this.param, string);
        reflector.call("execute");
    }

    private void doTheTasks() {
        Object object;
        Reflector reflector = new Reflector("org.apache.tools.ant.taskdefs.MacroDef$Attribute");
        reflector.call("setName", this.param);
        this.macroDef.call("addConfiguredAttribute", reflector.getObject());
        if (this.list != null) {
            object = new StringTokenizer(this.list, this.delimiter);
            String[] stringArray = new String[((StringTokenizer)object).countTokens()];
            boolean bl = false;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                if (this.trim) {
                    string = string.trim();
                }
                this.doSequentialIteration(string);
            }
        }
        object = new String[]{};
        if (this.currPath != null) {
            object = this.currPath.list();
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            File file = new File((String)object[i]);
            this.doSequentialIteration(file.getAbsolutePath());
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.apache.tools.ant.taskdefs.MacroInstance");
            Class<?> clazz2 = Class.forName("org.apache.tools.ant.taskdefs.MacroDef");
            Method method = clazz2.getMethod("createSequential", new Class[0]);
        }
        catch (Throwable throwable) {
            antVersionOk = false;
        }
    }

    private static class Reflector {
        private Object obj;

        public Reflector(String string) {
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.obj = constructor.newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                throw new BuildException(throwable);
            }
        }

        public Reflector(Object object) {
            this.obj = object;
        }

        public Object getObject() {
            return this.obj;
        }

        public Object call(String string) {
            try {
                Method method = this.obj.getClass().getMethod(string, new Class[0]);
                return method.invoke(this.obj, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof BuildException) {
                    throw (BuildException)throwable;
                }
                throw new BuildException(throwable);
            }
            catch (Throwable throwable) {
                throw new BuildException(throwable);
            }
        }

        public Object callExplicit(String string, String string2, Object object) {
            try {
                Class<?> clazz = Class.forName(string2);
                Method method = this.obj.getClass().getMethod(string, clazz);
                return method.invoke(this.obj, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof BuildException) {
                    throw (BuildException)throwable;
                }
                throw new BuildException(throwable);
            }
            catch (Throwable throwable) {
                throw new BuildException(throwable);
            }
        }

        public Object call(String string, Object object) {
            try {
                Method method = this.obj.getClass().getMethod(string, object.getClass());
                return method.invoke(this.obj, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof BuildException) {
                    throw (BuildException)throwable;
                }
                throw new BuildException(throwable);
            }
            catch (Throwable throwable) {
                throw new BuildException(throwable);
            }
        }

        public Object call(String string, Object object, Object object2) {
            try {
                Method method = this.obj.getClass().getMethod(string, object.getClass(), object2.getClass());
                return method.invoke(this.obj, object, object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof BuildException) {
                    throw (BuildException)throwable;
                }
                throw new BuildException(throwable);
            }
            catch (Throwable throwable) {
                throw new BuildException(throwable);
            }
        }
    }
}

